/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.terminal;

import com.github.ajalt.mordant.terminal.AnsiLevel;
import com.github.ajalt.mordant.terminal.TerminalInfo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0002J\u001c\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u000bJ;\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0011J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0006H\u0002J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0014H\u0002J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0014H\u0002J\u000f\u0010\u000f\u001a\u0004\u0018\u00010\tH\u0002\u00a2\u0006\u0002\u0010\u0017J\b\u0010\u0018\u001a\u00020\u0004H\u0002J\b\u0010\u0019\u001a\u00020\u0004H\u0002J\b\u0010\u001a\u001a\u00020\u0004H\u0002J\b\u0010\u001b\u001a\u00020\u0004H\u0002J\b\u0010\u001c\u001a\u00020\u0004H\u0002J\b\u0010\u001d\u001a\u00020\u0004H\u0002J\b\u0010\u001e\u001a\u00020\u0004H\u0002J\u000f\u0010\u000e\u001a\u0004\u0018\u00010\tH\u0002\u00a2\u0006\u0002\u0010\u0017\u00a8\u0006\u001f"}, d2={"Lcom/github/ajalt/mordant/terminal/TerminalDetection;", "", "()V", "ansiHyperLinks", "", "ansiLevel", "Lcom/github/ajalt/mordant/terminal/AnsiLevel;", "detectSize", "Lkotlin/Pair;", "", "timeoutMs", "", "detectTerminal", "Lcom/github/ajalt/mordant/terminal/TerminalInfo;", "width", "height", "hyperlinks", "(Lcom/github/ajalt/mordant/terminal/AnsiLevel;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Boolean;)Lcom/github/ajalt/mordant/terminal/TerminalInfo;", "forcedColor", "getColorTerm", "", "getTerm", "getTermProgram", "()Ljava/lang/Integer;", "isDomTerm", "isIntellijConsole", "isRecentITerm", "isVsCodeTerminal", "isWindowsTerminal", "stdinInteractive", "stdoutInteractive", "mordant"})
public final class TerminalDetection {
    public static final TerminalDetection INSTANCE;

    @NotNull
    public final TerminalInfo detectTerminal(@Nullable AnsiLevel ansiLevel, @Nullable Integer width, @Nullable Integer height, @Nullable Boolean hyperlinks) {
        Integer n = width;
        if (n == null) {
            n = this.width();
        }
        int n2 = n != null ? n : 79;
        Integer n3 = height;
        if (n3 == null) {
            n3 = this.height();
        }
        int n4 = n3 != null ? n3 : 24;
        AnsiLevel ansiLevel2 = ansiLevel;
        if (ansiLevel2 == null) {
            ansiLevel2 = this.ansiLevel();
        }
        Boolean bl = hyperlinks;
        return new TerminalInfo(n2, n4, ansiLevel2, bl != null ? bl.booleanValue() : this.ansiHyperLinks(), this.stdoutInteractive(), this.stdinInteractive());
    }

    public static /* synthetic */ TerminalInfo detectTerminal$default(TerminalDetection terminalDetection, AnsiLevel ansiLevel, Integer n, Integer n2, Boolean bl, int n3, Object object) {
        if ((n3 & 1) != 0) {
            ansiLevel = null;
        }
        if ((n3 & 2) != 0) {
            n = null;
        }
        if ((n3 & 4) != 0) {
            n2 = null;
        }
        if ((n3 & 8) != 0) {
            bl = null;
        }
        return terminalDetection.detectTerminal(ansiLevel, n, n2, bl);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Pair<Integer, Integer> detectSize(long timeoutMs) {
        void $this$mapNotNullTo$iv$iv;
        Process process;
        try {
            process = new ProcessBuilder("stty", "size").redirectInput(ProcessBuilder.Redirect.INHERIT).start();
        }
        catch (IOException e) {
            return null;
        }
        Process process2 = process;
        try {
            if (!process2.waitFor(timeoutMs, TimeUnit.MILLISECONDS)) {
                return null;
            }
        }
        catch (InterruptedException e) {
            return null;
        }
        Process process3 = process2;
        Intrinsics.checkNotNullExpressionValue(process3, "process");
        InputStream inputStream2 = process3.getInputStream();
        Intrinsics.checkNotNullExpressionValue(inputStream2, "process.inputStream");
        InputStream e = inputStream2;
        Object object = Charsets.UTF_8;
        boolean bl = false;
        Object object2 = e;
        int n = 0;
        object2 = new InputStreamReader((InputStream)object2, (Charset)object);
        n = 8192;
        boolean bl2 = false;
        String output = TextStreamsKt.readText(object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n));
        object = output;
        bl = false;
        Object object3 = object;
        if (object3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        Iterable $this$mapNotNull$iv = StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)object3)).toString(), new String[]{" "}, false, 0, 6, null);
        boolean $i$f$mapNotNull = false;
        object2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Integer n2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl3 = false;
            String it = (String)element$iv$iv;
            boolean bl4 = false;
            if (StringsKt.toIntOrNull(it) == null) continue;
            boolean bl5 = false;
            boolean bl6 = false;
            Integer it$iv$iv = n2;
            boolean bl7 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List dimens = (List)destination$iv$iv;
        if (dimens.size() != 2) {
            return null;
        }
        return TuplesKt.to(dimens.get(1), dimens.get(0));
    }

    private final Integer width() {
        Integer n;
        String string = System.getenv("COLUMNS");
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            n = Integer.parseInt(string2);
        } else {
            n = null;
        }
        return n;
    }

    private final Integer height() {
        Integer n;
        String string = System.getenv("LINES");
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            n = Integer.parseInt(string2);
        } else {
            n = null;
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean ansiHyperLinks() {
        block5: {
            if (this.forcedColor() == AnsiLevel.NONE) return false;
            if (this.isWindowsTerminal()) return true;
            String string = this.getTermProgram();
            if (string == null) return false;
            String string2 = string;
            switch (string2.hashCode()) {
                case 1246525912: {
                    if (!string2.equals("wezterm")) return false;
                    return true;
                }
                case -1987176184: {
                    if (!string2.equals("iterm.app")) return false;
                    break;
                }
                case 99761772: {
                    if (!string2.equals("hyper")) return false;
                    return true;
                }
            }
            break block5;
            return false;
        }
        boolean bl = this.isRecentITerm();
        if (!bl) return false;
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private final AnsiLevel ansiLevel() {
        block56: {
            block55: {
                block52: {
                    block53: {
                        block54: {
                            block51: {
                                v0 = this.forcedColor();
                                if (v0 != null) {
                                    var1_1 = v0;
                                    var2_3 = false;
                                    var3_5 = false;
                                    it = var1_1;
                                    $i$a$-let-TerminalDetection$ansiLevel$1 = false;
                                    return it;
                                }
                                if (this.isIntellijConsole() || this.isVsCodeTerminal()) {
                                    return AnsiLevel.TRUECOLOR;
                                }
                                if (!this.stdoutInteractive()) {
                                    return AnsiLevel.NONE;
                                }
                                if (this.isWindowsTerminal() || this.isDomTerm()) {
                                    return AnsiLevel.TRUECOLOR;
                                }
                                v1 = this.getColorTerm();
                                if (v1 == null) break block51;
                                var1_2 = v1;
                                switch (var1_2.hashCode()) {
                                    case 47822731: {
                                        if (!var1_2.equals("24bit")) break;
                                        ** GOTO lbl27
                                    }
                                    case 1482504776: {
                                        if (!var1_2.equals("24bits")) break;
                                        ** GOTO lbl27
                                    }
                                    case 1350697621: {
                                        if (!var1_2.equals("truecolor")) break;
lbl27:
                                        // 3 sources

                                        return AnsiLevel.TRUECOLOR;
                                    }
                                }
                            }
                            v2 = this.getTermProgram();
                            if (v2 == null) break block52;
                            var1_2 = v2;
                            switch (var1_2.hashCode()) {
                                case 1246525912: {
                                    if (!var1_2.equals("wezterm")) ** break;
                                    break block53;
                                }
                                case -1987176184: {
                                    if (!var1_2.equals("iterm.app")) ** break;
                                    break block54;
                                }
                                case 1015440833: {
                                    if (!var1_2.equals("apple_terminal")) ** break;
                                    break;
                                }
                                case 99761772: {
                                    if (!var1_2.equals("hyper")) ** break;
                                    return AnsiLevel.TRUECOLOR;
                                }
                            }
                            return AnsiLevel.ANSI256;
                        }
                        return this.isRecentITerm() != false ? AnsiLevel.TRUECOLOR : AnsiLevel.ANSI256;
                    }
                    return AnsiLevel.TRUECOLOR;
                }
                if ((v3 = this.getTerm()) == null || (v3 = StringsKt.split$default((CharSequence)v3, new String[]{"-"}, false, 0, 6, null)) == null) break block55;
                var4_8 = v3;
                var5_10 = false;
                var6_11 = false;
                it = var4_8;
                $i$a$-let-TerminalDetection$ansiLevel$2 = false;
                v3 = TuplesKt.to(CollectionsKt.firstOrNull(it), CollectionsKt.lastOrNull(it));
                if (v3 != null) break block56;
            }
            v3 = TuplesKt.to(null, null);
        }
        var3_6 = v3;
        var1_2 = (String)var3_6.component1();
        v4 = level = (String)var3_6.component2();
        if (v4 != null) {
            var3_6 = v4;
            tmp = -1;
            switch (var3_6.hashCode()) {
                case -1619924752: {
                    if (!var3_6.equals("256color")) break;
                    tmp = 1;
                    break;
                }
                case 47822731: {
                    if (!var3_6.equals("24bit")) break;
                    tmp = 2;
                    break;
                }
                case 49747: {
                    if (!var3_6.equals("256")) break;
                    tmp = 1;
                    break;
                }
                case 1482504776: {
                    if (!var3_6.equals("24bits")) break;
                    tmp = 2;
                    break;
                }
                case 1350697621: {
                    if (!var3_6.equals("truecolor")) break;
                    tmp = 2;
                    break;
                }
                case 1321940355: {
                    if (!var3_6.equals("256colors")) break;
                    tmp = 1;
                    break;
                }
                case -1331586071: {
                    if (!var3_6.equals("direct")) break;
                    tmp = 2;
                    break;
                }
            }
            switch (tmp) {
                case 1: {
                    return AnsiLevel.ANSI256;
                }
                case 2: {
                    return AnsiLevel.TRUECOLOR;
                }
            }
        }
        v5 = term;
        if (v5 == null) ** GOTO lbl-1000
        var3_6 = v5;
        tmp = -1;
        switch (var3_6.hashCode()) {
            case 3515268: {
                if (!var3_6.equals("rxvt")) break;
                tmp = 1;
                break;
            }
            case -1345749109: {
                if (!var3_6.equals("cygwin")) break;
                tmp = 2;
                break;
            }
            case 94842723: {
                if (!var3_6.equals("color")) break;
                tmp = 1;
                break;
            }
            case 114378980: {
                if (!var3_6.equals("xterm")) break;
                tmp = 1;
                break;
            }
            case 112480882: {
                if (!var3_6.equals("vt220")) break;
                tmp = 1;
                break;
            }
            case 112479859: {
                if (!var3_6.equals("vt100")) break;
                tmp = 1;
                break;
            }
            case 102977780: {
                if (!var3_6.equals("linux")) break;
                tmp = 1;
                break;
            }
            case -538394785: {
                if (!var3_6.equals("konsole")) break;
                tmp = 1;
                break;
            }
            case -907689876: {
                if (!var3_6.equals("screen")) break;
                tmp = 1;
                break;
            }
            case 3095014: {
                if (!var3_6.equals("dumb")) break;
                tmp = 3;
                break;
            }
            case 2999107: {
                if (!var3_6.equals("ansi")) break;
                tmp = 1;
                break;
            }
        }
        switch (tmp) {
            case 2: {
                if (Intrinsics.areEqual(System.getProperty("os.name"), "Windows 10")) {
                    v6 = AnsiLevel.TRUECOLOR;
                    break;
                }
                v6 = AnsiLevel.ANSI256;
                break;
            }
            case 1: {
                v6 = AnsiLevel.ANSI16;
                break;
            }
            case 3: {
                v6 = AnsiLevel.NONE;
                break;
            }
            default: lbl-1000:
            // 2 sources

            {
                v6 = AnsiLevel.NONE;
            }
        }
        return v6;
    }

    private final String getTerm() {
        String string;
        String string2 = System.getenv("TERM");
        if (string2 != null) {
            String string3 = string2;
            boolean bl = false;
            String string4 = string3;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.toLowerCase();
            string = string5;
            Intrinsics.checkNotNullExpressionValue(string5, "(this as java.lang.String).toLowerCase()");
        } else {
            string = null;
        }
        return string;
    }

    private final String getColorTerm() {
        String string;
        String string2 = System.getenv("COLORTERM");
        if (string2 != null) {
            String string3 = string2;
            boolean bl = false;
            String string4 = string3;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.toLowerCase();
            string = string5;
            Intrinsics.checkNotNullExpressionValue(string5, "(this as java.lang.String).toLowerCase()");
        } else {
            string = null;
        }
        return string;
    }

    /*
     * Unable to fully structure code
     */
    private final AnsiLevel forcedColor() {
        block17: {
            block19: {
                block21: {
                    block20: {
                        block18: {
                            block16: {
                                if (!Intrinsics.areEqual(this.getTerm(), "dumb")) break block16;
                                v0 = AnsiLevel.NONE;
                                break block17;
                            }
                            if (System.getenv("NO_COLOR") == null) break block18;
                            v0 = AnsiLevel.NONE;
                            break block17;
                        }
                        v1 = System.getenv("FORCE_COLOR");
                        if (v1 != null) {
                            var1_1 = v1;
                            var2_2 = false;
                            v2 = var1_1;
                            if (v2 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                            }
                            v3 = v2.toLowerCase();
                            v4 = v3;
                            Intrinsics.checkNotNullExpressionValue(v3, "(this as java.lang.String).toLowerCase()");
                        } else {
                            v4 = null;
                        }
                        if (v4 == null) break block19;
                        var1_1 = v4;
                        switch (var1_1.hashCode()) {
                            case 48: {
                                if (!var1_1.equals("0")) ** break;
                                ** GOTO lbl57
                            }
                            case 0: {
                                if (!var1_1.equals("")) ** break;
                                break;
                            }
                            case -2116143010: {
                                if (!var1_1.equals("16color")) ** break;
                                break;
                            }
                            case 49: {
                                if (!var1_1.equals("1")) ** break;
                                break;
                            }
                            case -1619924752: {
                                if (!var1_1.equals("256color")) ** break;
                                break block20;
                            }
                            case 50: {
                                if (!var1_1.equals("2")) ** break;
                                break block20;
                            }
                            case 51: {
                                if (!var1_1.equals("3")) ** break;
                                break block21;
                            }
                            case 1350697621: {
                                if (!var1_1.equals("truecolor")) ** break;
                                break block21;
                            }
                            case 97196323: {
                                if (!var1_1.equals("false")) ** break;
                                ** GOTO lbl57
                            }
                            case 3569038: {
                                if (!var1_1.equals("true")) ** break;
                                break;
                            }
                            case 3387192: {
                                if (!var1_1.equals("none")) ** break;
lbl57:
                                // 3 sources

                                v0 = AnsiLevel.NONE;
                                break block17;
                            }
                        }
                        v0 = AnsiLevel.ANSI16;
                        break block17;
                    }
                    v0 = AnsiLevel.ANSI256;
                    break block17;
                }
                v0 = AnsiLevel.TRUECOLOR;
                break block17;
            }
            v0 = null;
        }
        return v0;
    }

    private final String getTermProgram() {
        String string;
        String string2 = System.getenv("TERM_PROGRAM");
        if (string2 != null) {
            String string3 = string2;
            boolean bl = false;
            String string4 = string3;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.toLowerCase();
            string = string5;
            Intrinsics.checkNotNullExpressionValue(string5, "(this as java.lang.String).toLowerCase()");
        } else {
            string = null;
        }
        return string;
    }

    private final boolean isVsCodeTerminal() {
        return Intrinsics.areEqual(this.getTermProgram(), "vscode");
    }

    private final boolean isWindowsTerminal() {
        CharSequence charSequence = System.getenv("WT_SESSION");
        boolean bl = false;
        boolean bl2 = false;
        return !(charSequence == null || charSequence.length() == 0);
    }

    private final boolean isDomTerm() {
        CharSequence charSequence = System.getenv("DOMTERM");
        boolean bl = false;
        boolean bl2 = false;
        return !(charSequence == null || charSequence.length() == 0);
    }

    private final boolean isRecentITerm() {
        Object object = System.getenv("TERM_PROGRAM_VERSION");
        Integer ver = object != null && (object = StringsKt.split$default((CharSequence)object, new String[]{"."}, false, 0, 6, null)) != null && (object = (String)CollectionsKt.firstOrNull(object)) != null ? StringsKt.toIntOrNull((String)object) : null;
        return ver != null && ver >= 3;
    }

    private final boolean stdoutInteractive() {
        return System.console() != null || this.isIntellijConsole();
    }

    private final boolean stdinInteractive() {
        return System.console() != null || this.isIntellijConsole();
    }

    private final boolean isIntellijConsole() {
        boolean bl;
        try {
            boolean bl2;
            block5: {
                List<String> jvmArgs;
                RuntimeMXBean bean;
                RuntimeMXBean runtimeMXBean = bean = ManagementFactory.getRuntimeMXBean();
                Intrinsics.checkNotNullExpressionValue(runtimeMXBean, "bean");
                List<String> list = jvmArgs = runtimeMXBean.getInputArguments();
                Intrinsics.checkNotNullExpressionValue(list, "jvmArgs");
                Iterable $this$any$iv = list;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl3 = false;
                        String string = it;
                        Intrinsics.checkNotNullExpressionValue(string, "it");
                        if (!(StringsKt.startsWith$default(string, "-javaagent", false, 2, null) && StringsKt.contains$default((CharSequence)it, "idea_rt.jar", false, 2, null))) continue;
                        bl2 = true;
                        break block5;
                    }
                    bl2 = false;
                }
            }
            bl = bl2;
        }
        catch (SecurityException e) {
            bl = false;
        }
        return bl;
    }

    private TerminalDetection() {
    }

    static {
        TerminalDetection terminalDetection;
        INSTANCE = terminalDetection = new TerminalDetection();
    }
}

