/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.layout.template.json.resolver;

import java.util.List;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.layout.template.json.resolver.EventResolverContext;
import org.apache.logging.log4j.layout.template.json.resolver.StackTraceResolver;
import org.apache.logging.log4j.layout.template.json.util.JsonWriter;
import org.apache.logging.log4j.layout.template.json.util.Recycler;
import org.apache.logging.log4j.layout.template.json.util.TruncatingBufferedPrintWriter;

final class StackTraceStringResolver
implements StackTraceResolver {
    private final Recycler<TruncatingBufferedPrintWriter> writerRecycler;
    private final boolean truncationEnabled;
    private final String truncationSuffix;
    private final List<String> truncationPointMatcherStrings;
    private final List<Pattern> groupedTruncationPointMatcherRegexes;

    StackTraceStringResolver(EventResolverContext context, String truncationSuffix, List<String> truncationPointMatcherStrings, List<String> truncationPointMatcherRegexes) {
        Supplier<TruncatingBufferedPrintWriter> writerSupplier = () -> TruncatingBufferedPrintWriter.ofCapacity(context.getMaxStringByteCount());
        this.writerRecycler = context.getRecyclerFactory().create(writerSupplier, TruncatingBufferedPrintWriter::close);
        this.truncationEnabled = !truncationPointMatcherStrings.isEmpty() || !truncationPointMatcherRegexes.isEmpty();
        this.truncationSuffix = truncationSuffix;
        this.truncationPointMatcherStrings = truncationPointMatcherStrings;
        this.groupedTruncationPointMatcherRegexes = StackTraceStringResolver.groupTruncationPointMatcherRegexes(truncationPointMatcherRegexes);
    }

    private static List<Pattern> groupTruncationPointMatcherRegexes(List<String> regexes) {
        return regexes.stream().map(regex -> Pattern.compile("^.*(" + regex + ")(.*)$", 40)).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resolve(Throwable throwable, JsonWriter jsonWriter) {
        TruncatingBufferedPrintWriter writer = this.writerRecycler.acquire();
        try {
            throwable.printStackTrace(writer);
            this.truncate(writer);
            jsonWriter.writeString(writer.buffer(), 0, writer.position());
        }
        finally {
            this.writerRecycler.release(writer);
        }
    }

    private void truncate(TruncatingBufferedPrintWriter writer) {
        int i;
        if (!this.truncationEnabled) {
            return;
        }
        for (i = 0; i < this.truncationPointMatcherStrings.size(); ++i) {
            String matcher = this.truncationPointMatcherStrings.get(i);
            int matchIndex = writer.indexOf(matcher);
            if (matchIndex <= 0) continue;
            int truncationPointIndex = matchIndex + matcher.length();
            this.truncate(writer, truncationPointIndex);
            return;
        }
        for (i = 0; i < this.groupedTruncationPointMatcherRegexes.size(); ++i) {
            Pattern pattern = this.groupedTruncationPointMatcherRegexes.get(i);
            Matcher matcher = pattern.matcher(writer);
            boolean matched = matcher.matches();
            if (!matched) continue;
            int lastGroup = matcher.groupCount();
            int truncationPointIndex = matcher.start(lastGroup);
            this.truncate(writer, truncationPointIndex);
            return;
        }
    }

    private void truncate(TruncatingBufferedPrintWriter writer, int index) {
        writer.position(index);
        writer.print(this.truncationSuffix);
    }
}

