/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.PerReplicaStates;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Replica
extends ZkNodeProps {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final String name;
    private final String nodeName;
    private final String core;
    private final State state;
    private final Type type;
    public final String slice;
    public final String collection;
    private PerReplicaStates.State replicaState;
    private static final Map<String, State> STATES = new HashMap<String, State>();

    public Replica(String name, Map<String, Object> propMap, String collection, String slice) {
        super(propMap);
        this.collection = collection;
        this.slice = slice;
        this.name = name;
        this.nodeName = (String)propMap.get("node_name");
        this.core = (String)propMap.get("core");
        this.type = Type.get((String)propMap.get("type"));
        Objects.requireNonNull(this.collection, "'collection' must not be null");
        Objects.requireNonNull(this.slice, "'slice' must not be null");
        Objects.requireNonNull(this.name, "'name' must not be null");
        Objects.requireNonNull(this.nodeName, "'node_name' must not be null");
        Objects.requireNonNull(this.core, "'core' must not be null");
        Objects.requireNonNull(this.type, "'type' must not be null");
        ClusterState.getReplicaStatesProvider().get().ifPresent(it -> {
            if (log.isDebugEnabled()) {
                log.debug("replica: {}, state fetched from per-replica state", (Object)name);
            }
            this.replicaState = it.getStates().get(name);
            if (this.replicaState != null) {
                propMap.put("state", this.replicaState.state.toString().toLowerCase(Locale.ROOT));
                if (this.replicaState.isLeader.booleanValue()) {
                    propMap.put("leader", "true");
                }
            }
        });
        if (this.replicaState == null) {
            if (propMap.get("state") != null) {
                this.state = State.getState((String)propMap.get("state"));
            } else {
                this.state = State.ACTIVE;
                propMap.put("state", this.state.toString());
            }
        } else {
            this.state = this.replicaState.state;
        }
    }

    public String getCollection() {
        return this.collection;
    }

    public String getSlice() {
        return this.slice;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Replica replica = (Replica)o;
        return this.name.equals(replica.name);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name);
    }

    public String getName() {
        return this.name;
    }

    public String getCoreUrl() {
        return ZkCoreNodeProps.getCoreUrl(this.getBaseUrl(), this.core);
    }

    public String getBaseUrl() {
        return this.getStr("base_url");
    }

    public String getCoreName() {
        return this.core;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public State getState() {
        return this.state;
    }

    public boolean isActive(Set<String> liveNodes) {
        return this.nodeName != null && liveNodes.contains(this.nodeName) && this.state == State.ACTIVE;
    }

    public Type getType() {
        return this.type;
    }

    public String getProperty(String propertyName) {
        String propertyKey = !propertyName.startsWith("property.") ? "property." + propertyName : propertyName;
        String propertyValue = this.getStr(propertyKey);
        return propertyValue;
    }

    public Replica copyWith(PerReplicaStates.State state) {
        log.debug("A replica is updated with new state : {}", (Object)state);
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>(this.propMap);
        if (state == null) {
            props.put("state", State.DOWN.toString());
            props.remove("leader");
        } else {
            props.put("state", state.state.toString());
            if (state.isLeader.booleanValue()) {
                props.put("leader", "true");
            }
        }
        Replica r = new Replica(this.name, props, this.collection, this.slice);
        r.replicaState = state;
        return r;
    }

    public PerReplicaStates.State getReplicaState() {
        return this.replicaState;
    }

    public static State getState(String c) {
        return STATES.get(c);
    }

    public boolean isLeader() {
        if (this.replicaState != null) {
            return this.replicaState.isLeader;
        }
        return this.getStr("leader") != null;
    }

    @Override
    public String toString() {
        return this.name + ':' + Utils.toJSONString(this.propMap);
    }

    static {
        STATES.put(State.ACTIVE.shortName, State.ACTIVE);
        STATES.put(State.DOWN.shortName, State.DOWN);
        STATES.put(State.RECOVERING.shortName, State.RECOVERING);
        STATES.put(State.RECOVERY_FAILED.shortName, State.RECOVERY_FAILED);
    }

    public static enum Type {
        NRT,
        TLOG,
        PULL;


        public static Type get(String name) {
            return name == null ? NRT : Type.valueOf(name.toUpperCase(Locale.ROOT));
        }
    }

    public static enum State {
        ACTIVE("A"),
        DOWN("D"),
        RECOVERING("R"),
        RECOVERY_FAILED("F");

        public final String shortName;

        private State(String c) {
            this.shortName = c;
        }

        public String toString() {
            return super.toString().toLowerCase(Locale.ROOT);
        }

        public static State getState(String stateStr) {
            return stateStr == null ? null : State.valueOf(stateStr.toUpperCase(Locale.ROOT));
        }
    }
}

