/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.lang.invoke.MethodHandles;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.solr.client.solrj.cloud.SolrCloudManager;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.cloud.ZkSolrResourceLoader;
import org.apache.solr.cloud.api.collections.CreateCollectionCmd;
import org.apache.solr.common.ConfigNode;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ZooKeeperException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.ConfigSetProperties;
import org.apache.solr.core.ConfigSetService;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudConfigSetService
extends ConfigSetService {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private Map<String, ConfigCacheEntry> cache = new ConcurrentHashMap<String, ConfigCacheEntry>();
    private final ZkController zkController;

    public CloudConfigSetService(SolrResourceLoader loader, boolean shareSchema, ZkController zkController) {
        super(loader, shareSchema);
        this.zkController = zkController;
    }

    public void storeConfig(String resource, ConfigNode config, int znodeVersion) {
        this.cache.put(resource, new ConfigCacheEntry(config, znodeVersion));
    }

    public ConfigNode getConfig(String resource, int znodeVersion) {
        ConfigCacheEntry e = this.cache.get(resource);
        if (e == null) {
            return null;
        }
        ConfigNode configNode = (ConfigNode)e.configNode.get();
        if (configNode == null) {
            this.cache.remove(resource);
        }
        if (e.znodeVersion == znodeVersion) {
            return configNode;
        }
        if (e.znodeVersion < znodeVersion) {
            this.cache.remove(resource);
        }
        return null;
    }

    @Override
    public SolrResourceLoader createCoreResourceLoader(CoreDescriptor cd) {
        String configSetName;
        String colName = cd.getCollectionName();
        try {
            if (!this.zkController.getZkClient().exists("/collections/" + colName, true).booleanValue()) {
                log.warn("Auto-creating collection (in ZK) from core descriptor (on disk).  This feature may go away!");
                CreateCollectionCmd.createCollectionZkNode(this.zkController.getSolrCloudManager().getDistribStateManager(), colName, cd.getCloudDescriptor().getParams());
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "Interrupted auto-creating collection", (Throwable)e);
        }
        catch (KeeperException e) {
            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "Failure auto-creating collection", (Throwable)e);
        }
        try {
            configSetName = this.zkController.getZkStateReader().readConfigName(colName);
            cd.setConfigSet(configSetName);
        }
        catch (KeeperException ex) {
            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "Trouble resolving configSet for collection " + colName + ": " + ex.getMessage());
        }
        return new ZkSolrResourceLoader(cd.getInstanceDir(), configSetName, this.parentLoader.getClassLoader(), cd.getSubstitutableProperties(), this.zkController);
    }

    @Override
    protected NamedList loadConfigSetFlags(CoreDescriptor cd, SolrResourceLoader loader) {
        try {
            return ConfigSetProperties.readFromResourceLoader(loader, ".");
        }
        catch (Exception ex) {
            log.debug("No configSet flags", (Throwable)ex);
            return null;
        }
    }

    @Override
    protected Long getCurrentSchemaModificationVersion(String configSet, SolrConfig solrConfig, String schemaFile) {
        Stat stat;
        String zkPath = "/configs/" + configSet + "/" + schemaFile;
        try {
            stat = this.zkController.getZkClient().exists(zkPath, null, true);
        }
        catch (KeeperException e) {
            log.warn("Unexpected exception when getting modification time of {}", (Object)zkPath, (Object)e);
            return null;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        if (stat == null) {
            return null;
        }
        return stat.getVersion();
    }

    @Override
    public String configSetName(CoreDescriptor cd) {
        return "configset " + cd.getConfigSet();
    }

    public SolrCloudManager getSolrCloudManager() {
        return this.zkController.getSolrCloudManager();
    }

    private static class ConfigCacheEntry {
        final WeakReference<ConfigNode> configNode;
        final int znodeVersion;

        private ConfigCacheEntry(ConfigNode configNode, int znodeVersion) {
            this.configNode = new WeakReference<ConfigNode>(configNode);
            this.znodeVersion = znodeVersion;
        }
    }
}

