/*
 * Decompiled with CFR 0.152.
 */
package com.swabunga.spell.examples;

import com.swabunga.spell.engine.SpellDictionary;
import com.swabunga.spell.engine.SpellDictionaryHashMap;
import com.swabunga.spell.swing.JTextComponentSpellChecker;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;

public class JTextComponentSpellCheckExample
extends JFrame {
    private static final String englishDictionary = "dict/english.0";
    private static final String englishPhonetic = "dict/phonet.en";
    protected SpellDictionary dictionary;
    JTextComponent text = null;
    JButton spell = null;

    public JTextComponentSpellCheckExample(String string, String string2) {
        File file = null;
        File file2 = null;
        file = string == null ? new File(englishDictionary) : new File(string);
        if (string2 != null) {
            file2 = new File(string2);
        }
        try {
            this.dictionary = new SpellDictionaryHashMap(file, file2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        this.initGUI();
        this.pack();
    }

    private void initGUI() {
        Container container = this.getContentPane();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        container.setLayout(gridBagLayout);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.text = new JTextArea(10, 40);
        this.addToFrame(container, this.text, gridBagLayout, gridBagConstraints, 0, 0, 1, 1);
        this.spell = new JButton("spell");
        this.spell.addActionListener(new ButtonListener());
        this.addToFrame(container, this.spell, gridBagLayout, gridBagConstraints, 0, 1, 1, 1);
    }

    private void addToFrame(Container container, Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        container.add(component);
    }

    public static void main(String[] stringArray) {
        String string = null;
        String string2 = null;
        if (stringArray.length > 0) {
            string = stringArray[0];
        }
        if (stringArray.length > 1) {
            string2 = stringArray[1];
        }
        JTextComponentSpellCheckExample jTextComponentSpellCheckExample = new JTextComponentSpellCheckExample(string, string2);
        jTextComponentSpellCheckExample.show();
    }

    private class SpellThread
    extends Thread {
        private SpellThread() {
        }

        public void run() {
            try {
                JTextComponentSpellChecker jTextComponentSpellChecker = new JTextComponentSpellChecker(JTextComponentSpellCheckExample.this.dictionary);
                jTextComponentSpellChecker.spellCheck(JTextComponentSpellCheckExample.this.text);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private class ButtonListener
    implements ActionListener {
        private ButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SpellThread spellThread = new SpellThread();
            spellThread.start();
        }
    }
}

