/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.tracklink.findusages;

import com.almworks.tracklink.util.StringBundle;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsageView;
import javax.swing.Icon;

public class VCSLinkUsageGroup
implements UsageGroup {
    private final Project myProject;
    private final VirtualFile myFile;
    private final String myPresentableName;
    private Icon myIcon;

    public VCSLinkUsageGroup(Project project, VirtualFile file) {
        this.myProject = project;
        this.myFile = file;
        this.myPresentableName = StringBundle.get("find.dialog.vcslinks", new Object[0]);
        this.update();
    }

    private Icon getIconImpl() {
        return null;
    }

    public void update() {
        if (this.isValid()) {
            this.myIcon = this.getIconImpl();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VCSLinkUsageGroup)) {
            return false;
        }
        VCSLinkUsageGroup VCSLinkUsageGroup2 = (VCSLinkUsageGroup)o;
        return !(this.myFile == null ? VCSLinkUsageGroup2.myFile != null : !this.myFile.equals(VCSLinkUsageGroup2.myFile));
    }

    public int hashCode() {
        return Comparing.hashcode((Object)this.myFile);
    }

    public Icon getIcon(boolean isOpen) {
        return this.myIcon;
    }

    public String getText(UsageView view) {
        return this.myPresentableName;
    }

    public FileStatus getFileStatus() {
        return this.isValid() ? FileStatusManager.getInstance((Project)this.myProject).getStatus(this.myFile) : null;
    }

    public boolean isValid() {
        return this.myFile.isValid();
    }

    public void navigate(boolean focus) throws UnsupportedOperationException {
        FileEditorManager.getInstance((Project)this.myProject).openFile(this.myFile, focus);
    }

    public boolean canNavigate() {
        return true;
    }

    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    public int compareTo(UsageGroup usageGroup) {
        return this.getText(null).compareTo(usageGroup.getText(null));
    }

    public Object getData(String dataId) {
        if ("virtualFile".equals(dataId)) {
            return this.myFile != null && this.myFile.isValid() ? this.myFile : null;
        }
        if ("psi.Element".equals(dataId)) {
            return this.myFile != null && this.myFile.isValid() ? this.getPsiFile() : null;
        }
        return null;
    }

    public PsiFile getPsiFile() {
        return PsiManager.getInstance((Project)this.myProject).findFile(this.myFile);
    }
}

