/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.cuda.CUhostFn;
import org.lwjgl.cuda.CUhostFnI;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CUDA_HOST_NODE_PARAMS
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FN;
    public static final int USERDATA;

    public CUDA_HOST_NODE_PARAMS(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CUDA_HOST_NODE_PARAMS.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void (*) (void *)")
    public CUhostFn fn() {
        return CUDA_HOST_NODE_PARAMS.nfn(this.address());
    }

    @NativeType(value="void *")
    public long userData() {
        return CUDA_HOST_NODE_PARAMS.nuserData(this.address());
    }

    public CUDA_HOST_NODE_PARAMS fn(@NativeType(value="void (*) (void *)") CUhostFnI value) {
        CUDA_HOST_NODE_PARAMS.nfn(this.address(), value);
        return this;
    }

    public CUDA_HOST_NODE_PARAMS userData(@NativeType(value="void *") long value) {
        CUDA_HOST_NODE_PARAMS.nuserData(this.address(), value);
        return this;
    }

    public CUDA_HOST_NODE_PARAMS set(CUhostFnI fn, long userData) {
        this.fn(fn);
        this.userData(userData);
        return this;
    }

    public CUDA_HOST_NODE_PARAMS set(CUDA_HOST_NODE_PARAMS src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static CUDA_HOST_NODE_PARAMS malloc() {
        return (CUDA_HOST_NODE_PARAMS)CUDA_HOST_NODE_PARAMS.wrap(CUDA_HOST_NODE_PARAMS.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static CUDA_HOST_NODE_PARAMS calloc() {
        return (CUDA_HOST_NODE_PARAMS)CUDA_HOST_NODE_PARAMS.wrap(CUDA_HOST_NODE_PARAMS.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static CUDA_HOST_NODE_PARAMS create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (CUDA_HOST_NODE_PARAMS)CUDA_HOST_NODE_PARAMS.wrap(CUDA_HOST_NODE_PARAMS.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static CUDA_HOST_NODE_PARAMS create(long address) {
        return (CUDA_HOST_NODE_PARAMS)CUDA_HOST_NODE_PARAMS.wrap(CUDA_HOST_NODE_PARAMS.class, (long)address);
    }

    @Nullable
    public static CUDA_HOST_NODE_PARAMS createSafe(long address) {
        return address == 0L ? null : (CUDA_HOST_NODE_PARAMS)CUDA_HOST_NODE_PARAMS.wrap(CUDA_HOST_NODE_PARAMS.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)CUDA_HOST_NODE_PARAMS.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)CUDA_HOST_NODE_PARAMS.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)CUDA_HOST_NODE_PARAMS.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CUDA_HOST_NODE_PARAMS.__create((int)capacity, (int)SIZEOF);
        return (Buffer)CUDA_HOST_NODE_PARAMS.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)CUDA_HOST_NODE_PARAMS.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)CUDA_HOST_NODE_PARAMS.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static CUDA_HOST_NODE_PARAMS mallocStack() {
        return CUDA_HOST_NODE_PARAMS.mallocStack(MemoryStack.stackGet());
    }

    public static CUDA_HOST_NODE_PARAMS callocStack() {
        return CUDA_HOST_NODE_PARAMS.callocStack(MemoryStack.stackGet());
    }

    public static CUDA_HOST_NODE_PARAMS mallocStack(MemoryStack stack) {
        return (CUDA_HOST_NODE_PARAMS)CUDA_HOST_NODE_PARAMS.wrap(CUDA_HOST_NODE_PARAMS.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CUDA_HOST_NODE_PARAMS callocStack(MemoryStack stack) {
        return (CUDA_HOST_NODE_PARAMS)CUDA_HOST_NODE_PARAMS.wrap(CUDA_HOST_NODE_PARAMS.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return CUDA_HOST_NODE_PARAMS.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return CUDA_HOST_NODE_PARAMS.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)CUDA_HOST_NODE_PARAMS.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)CUDA_HOST_NODE_PARAMS.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static CUhostFn nfn(long struct) {
        return CUhostFn.create(MemoryUtil.memGetAddress((long)(struct + (long)FN)));
    }

    public static long nuserData(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)USERDATA));
    }

    public static void nfn(long struct, CUhostFnI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)FN), (long)value.address());
    }

    public static void nuserData(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)USERDATA), (long)Checks.check((long)value));
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)FN)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)USERDATA)));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            CUDA_HOST_NODE_PARAMS.validate(array + Integer.toUnsignedLong(i) * (long)SIZEOF);
        }
    }

    static {
        Struct.Layout layout = CUDA_HOST_NODE_PARAMS.__struct((Struct.Member[])new Struct.Member[]{CUDA_HOST_NODE_PARAMS.__member((int)POINTER_SIZE), CUDA_HOST_NODE_PARAMS.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FN = layout.offsetof(0);
        USERDATA = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<CUDA_HOST_NODE_PARAMS, Buffer>
    implements NativeResource {
        private static final CUDA_HOST_NODE_PARAMS ELEMENT_FACTORY = CUDA_HOST_NODE_PARAMS.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected CUDA_HOST_NODE_PARAMS getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="void (*) (void *)")
        public CUhostFn fn() {
            return CUDA_HOST_NODE_PARAMS.nfn(this.address());
        }

        @NativeType(value="void *")
        public long userData() {
            return CUDA_HOST_NODE_PARAMS.nuserData(this.address());
        }

        public Buffer fn(@NativeType(value="void (*) (void *)") CUhostFnI value) {
            CUDA_HOST_NODE_PARAMS.nfn(this.address(), value);
            return this;
        }

        public Buffer userData(@NativeType(value="void *") long value) {
            CUDA_HOST_NODE_PARAMS.nuserData(this.address(), value);
            return this;
        }
    }
}

