/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct CXUnsavedFile")
public class CXUnsavedFile
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FILENAME;
    public static final int CONTENTS;
    public static final int LENGTH;

    public CXUnsavedFile(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CXUnsavedFile.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="char const *")
    public ByteBuffer Filename() {
        return CXUnsavedFile.nFilename(this.address());
    }

    @NativeType(value="char const *")
    public String FilenameString() {
        return CXUnsavedFile.nFilenameString(this.address());
    }

    @NativeType(value="char const *")
    public ByteBuffer Contents() {
        return CXUnsavedFile.nContents(this.address());
    }

    @NativeType(value="unsigned long")
    public long Length() {
        return CXUnsavedFile.nLength(this.address());
    }

    public CXUnsavedFile Filename(@NativeType(value="char const *") ByteBuffer value) {
        CXUnsavedFile.nFilename(this.address(), value);
        return this;
    }

    public CXUnsavedFile Contents(@NativeType(value="char const *") ByteBuffer value) {
        CXUnsavedFile.nContents(this.address(), value);
        return this;
    }

    public CXUnsavedFile set(ByteBuffer Filename, ByteBuffer Contents) {
        this.Filename(Filename);
        this.Contents(Contents);
        return this;
    }

    public CXUnsavedFile set(CXUnsavedFile src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static CXUnsavedFile malloc() {
        return (CXUnsavedFile)CXUnsavedFile.wrap(CXUnsavedFile.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static CXUnsavedFile calloc() {
        return (CXUnsavedFile)CXUnsavedFile.wrap(CXUnsavedFile.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static CXUnsavedFile create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (CXUnsavedFile)CXUnsavedFile.wrap(CXUnsavedFile.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static CXUnsavedFile create(long address) {
        return (CXUnsavedFile)CXUnsavedFile.wrap(CXUnsavedFile.class, (long)address);
    }

    @Nullable
    public static CXUnsavedFile createSafe(long address) {
        return address == 0L ? null : (CXUnsavedFile)CXUnsavedFile.wrap(CXUnsavedFile.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)CXUnsavedFile.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)CXUnsavedFile.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)CXUnsavedFile.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CXUnsavedFile.__create((int)capacity, (int)SIZEOF);
        return (Buffer)CXUnsavedFile.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)CXUnsavedFile.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)CXUnsavedFile.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static CXUnsavedFile mallocStack() {
        return CXUnsavedFile.mallocStack(MemoryStack.stackGet());
    }

    public static CXUnsavedFile callocStack() {
        return CXUnsavedFile.callocStack(MemoryStack.stackGet());
    }

    public static CXUnsavedFile mallocStack(MemoryStack stack) {
        return (CXUnsavedFile)CXUnsavedFile.wrap(CXUnsavedFile.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CXUnsavedFile callocStack(MemoryStack stack) {
        return (CXUnsavedFile)CXUnsavedFile.wrap(CXUnsavedFile.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return CXUnsavedFile.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return CXUnsavedFile.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)CXUnsavedFile.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)CXUnsavedFile.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static ByteBuffer nFilename(long struct) {
        return MemoryUtil.memByteBufferNT1((long)MemoryUtil.memGetAddress((long)(struct + (long)FILENAME)));
    }

    public static String nFilenameString(long struct) {
        return MemoryUtil.memASCII((long)MemoryUtil.memGetAddress((long)(struct + (long)FILENAME)));
    }

    public static ByteBuffer nContents(long struct) {
        return MemoryUtil.memByteBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)CONTENTS)), (int)((int)CXUnsavedFile.nLength(struct)));
    }

    public static long nLength(long struct) {
        return MemoryUtil.memGetCLong((long)(struct + (long)LENGTH));
    }

    public static void nFilename(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)value);
        }
        MemoryUtil.memPutAddress((long)(struct + (long)FILENAME), (long)MemoryUtil.memAddress((ByteBuffer)value));
    }

    public static void nContents(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)CONTENTS), (long)MemoryUtil.memAddress((ByteBuffer)value));
        CXUnsavedFile.nLength(struct, value.remaining());
    }

    public static void nLength(long struct, long value) {
        MemoryUtil.memPutCLong((long)(struct + (long)LENGTH), (long)value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)FILENAME)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)CONTENTS)));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            CXUnsavedFile.validate(array + Integer.toUnsignedLong(i) * (long)SIZEOF);
        }
    }

    static {
        Struct.Layout layout = CXUnsavedFile.__struct((Struct.Member[])new Struct.Member[]{CXUnsavedFile.__member((int)POINTER_SIZE), CXUnsavedFile.__member((int)POINTER_SIZE), CXUnsavedFile.__member((int)CLONG_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FILENAME = layout.offsetof(0);
        CONTENTS = layout.offsetof(1);
        LENGTH = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<CXUnsavedFile, Buffer>
    implements NativeResource {
        private static final CXUnsavedFile ELEMENT_FACTORY = CXUnsavedFile.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected CXUnsavedFile getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="char const *")
        public ByteBuffer Filename() {
            return CXUnsavedFile.nFilename(this.address());
        }

        @NativeType(value="char const *")
        public String FilenameString() {
            return CXUnsavedFile.nFilenameString(this.address());
        }

        @NativeType(value="char const *")
        public ByteBuffer Contents() {
            return CXUnsavedFile.nContents(this.address());
        }

        @NativeType(value="unsigned long")
        public long Length() {
            return CXUnsavedFile.nLength(this.address());
        }

        public Buffer Filename(@NativeType(value="char const *") ByteBuffer value) {
            CXUnsavedFile.nFilename(this.address(), value);
            return this;
        }

        public Buffer Contents(@NativeType(value="char const *") ByteBuffer value) {
            CXUnsavedFile.nContents(this.address(), value);
            return this;
        }
    }
}

