/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.api.resource;

import java.io.IOException;
import java.security.GeneralSecurityException;
import javax.annotation.security.PermitAll;
import javax.inject.Inject;
import javax.mail.MessagingException;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.velocity.VelocityContext;
import org.traccar.api.BaseResource;
import org.traccar.api.signature.TokenManager;
import org.traccar.mail.MailManager;
import org.traccar.model.User;
import org.traccar.notification.NotificationMessage;
import org.traccar.notification.TextTemplateFormatter;
import org.traccar.storage.StorageException;
import org.traccar.storage.query.Columns;
import org.traccar.storage.query.Condition;
import org.traccar.storage.query.Request;

@Path(value="password")
@Produces(value={"application/json"})
@Consumes(value={"application/x-www-form-urlencoded"})
public class PasswordResource
extends BaseResource {
    @Inject
    private MailManager mailManager;
    @Inject
    private TokenManager tokenManager;
    @Inject
    private TextTemplateFormatter textTemplateFormatter;

    @Path(value="reset")
    @PermitAll
    @POST
    public Response reset(@FormParam(value="email") String email) throws StorageException, MessagingException, GeneralSecurityException, IOException {
        User user = this.storage.getObject(User.class, new Request(new Columns.All(), new Condition.Equals("email", "email", email)));
        if (user != null) {
            VelocityContext velocityContext = this.textTemplateFormatter.prepareContext(this.permissionsService.getServer(), user);
            velocityContext.put("token", (Object)this.tokenManager.generateToken(user.getId()));
            NotificationMessage fullMessage = this.textTemplateFormatter.formatMessage(velocityContext, "passwordReset", "full");
            this.mailManager.sendMessage(user, fullMessage.getSubject(), fullMessage.getBody());
        }
        return Response.ok().build();
    }

    @Path(value="update")
    @PermitAll
    @POST
    public Response update(@FormParam(value="token") String token, @FormParam(value="password") String password) throws StorageException, GeneralSecurityException, IOException {
        long userId = this.tokenManager.verifyToken(token);
        User user = this.storage.getObject(User.class, new Request(new Columns.All(), new Condition.Equals("id", "id", userId)));
        if (user != null) {
            user.setPassword(password);
            this.storage.updateObject(user, new Request(new Columns.Include("hashedPassword", "salt"), new Condition.Equals("id", "id")));
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }
}

