/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.api.security;

import java.io.IOException;
import java.security.GeneralSecurityException;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.traccar.api.security.ServiceAccountUser;
import org.traccar.api.signature.TokenManager;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.database.LdapProvider;
import org.traccar.model.User;
import org.traccar.storage.Storage;
import org.traccar.storage.StorageException;
import org.traccar.storage.query.Columns;
import org.traccar.storage.query.Condition;
import org.traccar.storage.query.Request;

public class LoginService {
    private final Storage storage;
    private final TokenManager tokenManager;
    private final LdapProvider ldapProvider;
    private final String serviceAccountToken;
    private final boolean forceLdap;

    @Inject
    public LoginService(Config config, Storage storage, TokenManager tokenManager, @Nullable LdapProvider ldapProvider) {
        this.storage = storage;
        this.tokenManager = tokenManager;
        this.ldapProvider = ldapProvider;
        this.serviceAccountToken = config.getString(Keys.WEB_SERVICE_ACCOUNT_TOKEN);
        this.forceLdap = config.getBoolean(Keys.LDAP_FORCE);
    }

    public User login(String token) throws StorageException, GeneralSecurityException, IOException {
        if (this.serviceAccountToken != null && this.serviceAccountToken.equals(token)) {
            return new ServiceAccountUser();
        }
        long userId = this.tokenManager.verifyToken(token);
        User user = this.storage.getObject(User.class, new Request(new Columns.All(), new Condition.Equals("id", "id", userId)));
        if (user != null) {
            this.checkUserEnabled(user);
        }
        return user;
    }

    public User login(String email, String password) throws StorageException {
        User user = this.storage.getObject(User.class, new Request(new Columns.All(), new Condition.Or(new Condition.Equals("email", "email", email.trim()), new Condition.Equals("login", "email"))));
        if (user != null) {
            if (this.ldapProvider != null && user.getLogin() != null && this.ldapProvider.login(user.getLogin(), password) || !this.forceLdap && user.isPasswordValid(password)) {
                this.checkUserEnabled(user);
                return user;
            }
        } else if (this.ldapProvider != null && this.ldapProvider.login(email, password)) {
            user = this.ldapProvider.getUser(email);
            user.setId(this.storage.addObject(user, new Request(new Columns.Exclude("id"))));
            this.checkUserEnabled(user);
            return user;
        }
        return null;
    }

    private void checkUserEnabled(User user) throws SecurityException {
        if (user == null) {
            throw new SecurityException("Unknown account");
        }
        user.checkDisabled();
    }
}

