/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.broadcast;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.broadcast.BroadcastInterface;
import org.traccar.broadcast.BroadcastMessage;
import org.traccar.broadcast.BroadcastService;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.model.BaseModel;
import org.traccar.model.Device;
import org.traccar.model.Event;
import org.traccar.model.Permission;
import org.traccar.model.Position;

public class MulticastBroadcastService
implements BroadcastService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MulticastBroadcastService.class);
    private final ObjectMapper objectMapper;
    private final NetworkInterface networkInterface;
    private final int port;
    private final InetSocketAddress group;
    private DatagramSocket publisherSocket;
    private final ExecutorService service = Executors.newSingleThreadExecutor();
    private final byte[] receiverBuffer = new byte[4096];
    private final Set<BroadcastInterface> listeners = new HashSet<BroadcastInterface>();
    private final Runnable receiver = new Runnable(){

        @Override
        public void run() {
            try (MulticastSocket socket = new MulticastSocket(MulticastBroadcastService.this.port);){
                socket.setNetworkInterface(MulticastBroadcastService.this.networkInterface);
                socket.joinGroup(MulticastBroadcastService.this.group, MulticastBroadcastService.this.networkInterface);
                MulticastBroadcastService.this.publisherSocket = socket;
                while (!MulticastBroadcastService.this.service.isShutdown()) {
                    DatagramPacket packet = new DatagramPacket(MulticastBroadcastService.this.receiverBuffer, MulticastBroadcastService.this.receiverBuffer.length);
                    socket.receive(packet);
                    if (!MulticastBroadcastService.this.networkInterface.inetAddresses().noneMatch(a -> a.equals(packet.getAddress()))) continue;
                    String data = new String(packet.getData(), 0, packet.getLength(), StandardCharsets.UTF_8);
                    MulticastBroadcastService.this.handleMessage((BroadcastMessage)MulticastBroadcastService.this.objectMapper.readValue(data, BroadcastMessage.class));
                }
                MulticastBroadcastService.this.publisherSocket = null;
                socket.leaveGroup(MulticastBroadcastService.this.group, MulticastBroadcastService.this.networkInterface);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    };

    public MulticastBroadcastService(Config config, ObjectMapper objectMapper) throws IOException {
        this.objectMapper = objectMapper;
        this.port = config.getInteger(Keys.BROADCAST_PORT);
        String interfaceName = config.getString(Keys.BROADCAST_INTERFACE);
        this.networkInterface = interfaceName.indexOf(46) >= 0 || interfaceName.indexOf(58) >= 0 ? NetworkInterface.getByInetAddress(InetAddress.getByName(interfaceName)) : NetworkInterface.getByName(interfaceName);
        InetAddress address = InetAddress.getByName(config.getString(Keys.BROADCAST_ADDRESS));
        this.group = new InetSocketAddress(address, this.port);
    }

    @Override
    public boolean singleInstance() {
        return false;
    }

    @Override
    public void registerListener(BroadcastInterface listener) {
        this.listeners.add(listener);
    }

    @Override
    public void updateDevice(boolean local, Device device) {
        BroadcastMessage message = new BroadcastMessage();
        message.setDevice(device);
        this.sendMessage(message);
    }

    @Override
    public void updatePosition(boolean local, Position position) {
        BroadcastMessage message = new BroadcastMessage();
        message.setPosition(position);
        this.sendMessage(message);
    }

    @Override
    public void updateEvent(boolean local, long userId, Event event) {
        BroadcastMessage message = new BroadcastMessage();
        message.setUserId(userId);
        message.setEvent(event);
        this.sendMessage(message);
    }

    @Override
    public void invalidateObject(boolean local, Class<? extends BaseModel> clazz, long id) {
        BroadcastMessage message = new BroadcastMessage();
        message.setChanges(Map.of(Permission.getKey(clazz), id));
        this.sendMessage(message);
    }

    @Override
    public void invalidatePermission(boolean local, Class<? extends BaseModel> clazz1, long id1, Class<? extends BaseModel> clazz2, long id2) {
        BroadcastMessage message = new BroadcastMessage();
        message.setChanges(Map.of(Permission.getKey(clazz1), id1, Permission.getKey(clazz2), id2));
        this.sendMessage(message);
    }

    private void sendMessage(BroadcastMessage message) {
        try {
            byte[] buffer = this.objectMapper.writeValueAsString((Object)message).getBytes(StandardCharsets.UTF_8);
            DatagramPacket packet = new DatagramPacket(buffer, buffer.length, this.group);
            this.publisherSocket.send(packet);
        }
        catch (IOException e) {
            LOGGER.warn("Broadcast failed", (Throwable)e);
        }
    }

    private void handleMessage(BroadcastMessage message) {
        Iterator<Map.Entry<String, Long>> iterator;
        if (message.getDevice() != null) {
            this.listeners.forEach(listener -> listener.updateDevice(false, message.getDevice()));
        } else if (message.getPosition() != null) {
            this.listeners.forEach(listener -> listener.updatePosition(false, message.getPosition()));
        } else if (message.getUserId() != null && message.getEvent() != null) {
            this.listeners.forEach(listener -> listener.updateEvent(false, message.getUserId(), message.getEvent()));
        } else if (message.getChanges() != null && (iterator = message.getChanges().entrySet().iterator()).hasNext()) {
            Map.Entry<String, Long> first = iterator.next();
            if (iterator.hasNext()) {
                Map.Entry<String, Long> second = iterator.next();
                this.listeners.forEach(listener -> listener.invalidatePermission(false, Permission.getKeyClass((String)first.getKey()), (Long)first.getValue(), Permission.getKeyClass((String)second.getKey()), (Long)second.getValue()));
            } else {
                this.listeners.forEach(listener -> listener.invalidateObject(false, Permission.getKeyClass((String)first.getKey()), (Long)first.getValue()));
            }
        }
    }

    @Override
    public void start() throws IOException {
        this.service.submit(this.receiver);
    }

    @Override
    public void stop() {
        this.service.shutdown();
    }
}

