/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.traccar.BaseProtocolEncoder;
import org.traccar.Protocol;
import org.traccar.helper.Checksum;
import org.traccar.model.Command;

public class PstProtocolEncoder
extends BaseProtocolEncoder {
    public PstProtocolEncoder(Protocol protocol) {
        super(protocol);
    }

    private ByteBuf encodeContent(long deviceId, int type, int data1, int data2) {
        ByteBuf buf = Unpooled.buffer();
        buf.writeInt((int)Long.parseLong(this.getUniqueId(deviceId)));
        buf.writeByte(6);
        buf.writeInt(1);
        buf.writeByte(6);
        buf.writeShort(type);
        buf.writeShort(data1);
        buf.writeShort(data2);
        buf.writeShort(Checksum.crc16(Checksum.CRC16_XMODEM, buf.nioBuffer()));
        return buf;
    }

    @Override
    protected Object encodeCommand(Command command) {
        switch (command.getType()) {
            case "engineStop": {
                return this.encodeContent(command.getDeviceId(), 2, 65535, 65535);
            }
            case "engineResume": {
                return this.encodeContent(command.getDeviceId(), 1, 65535, 65535);
            }
        }
        return null;
    }
}

