/*
 * Decompiled with CFR 0.152.
 */
package org.jparsec;

import org.jparsec.IntOrder;
import org.jparsec.ParseContext;
import org.jparsec.Parser;
import org.jparsec.TreeNode;

final class BestParser<T>
extends Parser<T> {
    private final Parser<? extends T>[] parsers;
    private final IntOrder order;

    BestParser(Parser<? extends T>[] parsers, IntOrder order) {
        this.parsers = parsers;
        this.order = order;
    }

    @Override
    boolean apply(ParseContext ctxt) {
        Object result = ctxt.result;
        int step = ctxt.step;
        int at = ctxt.at;
        TreeNode latestChild = ctxt.getTrace().getLatestChild();
        for (int i = 0; i < this.parsers.length; ++i) {
            Parser<T> parser = this.parsers[i];
            if (parser.apply(ctxt)) {
                this.applyForBestFit(i + 1, ctxt, result, step, at, latestChild);
                return true;
            }
            ctxt.set(step, at, result);
        }
        return false;
    }

    public String toString() {
        return this.order.toString();
    }

    private void applyForBestFit(int from, ParseContext ctxt, Object originalResult, int originalStep, int originalAt, TreeNode originalLatestChild) {
        int bestAt = ctxt.at;
        int bestStep = ctxt.step;
        Object bestResult = ctxt.result;
        TreeNode bestChild = ctxt.getTrace().getLatestChild();
        for (int i = from; i < this.parsers.length; ++i) {
            int at2;
            ctxt.set(originalStep, originalAt, originalResult);
            ctxt.getTrace().setLatestChild(originalLatestChild);
            Parser<T> parser = this.parsers[i];
            boolean ok = parser.apply(ctxt);
            if (!ok || !this.order.compare(at2 = ctxt.at, bestAt)) continue;
            bestAt = at2;
            bestStep = ctxt.step;
            bestResult = ctxt.result;
            bestChild = ctxt.getTrace().getLatestChild();
        }
        ctxt.set(bestStep, bestAt, bestResult);
        ctxt.getTrace().setLatestChild(bestChild);
    }
}

