/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.core.InternalExtensionOnly;
import com.google.api.gax.core.ResourceCloseException;
import com.google.api.gax.grpc.AutoValue_GrpcTransportChannel;
import com.google.api.gax.grpc.GrpcCallContext;
import com.google.api.gax.rpc.TransportChannel;
import com.google.auto.value.AutoValue;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import java.util.concurrent.TimeUnit;

@InternalExtensionOnly
@AutoValue
public abstract class GrpcTransportChannel
implements TransportChannel {
    public static String getGrpcTransportName() {
        return "grpc";
    }

    public String getTransportName() {
        return GrpcTransportChannel.getGrpcTransportName();
    }

    public GrpcCallContext getEmptyCallContext() {
        return GrpcCallContext.createDefault();
    }

    abstract ManagedChannel getManagedChannel();

    public Channel getChannel() {
        return this.getManagedChannel();
    }

    public void shutdown() {
        this.getManagedChannel().shutdown();
    }

    public boolean isShutdown() {
        return this.getManagedChannel().isShutdown();
    }

    public boolean isTerminated() {
        return this.getManagedChannel().isTerminated();
    }

    public void shutdownNow() {
        this.getManagedChannel().shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.getManagedChannel().awaitTermination(duration, unit);
    }

    public void close() {
        this.getManagedChannel().shutdown();
        try {
            this.awaitTermination(6L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            throw new ResourceCloseException((Exception)e);
        }
    }

    public static Builder newBuilder() {
        return new AutoValue_GrpcTransportChannel.Builder();
    }

    public static GrpcTransportChannel create(ManagedChannel channel) {
        return GrpcTransportChannel.newBuilder().setManagedChannel(channel).build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setManagedChannel(ManagedChannel var1);

        public abstract GrpcTransportChannel build();
    }
}

