/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.jdbc.sharingprofile;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.guacamole.GuacamoleClientException;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.jdbc.base.ModeledChildDirectoryObjectService;
import org.apache.guacamole.auth.jdbc.base.ModeledDirectoryObjectMapper;
import org.apache.guacamole.auth.jdbc.permission.ObjectPermissionMapper;
import org.apache.guacamole.auth.jdbc.permission.SharingProfilePermissionMapper;
import org.apache.guacamole.auth.jdbc.sharingprofile.ModeledSharingProfile;
import org.apache.guacamole.auth.jdbc.sharingprofile.SharingProfileMapper;
import org.apache.guacamole.auth.jdbc.sharingprofile.SharingProfileModel;
import org.apache.guacamole.auth.jdbc.sharingprofile.SharingProfileParameterMapper;
import org.apache.guacamole.auth.jdbc.sharingprofile.SharingProfileParameterModel;
import org.apache.guacamole.auth.jdbc.user.ModeledAuthenticatedUser;
import org.apache.guacamole.net.auth.SharingProfile;
import org.apache.guacamole.net.auth.permission.ObjectPermission;
import org.apache.guacamole.net.auth.permission.ObjectPermissionSet;
import org.apache.guacamole.net.auth.permission.SystemPermission;
import org.apache.guacamole.net.auth.permission.SystemPermissionSet;

public class SharingProfileService
extends ModeledChildDirectoryObjectService<ModeledSharingProfile, SharingProfile, SharingProfileModel> {
    @Inject
    private SharingProfileMapper sharingProfileMapper;
    @Inject
    private SharingProfilePermissionMapper sharingProfilePermissionMapper;
    @Inject
    private SharingProfileParameterMapper parameterMapper;
    @Inject
    private Provider<ModeledSharingProfile> sharingProfileProvider;

    @Override
    protected ModeledDirectoryObjectMapper<SharingProfileModel> getObjectMapper() {
        return this.sharingProfileMapper;
    }

    @Override
    protected ObjectPermissionMapper getPermissionMapper() {
        return this.sharingProfilePermissionMapper;
    }

    @Override
    protected ModeledSharingProfile getObjectInstance(ModeledAuthenticatedUser currentUser, SharingProfileModel model) {
        ModeledSharingProfile sharingProfile = this.sharingProfileProvider.get();
        sharingProfile.init(currentUser, model);
        return sharingProfile;
    }

    @Override
    protected SharingProfileModel getModelInstance(ModeledAuthenticatedUser currentUser, SharingProfile object) {
        SharingProfileModel model = new SharingProfileModel();
        ModeledSharingProfile sharingProfile = this.getObjectInstance(currentUser, model);
        sharingProfile.setPrimaryConnectionIdentifier(object.getPrimaryConnectionIdentifier());
        sharingProfile.setName(object.getName());
        sharingProfile.setParameters(object.getParameters());
        sharingProfile.setAttributes(object.getAttributes());
        return model;
    }

    @Override
    protected boolean hasCreatePermission(ModeledAuthenticatedUser user) throws GuacamoleException {
        SystemPermissionSet permissionSet = user.getUser().getEffectivePermissions().getSystemPermissions();
        return permissionSet.hasPermission(SystemPermission.Type.CREATE_SHARING_PROFILE);
    }

    @Override
    protected ObjectPermissionSet getEffectivePermissionSet(ModeledAuthenticatedUser user) throws GuacamoleException {
        return user.getUser().getEffectivePermissions().getSharingProfilePermissions();
    }

    @Override
    protected ObjectPermissionSet getParentEffectivePermissionSet(ModeledAuthenticatedUser user) throws GuacamoleException {
        return user.getUser().getEffectivePermissions().getConnectionPermissions();
    }

    @Override
    protected void beforeCreate(ModeledAuthenticatedUser user, SharingProfile object, SharingProfileModel model) throws GuacamoleException {
        super.beforeCreate(user, object, model);
        if (model.getName() == null || model.getName().trim().isEmpty()) {
            throw new GuacamoleClientException("Sharing profile names must not be blank.");
        }
        SharingProfileModel existing = this.sharingProfileMapper.selectOneByName(model.getParentIdentifier(), model.getName());
        if (existing != null) {
            throw new GuacamoleClientException("The sharing profile \"" + model.getName() + "\" already exists.");
        }
    }

    @Override
    protected void beforeUpdate(ModeledAuthenticatedUser user, ModeledSharingProfile object, SharingProfileModel model) throws GuacamoleException {
        super.beforeUpdate(user, object, model);
        if (model.getName() == null || model.getName().trim().isEmpty()) {
            throw new GuacamoleClientException("Sharing profile names must not be blank.");
        }
        SharingProfileModel existing = this.sharingProfileMapper.selectOneByName(model.getParentIdentifier(), model.getName());
        if (existing != null && !existing.getObjectID().equals(model.getObjectID())) {
            throw new GuacamoleClientException("The sharing profile \"" + model.getName() + "\" already exists.");
        }
    }

    private Collection<SharingProfileParameterModel> getParameterModels(ModeledSharingProfile sharingProfile) {
        Map<String, String> parameters = sharingProfile.getParameters();
        ArrayList<SharingProfileParameterModel> parameterModels = new ArrayList<SharingProfileParameterModel>(parameters.size());
        for (Map.Entry<String, String> parameterEntry : parameters.entrySet()) {
            String name = parameterEntry.getKey();
            String value = parameterEntry.getValue();
            if (value == null || value.isEmpty()) continue;
            SharingProfileParameterModel model = new SharingProfileParameterModel();
            model.setSharingProfileIdentifier(sharingProfile.getIdentifier());
            model.setName(name);
            model.setValue(value);
            parameterModels.add(model);
        }
        return parameterModels;
    }

    @Override
    public ModeledSharingProfile createObject(ModeledAuthenticatedUser user, SharingProfile object) throws GuacamoleException {
        ModeledSharingProfile sharingProfile = (ModeledSharingProfile)super.createObject(user, object);
        sharingProfile.setParameters(object.getParameters());
        Collection<SharingProfileParameterModel> parameterModels = this.getParameterModels(sharingProfile);
        if (!parameterModels.isEmpty()) {
            this.parameterMapper.insert(parameterModels);
        }
        return sharingProfile;
    }

    @Override
    public void updateObject(ModeledAuthenticatedUser user, ModeledSharingProfile object) throws GuacamoleException {
        super.updateObject(user, object);
        Collection<SharingProfileParameterModel> parameterModels = this.getParameterModels(object);
        this.parameterMapper.delete(object.getIdentifier());
        if (!parameterModels.isEmpty()) {
            this.parameterMapper.insert(parameterModels);
        }
    }

    public Map<String, String> retrieveParameters(ModeledAuthenticatedUser user, String identifier) {
        boolean canRetrieveParameters;
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        try {
            canRetrieveParameters = this.hasObjectPermission(user, identifier, ObjectPermission.Type.UPDATE);
        }
        catch (GuacamoleException e) {
            return parameterMap;
        }
        if (canRetrieveParameters) {
            for (SharingProfileParameterModel parameter : this.parameterMapper.select(identifier)) {
                parameterMap.put(parameter.getName(), parameter.getValue());
            }
        }
        return parameterMap;
    }
}

