/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.util;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.xml.XMLParser;
import org.w3c.dom.Element;

public class HandlerUtil {
    public static void checkXMLVersion(XMLParser parser) {
        String version = parser.getXMLVersion();
        if (version == null) {
            parser.getReport().message(MessageId.HTM_002, EPUBLocation.create(parser.getResourceName(), parser.getLineNumber(), parser.getColumnNumber()), new Object[0]);
        } else if (!"1.0".equals(version)) {
            parser.getReport().message(MessageId.HTM_001, EPUBLocation.create(parser.getResourceName(), parser.getLineNumber(), parser.getColumnNumber()), version);
        }
    }

    public static int getElementLineNumber(Element e) {
        return HandlerUtil.getElementIntAttribute(e, "elementLineNumber");
    }

    public static int getElementColumnNumber(Element e) {
        return HandlerUtil.getElementIntAttribute(e, "elementColumnNumber");
    }

    static int getElementIntAttribute(Element e, String whichAttribute) {
        int val = -1;
        String number = e.getAttribute(whichAttribute);
        if (number != null) {
            try {
                val = Integer.parseInt(number.trim());
            }
            catch (NumberFormatException ex) {
                val = -1;
            }
        }
        return val;
    }
}

