/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.application.ConnectionDiagnoseRefresher;
import org.jetbrains.idea.perforce.application.P4RootsInformation;
import org.jetbrains.idea.perforce.application.PerforceClientRootsChecker;
import org.jetbrains.idea.perforce.perforce.connections.P4ConfigHelper;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.connections.P4ConnectionParameters;
import org.jetbrains.idea.perforce.perforce.connections.P4ParametersConnection;
import org.jetbrains.idea.perforce.perforce.connections.PerforceMultipleConnections;

public class P4ConfigConnectionDiagnoseDialog
extends DialogWrapper {
    private PerforceMultipleConnections myMultipleConnections;
    private P4RootsInformation myChecker;
    private Tree myTree;
    private BaseNode myRoot;
    private final Project myProject;
    private final ConnectionDiagnoseRefresher myRefresher;
    private DialogWrapper.DialogWrapperAction myRefreshAction;

    public P4ConfigConnectionDiagnoseDialog(Project project, ConnectionDiagnoseRefresher refresher) {
        super(project, true);
        this.myProject = project;
        this.myRefresher = refresher;
        this.setTitle(PerforceBundle.message("config.dialog.title", new Object[0]));
        this.setCancelButtonText(CommonBundle.message((String)"close.action.name", (Object[])new Object[0]));
        this.init();
    }

    protected Action @NotNull [] createActions() {
        this.myRefreshAction = new DialogWrapper.DialogWrapperAction(CommonBundle.message((String)"action.refresh", (Object[])new Object[0])){

            protected void doAction(ActionEvent e) {
                P4ConfigConnectionDiagnoseDialog.this.myTree.setPaintBusy(true);
                P4ConfigConnectionDiagnoseDialog.this.myTree.setEnabled(false);
                boolean complete = ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> P4ConfigConnectionDiagnoseDialog.this.myRefresher.refresh(), PerforceBundle.message("config.refresh", new Object[0]), true, P4ConfigConnectionDiagnoseDialog.this.myProject);
                if (complete) {
                    P4ConfigConnectionDiagnoseDialog.this.fillTree();
                }
                P4ConfigConnectionDiagnoseDialog.this.myTree.setPaintBusy(false);
                P4ConfigConnectionDiagnoseDialog.this.myTree.setEnabled(true);
            }
        };
        Action[] actionArray = new Action[]{this.myRefreshAction, this.getCancelAction()};
        if (actionArray == null) {
            P4ConfigConnectionDiagnoseDialog.$$$reportNull$$$0(0);
        }
        return actionArray;
    }

    private void fillTree() {
        this.myRoot.removeAllChildren();
        this.myMultipleConnections = this.myRefresher.getMultipleConnections();
        this.myChecker = this.myRefresher.getP4RootsInformation();
        DefaultTreeModel model = (DefaultTreeModel)this.myTree.getModel();
        TreeMap<VirtualFile, P4ConnectionParameters> map = this.myMultipleConnections.getParametersMap();
        P4ConnectionParameters defaultParameters = this.myMultipleConnections.getDefaultParameters();
        Map<VirtualFile, File> configsMap = this.myMultipleConnections.getConfigsMap();
        LinkedHashSet p4ConfigNames = new LinkedHashSet();
        int i = 0;
        boolean containNoConfigs = false;
        for (Map.Entry<VirtualFile, P4ConnectionParameters> entry : map.entrySet()) {
            VirtualFile root = entry.getKey();
            BaseNode fileNode = new BaseNode((Object)root, NodeType.root);
            model.insertNodeInto(fileNode, this.myRoot, i);
            File configDir = configsMap.get(root);
            this.putConfigDir(fileNode, configDir, entry.getValue().isNoConfigFound());
            P4ConnectionParameters parameters = entry.getValue();
            containNoConfigs |= parameters.isNoConfigFound();
            ContainerUtil.addIfNotNull(p4ConfigNames, (Object)parameters.getConfigFileName());
            if (!P4ConfigConnectionDiagnoseDialog.putConfigLines(defaultParameters, fileNode, configDir, parameters)) {
                P4ConfigConnectionDiagnoseDialog.addGenericErrors(fileNode, parameters);
                continue;
            }
            if (!this.checkConnection(root, fileNode)) {
                P4ConfigConnectionDiagnoseDialog.addGenericErrors(fileNode, parameters);
                continue;
            }
            boolean someErrors = P4ConfigConnectionDiagnoseDialog.addGenericErrors(fileNode, parameters);
            if (!(someErrors |= this.addRootError(Objects.requireNonNull(this.myMultipleConnections.getConnection(root)), fileNode))) {
                P4ConfigConnectionDiagnoseDialog.addNode(fileNode, new BaseNode((Object)CommonBundle.message((String)"button.ok", (Object[])new Object[0]), NodeType.ok));
            }
            ++i;
        }
        String envP4Config = P4ConfigHelper.getP4ConfigFileName();
        if (envP4Config != null) {
            P4ConfigConnectionDiagnoseDialog.addNode(this.myRoot, new BaseNode((Object)PerforceBundle.message("connection.env", envP4Config), NodeType.info));
        }
        P4ConfigConnectionDiagnoseDialog.addGenericErrors(this.myRoot, defaultParameters);
        if (containNoConfigs) {
            if (p4ConfigNames.isEmpty()) {
                ContainerUtil.addIfNotNull(p4ConfigNames, (Object)envP4Config);
            }
            if (!p4ConfigNames.isEmpty()) {
                P4ConfigConnectionDiagnoseDialog.addNode(this.myRoot, new BaseNode((Object)PerforceBundle.message("connection.config.file", StringUtil.join(p4ConfigNames, (String)", ")), NodeType.info));
            }
        }
        model.nodeStructureChanged(this.myRoot);
        TreeUtil.expand((JTree)this.myTree, (int)3);
    }

    private static boolean addGenericErrors(BaseNode fileNode, P4ConnectionParameters parameters) {
        boolean somethingAdded = false;
        Throwable exception = parameters.getException();
        if (exception != null) {
            P4ConfigConnectionDiagnoseDialog.addNode(fileNode, new ErrorNode(exception.getMessage()));
            somethingAdded = true;
        }
        List<String> warnings = parameters.getWarnings();
        for (String warning : warnings) {
            P4ConfigConnectionDiagnoseDialog.addNode(fileNode, new ErrorNode(warning));
            somethingAdded = true;
        }
        return somethingAdded;
    }

    private static void addNode(BaseNode parent, BaseNode child) {
        parent.add(child);
        child.setParent(parent);
    }

    private boolean addRootError(@NotNull P4Connection connection, BaseNode fileNode) {
        if (connection == null) {
            P4ConfigConnectionDiagnoseDialog.$$$reportNull$$$0(1);
        }
        boolean somethingAdded = false;
        if (this.myChecker.getNotAuthorized().contains(connection)) {
            P4ConfigConnectionDiagnoseDialog.addNode(fileNode, new ErrorNode(PerforceBundle.message("login.not.logged.in", new Object[0])));
            somethingAdded = true;
        }
        Collection exceptions = this.myChecker.getErrors().get((Object)connection);
        for (VcsException exception : exceptions) {
            ErrorNode node = new ErrorNode(exception.getMessage());
            P4ConfigConnectionDiagnoseDialog.addNode(fileNode, node);
            somethingAdded = true;
        }
        PerforceClientRootsChecker.WrongRoots wrongRoots = this.myChecker.getMap().get(connection);
        if (wrongRoots != null) {
            ErrorNode node = new ErrorNode(PerforceBundle.message("config.wrong.client.spec", new Object[0]));
            P4ConfigConnectionDiagnoseDialog.addNode(fileNode, node);
            somethingAdded = true;
            ArrayList<ErrorNode> children = new ArrayList<ErrorNode>();
            children.add(new ErrorNode(PerforceBundle.message("config.client.roots", new Object[0]) + " "));
            for (String clientRoot : wrongRoots.getActualInClientSpec()) {
                children.add(new ErrorNode(clientRoot));
            }
            children.add(new ErrorNode(PerforceBundle.message("config.actual.root", new Object[0]) + " "));
            for (VirtualFile vf : wrongRoots.getWrong()) {
                children.add(new ErrorNode(vf.getPath()));
            }
            for (ErrorNode child : children) {
                P4ConfigConnectionDiagnoseDialog.addNode(node, child);
            }
        }
        return somethingAdded;
    }

    private boolean checkConnection(VirtualFile root, BaseNode fileNode) {
        P4ParametersConnection connection = this.myMultipleConnections.getConnection(root);
        if (connection == null) {
            ErrorNode node = new ErrorNode(PerforceBundle.message("connection.cannot.create", new Object[0]));
            P4ConfigConnectionDiagnoseDialog.addNode(fileNode, node);
            return false;
        }
        if (!connection.isConnected()) {
            ErrorNode node = new ErrorNode(PerforceBundle.message("connection.not.connected", new Object[0]));
            P4ConfigConnectionDiagnoseDialog.addNode(fileNode, node);
            return false;
        }
        return true;
    }

    private void putConfigDir(BaseNode fileNode, File configDir, boolean noConfigFound) {
        String p4ConfigValue = this.myMultipleConnections.getP4ConfigValue();
        if (configDir != null && !noConfigFound && p4ConfigValue != null) {
            File file = new File(FileUtil.toSystemDependentName((String)configDir.getPath()), p4ConfigValue);
            P4ConfigConnectionDiagnoseDialog.addNode(fileNode, new BaseNode((Object)file, NodeType.p4configFile));
        } else {
            P4ConfigConnectionDiagnoseDialog.addNode(fileNode, new BaseNode((Object)PerforceBundle.message("connection.no.config.file", new Object[0]), NodeType.noConfig));
        }
    }

    private static boolean putConfigLines(P4ConnectionParameters defaultParameters, BaseNode fileNode, File configDir, P4ConnectionParameters parameters) {
        Map<String, ConfigLine> dataPresentation = P4ConfigConnectionDiagnoseDialog.getDataPresentation(parameters, defaultParameters, configDir == null);
        if (dataPresentation.isEmpty()) {
            P4ConfigConnectionDiagnoseDialog.addNode(fileNode, new ErrorNode(PerforceBundle.message("connection.no.params", new Object[0])));
            return false;
        }
        for (ConfigLine line : dataPresentation.values()) {
            P4ConfigConnectionDiagnoseDialog.addNode(fileNode, new BaseNode((Object)line, NodeType.configLine));
        }
        boolean requiredParametersDefined = true;
        if (parameters.getServer() == null && defaultParameters.getServer() == null) {
            P4ConfigConnectionDiagnoseDialog.addNode(fileNode, new ErrorNode(PerforceBundle.message("error.server.unknown.env", new Object[0])));
            requiredParametersDefined = false;
        }
        if (parameters.getUser() == null && defaultParameters.getUser() == null) {
            P4ConfigConnectionDiagnoseDialog.addNode(fileNode, new ErrorNode(PerforceBundle.message("error.user.unknown.env", new Object[0])));
            requiredParametersDefined = false;
        }
        if (parameters.getClient() == null && defaultParameters.getClient() == null) {
            P4ConfigConnectionDiagnoseDialog.addNode(fileNode, new ErrorNode(PerforceBundle.message("error.client.unknown.env", new Object[0])));
            requiredParametersDefined = false;
        }
        return requiredParametersDefined;
    }

    public static Map<String, ConfigLine> getDataPresentation(P4ConnectionParameters p, P4ConnectionParameters d, boolean noConfig) {
        HashMap<String, ConfigLine> result = new HashMap<String, ConfigLine>();
        if (noConfig) {
            P4ConfigConnectionDiagnoseDialog.putParametersIntoTheMap(d, result, "");
        } else {
            P4ConfigConnectionDiagnoseDialog.putParametersIntoTheMap(d, result, "environment");
            P4ConfigConnectionDiagnoseDialog.putParametersIntoTheMap(p, result, "config");
        }
        return result;
    }

    private static void putParametersIntoTheMap(P4ConnectionParameters p, Map<String, ConfigLine> map, String source) {
        P4ConfigConnectionDiagnoseDialog.addIfNotNull(p.getServer(), "P4PORT = ", map, source, 0);
        P4ConfigConnectionDiagnoseDialog.addIfNotNull(p.getClient(), "P4CLIENT = ", map, source, 1);
        P4ConfigConnectionDiagnoseDialog.addIfNotNull(p.getUser(), "P4USER = ", map, source, 2);
        if (p.getPassword() != null) {
            map.put("3Password:", new ConfigLine(source, "P4PASSWD = ", "********"));
        }
        P4ConfigConnectionDiagnoseDialog.addIfNotNull(p.getCharset(), "P4CHARSET = ", map, source, 4);
        P4ConfigConnectionDiagnoseDialog.addIfNotNull(p.getIgnoreFileName(), "P4IGNORE = ", map, source, 5);
    }

    private static void addIfNotNull(String value, String text, Map<String, ConfigLine> map, String source, int i) {
        if (value != null) {
            map.put(i + text, new ConfigLine(source, text, value));
        }
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTree;
    }

    protected String getDimensionServiceKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.myRoot = new BaseNode((Object)"", NodeType.veryRoot);
        this.myTree = new Tree((TreeNode)this.myRoot);
        new TreeSpeedSearch((JTree)this.myTree);
        TreeUtil.installActions((JTree)this.myTree);
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(false);
        this.myTree.setCellRenderer((TreeCellRenderer)((Object)new MyRenderer()));
        this.fillTree();
        panel.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myTree), "Center");
        return panel;
    }

    @NlsSafe
    private static String getParentPath(File configFile) {
        String parent = configFile.getParent().replace('\\', '/');
        return " (" + parent + ")";
    }

    @NlsSafe
    private static String getParentPath(VirtualFile root) {
        VirtualFile parent = root.getParent();
        String fragment = parent != null ? "(" + parent.getPath() + ")" : "(" + root.getPath() + ")";
        return fragment;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/perforce/application/P4ConfigConnectionDiagnoseDialog";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/perforce/application/P4ConfigConnectionDiagnoseDialog";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addRootError";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyRenderer
    extends ColoredTreeCellRenderer {
        public static final SimpleTextAttributes GREEN = new SimpleTextAttributes(0, JBColor.GREEN.darker(), null);

        private MyRenderer() {
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (tree == null) {
                MyRenderer.$$$reportNull$$$0(0);
            }
            if (!(value instanceof BaseNode)) {
                return;
            }
            BaseNode baseNode = (BaseNode)value;
            NodeType type = baseNode.getNodeType();
            Object uo = baseNode.getUserObject();
            if (NodeType.root.equals((Object)type)) {
                this.setIcon(PlatformIcons.FOLDER_ICON);
                VirtualFile root = (VirtualFile)uo;
                this.append(root.getName() + " ");
                String fragment = P4ConfigConnectionDiagnoseDialog.getParentPath(root);
                this.append(fragment, SimpleTextAttributes.GRAY_ATTRIBUTES);
            } else if (NodeType.p4configFile.equals((Object)type)) {
                File configFile = (File)uo;
                this.setIcon(AllIcons.General.Settings);
                this.append(PerforceBundle.message("config.file", configFile.getName()) + " ", SimpleTextAttributes.DARK_TEXT);
                String parentPath = P4ConfigConnectionDiagnoseDialog.getParentPath(configFile);
                this.append(parentPath, SimpleTextAttributes.GRAY_ATTRIBUTES);
            } else if (NodeType.noConfig.equals((Object)type)) {
                String text = (String)uo;
                this.setIcon(AllIcons.General.Settings);
                this.append(text, SimpleTextAttributes.DARK_TEXT);
            } else if (NodeType.string.equals((Object)type)) {
                this.append((String)uo);
            } else if (NodeType.configLine.equals((Object)type)) {
                ConfigLine cl = (ConfigLine)uo;
                this.append(cl.getParam());
                this.append(cl.getValue());
                String source = cl.getSource();
                if (!StringUtil.isEmptyOrSpaces((String)source)) {
                    this.append(" (" + source + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
                }
            } else if (NodeType.problem.equals((Object)type)) {
                assert (baseNode instanceof ErrorNode);
                this.append((String)uo, SimpleTextAttributes.ERROR_ATTRIBUTES);
            } else if (NodeType.ok.equals((Object)type)) {
                this.append((String)uo, GREEN);
            } else if (NodeType.info.equals((Object)type)) {
                this.setIcon(AllIcons.General.Information);
                this.append((String)uo);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "org/jetbrains/idea/perforce/application/P4ConfigConnectionDiagnoseDialog$MyRenderer", "customizeCellRenderer"));
        }
    }

    private static enum NodeType {
        veryRoot,
        root,
        p4configFile,
        configLine,
        problem,
        string,
        ok,
        info,
        noConfig;

    }

    private static class BaseNode
    extends DefaultMutableTreeNode {
        private final NodeType myNodeType;

        protected BaseNode(Object userObject, NodeType nodeType) {
            super(userObject);
            this.myNodeType = nodeType;
        }

        public NodeType getNodeType() {
            return this.myNodeType;
        }

        @Override
        public String toString() {
            if (NodeType.root.equals((Object)this.myNodeType)) {
                VirtualFile vf = (VirtualFile)this.getUserObject();
                return vf.getName() + " " + P4ConfigConnectionDiagnoseDialog.getParentPath(vf);
            }
            if (NodeType.p4configFile.equals((Object)this.myNodeType)) {
                File file = (File)this.getUserObject();
                return PerforceBundle.message("config.file", file.getName()) + " " + P4ConfigConnectionDiagnoseDialog.getParentPath(file);
            }
            return this.getUserObject().toString();
        }
    }

    private static final class ErrorNode
    extends BaseNode {
        private ErrorNode(String text) {
            super((Object)text, NodeType.problem);
        }

        @Override
        public String toString() {
            return (String)this.getUserObject();
        }
    }

    private static final class ConfigLine {
        private final String mySource;
        private final String myParam;
        private final String myValue;

        private ConfigLine(String source, String param, String value) {
            this.mySource = source;
            this.myParam = param;
            this.myValue = value;
        }

        @NlsSafe
        public String getSource() {
            return this.mySource;
        }

        @NlsSafe
        public String getParam() {
            return this.myParam;
        }

        @NlsSafe
        public String getValue() {
            return this.myValue;
        }

        public String toString() {
            return this.myParam + this.myValue;
        }
    }
}

