/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xsltDebugger.rt.engine.local.xalan;

import java.io.PrintWriter;
import javax.xml.transform.SourceLocator;
import org.apache.xalan.trace.GenerateEvent;
import org.apache.xalan.trace.PrintTraceListener;
import org.apache.xalan.trace.TracerEvent;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMIterator;
import org.apache.xml.serializer.SerializationHandler;
import org.intellij.plugins.xsltDebugger.rt.engine.Debugger;
import org.intellij.plugins.xsltDebugger.rt.engine.local.AbstractFrame;
import org.intellij.plugins.xsltDebugger.rt.engine.local.LocalDebugger;
import org.intellij.plugins.xsltDebugger.rt.engine.local.xalan.TracingSerializationHandler;
import org.intellij.plugins.xsltDebugger.rt.engine.local.xalan.XalanStyleFrame;
import org.intellij.plugins.xsltDebugger.rt.engine.local.xalan.XalanSupport;

public class XalanTraceListener
extends PrintTraceListener {
    private final LocalDebugger myDebugger;
    private final TransformerImpl myTransformer;
    private volatile boolean myTracing = false;
    private boolean firstTrace = true;

    public XalanTraceListener(LocalDebugger localDebugger, TransformerImpl tr) {
        super(new PrintWriter(System.out, true));
        this.m_traceElements = false;
        this.m_traceGeneration = false;
        this.m_traceSelection = false;
        this.myDebugger = localDebugger;
        this.myTransformer = tr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trace(TracerEvent ev) {
        if (this.myTracing) {
            return;
        }
        this.myTracing = true;
        try {
            boolean withSource;
            if (this.firstTrace) {
                this.firstTrace = false;
                SerializationHandler handler = this.myTransformer.getSerializationHandler();
                this.myTransformer.setSerializationHandler((SerializationHandler)new TracingSerializationHandler(this.myDebugger, handler));
            }
            super.trace(ev);
            DTMIterator iterator = this.myTransformer.getContextNodeList();
            int node = this.myTransformer.getMatchedNode();
            Debugger.SourceFrame sourceFrame = this.myDebugger.getSourceFrame();
            if (sourceFrame == null || ((MySourceFrame)sourceFrame).getMatchedNode() != node) {
                this.myDebugger.pushSource(new MySourceFrame(sourceFrame, iterator.getDTM(node), node));
                withSource = true;
            } else {
                withSource = false;
            }
            this.myDebugger.enter(new XalanStyleFrame(ev, this.myDebugger.getCurrentFrame(), withSource));
        }
        finally {
            this.myTracing = false;
        }
    }

    public void traceEnd(TracerEvent ev) {
        if (this.myTracing) {
            return;
        }
        if (this.myDebugger.getCurrentFrame() == null) {
            return;
        }
        String instr = XalanStyleFrame.getInstruction(ev.m_styleNode);
        if (instr != null) {
            while (!instr.equals(this.myDebugger.getCurrentFrame().getInstruction())) {
                this.leave();
            }
        }
        super.traceEnd(ev);
        this.leave();
    }

    private void leave() {
        if (((XalanStyleFrame)this.myDebugger.getCurrentFrame()).isWithSourceFrame()) {
            this.myDebugger.popSource();
        }
        this.myDebugger.leave();
    }

    public void generated(GenerateEvent ev) {
        if (!(this.myTransformer.getSerializationHandler() instanceof TracingSerializationHandler)) {
            return;
        }
        switch (ev.m_eventtype) {
            case 1: {
                this.myDebugger.getEventQueue().startDocument();
                break;
            }
            case 2: {
                this.myDebugger.getEventQueue().endDocument();
                break;
            }
            case 4: {
                this.myDebugger.getEventQueue().endElement();
                break;
            }
            case 5: 
            case 10: {
                this.myDebugger.getEventQueue().characters(new String(ev.m_characters, ev.m_start, ev.m_length));
                break;
            }
            case 8: {
                this.myDebugger.getEventQueue().comment(ev.m_data);
                break;
            }
            case 7: {
                this.myDebugger.getEventQueue().pi(ev.m_name, ev.m_data);
            }
        }
    }

    private static class MySourceFrame
    extends AbstractFrame<Debugger.SourceFrame>
    implements Debugger.SourceFrame {
        private final String mySystemId;
        private final int myLineNumber;
        private final int myMatchedNode;
        private final String myPath;

        MySourceFrame(Debugger.SourceFrame sourceFrame, DTM dtm, int node) {
            super(sourceFrame);
            SourceLocator loc = dtm.getSourceLocatorFor(node);
            this.mySystemId = loc.getSystemId();
            this.myLineNumber = loc.getLineNumber();
            this.myPath = XalanSupport.getPath(dtm, node);
            this.myMatchedNode = node;
        }

        public String getXPath() {
            return this.myPath;
        }

        public String getURI() {
            return this.mySystemId;
        }

        public int getLineNumber() {
            return this.myLineNumber;
        }

        public int getMatchedNode() {
            return this.myMatchedNode;
        }
    }
}

