/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.errors.CommandFailedException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.ProcessResult;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.jgit.util.SystemReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FS_POSIX
extends FS {
    private static final Logger LOG = LoggerFactory.getLogger(FS_POSIX.class);
    private static final int DEFAULT_UMASK = 18;
    private volatile int umask = -1;
    private volatile boolean supportsUnixNLink = true;
    private volatile AtomicFileCreation supportsAtomicCreateNewFile = AtomicFileCreation.UNDEFINED;

    protected FS_POSIX() {
    }

    protected FS_POSIX(FS src) {
        super(src);
        if (src instanceof FS_POSIX) {
            this.umask = ((FS_POSIX)src).umask;
        }
    }

    private void determineAtomicFileCreationSupport() {
        AtomicFileCreation ret = this.getAtomicFileCreationSupportOption(SystemReader.getInstance().openUserConfig(null, this));
        if (ret == AtomicFileCreation.UNDEFINED && StringUtils.isEmptyOrNull(SystemReader.getInstance().getenv("GIT_CONFIG_NOSYSTEM"))) {
            ret = this.getAtomicFileCreationSupportOption(SystemReader.getInstance().openSystemConfig(null, this));
        }
        this.supportsAtomicCreateNewFile = ret;
    }

    private AtomicFileCreation getAtomicFileCreationSupportOption(FileBasedConfig config) {
        try {
            config.load();
            String value = config.getString("core", null, "supportsatomicfilecreation");
            if (value == null) {
                return AtomicFileCreation.UNDEFINED;
            }
            return StringUtils.toBoolean(value) ? AtomicFileCreation.SUPPORTED : AtomicFileCreation.NOT_SUPPORTED;
        }
        catch (IOException | ConfigInvalidException e) {
            return AtomicFileCreation.SUPPORTED;
        }
    }

    @Override
    public FS newInstance() {
        return new FS_POSIX(this);
    }

    public void setUmask(int umask) {
        this.umask = umask;
    }

    private int umask() {
        int u = this.umask;
        if (u == -1) {
            this.umask = u = FS_POSIX.readUmask();
        }
        return u;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int readUmask() {
        try {
            Process p = Runtime.getRuntime().exec(new String[]{"sh", "-c", "umask"}, null, null);
            try (BufferedReader lineRead = new BufferedReader(new InputStreamReader(p.getInputStream(), Charset.defaultCharset().name()));){
                String s;
                if (p.waitFor() == 0 && (s = lineRead.readLine()) != null && s.matches("0?\\d{3}")) {
                    int n2 = Integer.parseInt(s, 8);
                    return n2;
                }
                int n = 18;
                return n;
            }
        }
        catch (Exception e) {
            return 18;
        }
    }

    @Override
    protected File discoverGitExe() {
        String path = SystemReader.getInstance().getenv("PATH");
        File gitExe = FS_POSIX.searchPath(path, "git");
        if (gitExe == null && SystemReader.getInstance().isMacOS() && FS_POSIX.searchPath(path, "bash") != null) {
            String w;
            try {
                w = FS_POSIX.readPipe(this.userHome(), new String[]{"bash", "--login", "-c", "which git"}, Charset.defaultCharset().name());
            }
            catch (CommandFailedException e) {
                LOG.warn(e.getMessage());
                return null;
            }
            if (!StringUtils.isEmptyOrNull(w)) {
                gitExe = new File(w);
            }
        }
        return gitExe;
    }

    @Override
    public boolean isCaseSensitive() {
        return !SystemReader.getInstance().isMacOS();
    }

    @Override
    public boolean supportsExecute() {
        return true;
    }

    @Override
    public boolean canExecute(File f) {
        return FileUtils.canExecute(f);
    }

    @Override
    public boolean setExecute(File f, boolean canExecute) {
        if (!this.isFile(f)) {
            return false;
        }
        if (!canExecute) {
            return f.setExecutable(false, false);
        }
        try {
            Path path = FileUtils.toPath(f);
            Set<PosixFilePermission> pset = Files.getPosixFilePermissions(path, new LinkOption[0]);
            pset.add(PosixFilePermission.OWNER_EXECUTE);
            int mask = this.umask();
            FS_POSIX.apply(pset, mask, PosixFilePermission.GROUP_EXECUTE, 8);
            FS_POSIX.apply(pset, mask, PosixFilePermission.OTHERS_EXECUTE, 1);
            Files.setPosixFilePermissions(path, pset);
            return true;
        }
        catch (IOException e) {
            boolean debug = Boolean.parseBoolean(SystemReader.getInstance().getProperty("jgit.fs.debug"));
            if (debug) {
                System.err.println(e);
            }
            return false;
        }
    }

    private static void apply(Set<PosixFilePermission> set, int umask, PosixFilePermission perm, int test) {
        if ((umask & test) == 0) {
            set.add(perm);
        } else {
            set.remove((Object)perm);
        }
    }

    @Override
    public ProcessBuilder runInShell(String cmd, String[] args) {
        ArrayList<String> argv = new ArrayList<String>(4 + args.length);
        argv.add("sh");
        argv.add("-c");
        argv.add(cmd + " \"$@\"");
        argv.add(cmd);
        argv.addAll(Arrays.asList(args));
        ProcessBuilder proc = new ProcessBuilder(new String[0]);
        proc.command(argv);
        return proc;
    }

    @Override
    public ProcessResult runHookIfPresent(Repository repository2, String hookName, String[] args, PrintStream outRedirect, PrintStream errRedirect, String stdinArgs) throws JGitInternalException {
        return this.internalRunHookIfPresent(repository2, hookName, args, outRedirect, errRedirect, stdinArgs);
    }

    @Override
    public boolean retryFailedLockFileCommit() {
        return false;
    }

    @Override
    public boolean supportsSymlinks() {
        return true;
    }

    @Override
    public void setHidden(File path, boolean hidden) throws IOException {
    }

    @Override
    public FS.Attributes getAttributes(File path) {
        return FileUtils.getFileAttributesPosix(this, path);
    }

    @Override
    public File normalize(File file) {
        return FileUtils.normalize(file);
    }

    @Override
    public String normalize(String name) {
        return FileUtils.normalize(name);
    }

    @Override
    public File findHook(Repository repository2, String hookName) {
        File gitdir = repository2.getDirectory();
        if (gitdir == null) {
            return null;
        }
        Path hookPath = gitdir.toPath().resolve("hooks").resolve(hookName);
        if (Files.isExecutable(hookPath)) {
            return hookPath.toFile();
        }
        return null;
    }

    @Override
    public boolean supportsAtomicCreateNewFile() {
        if (this.supportsAtomicCreateNewFile == AtomicFileCreation.UNDEFINED) {
            this.determineAtomicFileCreationSupport();
        }
        return this.supportsAtomicCreateNewFile == AtomicFileCreation.SUPPORTED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Deprecated
    public boolean createNewFile(File lock) throws IOException {
        boolean bl;
        Path link;
        block12: {
            boolean bl2;
            block11: {
                if (!lock.createNewFile()) {
                    return false;
                }
                if (this.supportsAtomicCreateNewFile()) return true;
                if (!this.supportsUnixNLink) {
                    return true;
                }
                Path lockPath = lock.toPath();
                link = null;
                try {
                    link = Files.createLink(Paths.get(lock.getAbsolutePath() + ".lnk", new String[0]), lockPath);
                    Integer nlink = (Integer)Files.getAttribute(lockPath, "unix:nlink", new LinkOption[0]);
                    if (nlink > 2) {
                        LOG.warn("nlink of link to lock file {} was not 2 but {}", (Object)lock.getPath(), (Object)nlink);
                        bl2 = false;
                        if (link == null) return bl2;
                        break block11;
                    }
                    if (nlink < 2) {
                        this.supportsUnixNLink = false;
                    }
                    bl = true;
                    if (link == null) return bl;
                    break block12;
                }
                catch (IllegalArgumentException | UnsupportedOperationException e) {
                    this.supportsUnixNLink = false;
                    boolean bl3 = true;
                    return bl3;
                }
            }
            Files.delete(link);
            return bl2;
        }
        Files.delete(link);
        return bl;
        finally {
            if (link != null) {
                Files.delete(link);
            }
        }
    }

    @Override
    public FS.LockToken createNewFileAtomic(File file) throws IOException {
        if (!file.createNewFile()) {
            return FS_POSIX.token(false, null);
        }
        if (this.supportsAtomicCreateNewFile() || !this.supportsUnixNLink) {
            return FS_POSIX.token(true, null);
        }
        Path link = null;
        Path path = file.toPath();
        try {
            link = Files.createLink(Paths.get(FS_POSIX.uniqueLinkPath(file), new String[0]), path);
            Integer nlink = (Integer)Files.getAttribute(path, "unix:nlink", new LinkOption[0]);
            if (nlink > 2) {
                LOG.warn(MessageFormat.format(JGitText.get().failedAtomicFileCreation, path, nlink));
                return FS_POSIX.token(false, link);
            }
            if (nlink < 2) {
                this.supportsUnixNLink = false;
            }
            return FS_POSIX.token(true, link);
        }
        catch (IllegalArgumentException | UnsupportedOperationException e) {
            this.supportsUnixNLink = false;
            return FS_POSIX.token(true, link);
        }
    }

    private static FS.LockToken token(boolean created, @Nullable Path p) {
        return p != null && Files.exists(p, new LinkOption[0]) ? new FS.LockToken(created, Optional.of(p)) : new FS.LockToken(created, Optional.empty());
    }

    private static String uniqueLinkPath(File file) {
        UUID id = UUID.randomUUID();
        return file.getAbsolutePath() + "." + Long.toHexString(id.getMostSignificantBits()) + Long.toHexString(id.getLeastSignificantBits());
    }

    private static enum AtomicFileCreation {
        SUPPORTED,
        NOT_SUPPORTED,
        UNDEFINED;

    }
}

