/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiDiamondTypeImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.augment.PsiAugmentProvider;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.RecaptureTypeMapper;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class PsiDiamondTypeUtil {
    private static final Logger LOG = Logger.getInstance(PsiDiamondTypeUtil.class);

    private PsiDiamondTypeUtil() {
    }

    public static boolean canCollapseToDiamond(PsiNewExpression expression2, PsiNewExpression context, @Nullable PsiType expectedType) {
        return PsiDiamondTypeUtil.canCollapseToDiamond(expression2, context, expectedType, false);
    }

    public static boolean canChangeContextForDiamond(PsiNewExpression expression2, PsiType expectedType) {
        PsiNewExpression copy2 = (PsiNewExpression)expression2.copy();
        return PsiDiamondTypeUtil.canCollapseToDiamond(copy2, copy2, expectedType, true);
    }

    private static boolean canCollapseToDiamond(PsiNewExpression expression2, PsiNewExpression context, @Nullable PsiType expectedType, boolean skipDiamonds) {
        PsiTypeElement[] typeElements;
        PsiReferenceParameterList parameterList2;
        PsiJavaCodeReferenceElement classReference;
        if (PsiUtil.getLanguageLevel(context).isAtLeast(LanguageLevel.JDK_1_7) && (classReference = expression2.getClassOrAnonymousClassReference()) != null && (parameterList2 = classReference.getParameterList()) != null && (typeElements = parameterList2.getTypeParameterElements()).length > 0) {
            if (!skipDiamonds && typeElements.length == 1 && typeElements[0].getType() instanceof PsiDiamondType) {
                return false;
            }
            PsiDiamondType.DiamondInferenceResult inferenceResult = PsiDiamondTypeImpl.resolveInferredTypes(expression2, context);
            if (inferenceResult.getErrorMessage() == null) {
                PsiAnonymousClass anonymousClass = expression2.getAnonymousClass();
                if (anonymousClass != null && ContainerUtil.exists(anonymousClass.getMethods(), method -> !method.hasModifierProperty("private") && method.findSuperMethods().length == 0)) {
                    return false;
                }
                List<PsiType> types2 = inferenceResult.getInferredTypes();
                PsiType[] typeArguments2 = null;
                if (expectedType instanceof PsiClassType) {
                    typeArguments2 = ((PsiClassType)expectedType).getParameters();
                }
                if (typeArguments2 == null) {
                    typeArguments2 = parameterList2.getTypeArguments();
                }
                if (types2.size() == typeArguments2.length) {
                    PsiMethod method2 = expression2.resolveMethod();
                    PsiElement resolve2 = classReference.resolve();
                    if (resolve2 instanceof PsiClass) {
                        PsiTypeParameter[] typeParameters2 = ((PsiClass)resolve2).getTypeParameters();
                        return PsiDiamondTypeUtil.areTypeArgumentsRedundant(typeArguments2, context, true, method2, typeParameters2);
                    }
                }
            }
        }
        return false;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2019.3")
    public static PsiElement replaceExplicitWithDiamond(PsiElement psiElement) {
        PsiElement replacement = PsiDiamondTypeUtil.createExplicitReplacement(psiElement);
        return replacement == null ? psiElement : psiElement.replace(replacement);
    }

    public static PsiElement createExplicitReplacement(PsiElement psiElement) {
        if (psiElement instanceof PsiReferenceParameterList) {
            PsiNewExpression expression2 = (PsiNewExpression)JavaPsiFacade.getElementFactory(psiElement.getProject()).createExpressionFromText("new a<>()", psiElement);
            PsiJavaCodeReferenceElement classReference = expression2.getClassReference();
            LOG.assertTrue(classReference != null);
            PsiReferenceParameterList parameterList2 = classReference.getParameterList();
            LOG.assertTrue(parameterList2 != null);
            return parameterList2;
        }
        return null;
    }

    public static PsiElement replaceDiamondWithExplicitTypes(PsiElement element) {
        PsiElement parent2 = element.getParent();
        if (!(parent2 instanceof PsiJavaCodeReferenceElement)) {
            return parent2;
        }
        PsiJavaCodeReferenceElement javaCodeReferenceElement = (PsiJavaCodeReferenceElement)parent2;
        PsiReferenceParameterList parameterList2 = javaCodeReferenceElement.getParameterList();
        if (parameterList2 == null) {
            return javaCodeReferenceElement;
        }
        StringBuilder text2 = new StringBuilder();
        text2.append(javaCodeReferenceElement.getQualifiedName());
        text2.append('<');
        PsiNewExpression newExpression = PsiTreeUtil.getParentOfType(element, PsiNewExpression.class);
        PsiDiamondType.DiamondInferenceResult result2 = PsiDiamondTypeImpl.resolveInferredTypesNoCheck(newExpression, newExpression);
        text2.append(StringUtil.join(result2.getInferredTypes(), psiType2 -> psiType2.getCanonicalText(), ","));
        text2.append('>');
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(element.getProject());
        PsiJavaCodeReferenceElement newReference = elementFactory.createReferenceFromText(text2.toString(), element);
        PsiReferenceParameterList newReferenceParameterList = newReference.getParameterList();
        LOG.assertTrue(newReferenceParameterList != null);
        CodeStyleManager.getInstance(javaCodeReferenceElement.getProject()).reformat(parameterList2.replace(newReferenceParameterList));
        return javaCodeReferenceElement;
    }

    public static PsiExpression expandTopLevelDiamondsInside(PsiExpression expr) {
        PsiTypeElement[] typeParameterElements;
        PsiReferenceParameterList parameterList2;
        PsiJavaCodeReferenceElement classReference;
        if (expr instanceof PsiNewExpression && (classReference = ((PsiNewExpression)expr).getClassReference()) != null && (parameterList2 = classReference.getParameterList()) != null && (typeParameterElements = parameterList2.getTypeParameterElements()).length == 1 && typeParameterElements[0].getType() instanceof PsiDiamondType) {
            return (PsiExpression)PsiDiamondTypeUtil.replaceDiamondWithExplicitTypes(parameterList2).getParent();
        }
        return expr;
    }

    public static String getCollapsedType(PsiType type2, PsiElement context) {
        int idx;
        String typeText = type2.getCanonicalText();
        if (PsiUtil.isLanguageLevel7OrHigher(context) && (idx = typeText.indexOf(60)) >= 0) {
            return typeText.substring(0, idx) + "<>";
        }
        return typeText;
    }

    private static boolean isAugmented(PsiExpression expression2) {
        PsiElement gParent = PsiUtil.skipParenthesizedExprUp(expression2.getParent());
        PsiTypeElement typeElement = null;
        if (gParent instanceof PsiVariable) {
            typeElement = ((PsiVariable)gParent).getTypeElement();
        } else if (gParent instanceof PsiReturnStatement) {
            Object method = PsiTreeUtil.getParentOfType(gParent, PsiMethod.class, PsiLambdaExpression.class);
            typeElement = method instanceof PsiMethod ? ((PsiMethod)method).getReturnTypeElement() : null;
        }
        return typeElement != null && PsiAugmentProvider.getInferredType(typeElement) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean areTypeArgumentsRedundant(PsiType[] typeArguments2, PsiExpression context, boolean constructorRef, @Nullable PsiMethod method, PsiTypeParameter[] typeParameters2) {
        PsiElement encoded;
        block39: {
            boolean bl;
            block38: {
                boolean elementFactory2;
                block37: {
                    boolean call2222;
                    block36: {
                        boolean call2222;
                        block35: {
                            boolean call2222;
                            block34: {
                                boolean bl2;
                                block33: {
                                    boolean bl3;
                                    block32: {
                                        boolean bl4;
                                        block31: {
                                            encoded = null;
                                            try {
                                                PsiElement copy2;
                                                PsiType typeByParent = PsiTypesUtil.getExpectedTypeByParent(context);
                                                if (typeByParent != null && PsiTypesUtil.isDenotableType(typeByParent, context)) {
                                                    if (PsiDiamondTypeUtil.isAugmented(context)) {
                                                        bl4 = false;
                                                        if (encoded == null) return bl4;
                                                        break block31;
                                                    }
                                                    encoded = context;
                                                    RecaptureTypeMapper.encode(encoded);
                                                    copy2 = LambdaUtil.copyWithExpectedType(context, typeByParent);
                                                } else {
                                                    PsiExpressionList argumentList2 = context instanceof PsiCallExpression ? ((PsiCallExpression)context).getArgumentList() : null;
                                                    Object marker = new Object();
                                                    PsiTreeUtil.mark(argumentList2 != null ? argumentList2 : context, marker);
                                                    PsiCall call2222 = LambdaUtil.treeWalkUp(context);
                                                    if (call2222 != null) {
                                                        encoded = call2222;
                                                        RecaptureTypeMapper.encode(encoded);
                                                        PsiCall callCopy = LambdaUtil.copyTopLevelCall(call2222);
                                                        copy2 = callCopy != null ? PsiTreeUtil.releaseMark(callCopy, marker) : null;
                                                    } else {
                                                        PsiElement startMethodElementInCopy;
                                                        InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance(context.getProject());
                                                        if (injectedLanguageManager.getInjectionHost(context) != null) {
                                                            bl3 = false;
                                                            if (encoded == null) return bl3;
                                                            break block32;
                                                        }
                                                        PsiFile containingFile = context.getContainingFile();
                                                        PsiFile fileCopy = (PsiFile)containingFile.copy();
                                                        copy2 = PsiTreeUtil.releaseMark(fileCopy, marker);
                                                        if (method != null && method.getContainingFile() == containingFile && (method = PsiTreeUtil.getParentOfType(startMethodElementInCopy = fileCopy.findElementAt(method.getTextOffset()), PsiMethod.class)) == null) {
                                                            bl2 = false;
                                                            if (encoded == null) return bl2;
                                                            break block33;
                                                        }
                                                    }
                                                }
                                                PsiCallExpression exprCopy = PsiTreeUtil.getParentOfType(copy2, PsiCallExpression.class, false);
                                                if (context instanceof PsiMethodReferenceExpression) {
                                                    PsiMethodReferenceExpression methodRefCopy = PsiTreeUtil.getParentOfType(copy2, PsiMethodReferenceExpression.class, false);
                                                    if (methodRefCopy != null && !PsiDiamondTypeUtil.isInferenceEquivalent(typeArguments2, typeParameters2, method, methodRefCopy)) {
                                                        call2222 = false;
                                                        if (encoded == null) return call2222;
                                                        break block34;
                                                    }
                                                } else if (exprCopy != null) {
                                                    PsiElementFactory elementFactory2 = JavaPsiFacade.getElementFactory(exprCopy.getProject());
                                                    if (constructorRef) {
                                                        if (!(exprCopy instanceof PsiNewExpression) || !PsiDiamondTypeUtil.isInferenceEquivalent(typeArguments2, elementFactory2, (PsiNewExpression)exprCopy)) {
                                                            call2222 = false;
                                                            if (encoded == null) return call2222;
                                                            break block35;
                                                        }
                                                    } else {
                                                        LOG.assertTrue(method != null);
                                                        if (!PsiDiamondTypeUtil.isInferenceEquivalent(typeArguments2, elementFactory2, exprCopy, method, typeParameters2)) {
                                                            call2222 = false;
                                                            if (encoded == null) return call2222;
                                                            break block36;
                                                        }
                                                    }
                                                }
                                                if (typeByParent != null) {
                                                    elementFactory2 = true;
                                                    if (encoded == null) return elementFactory2;
                                                    break block37;
                                                }
                                                PsiCallExpression newParentCall = exprCopy != null ? PsiTreeUtil.getParentOfType((PsiElement)exprCopy, PsiCallExpression.class) : null;
                                                PsiCallExpression oldParentCall = PsiTreeUtil.getParentOfType((PsiElement)context, PsiCallExpression.class);
                                                if (newParentCall != null && oldParentCall != null) {
                                                    JavaResolveResult newResult = newParentCall.resolveMethodGenerics();
                                                    JavaResolveResult oldResult = oldParentCall.resolveMethodGenerics();
                                                    if (!Objects.equals(newResult.getElement(), oldResult.getElement()) || !new RecaptureTypeMapper().recapture(newResult.getSubstitutor()).equals(oldResult.getSubstitutor())) {
                                                        bl = false;
                                                        if (encoded == null) return bl;
                                                        break block38;
                                                    }
                                                }
                                                if (encoded == null) return true;
                                                break block39;
                                            }
                                            catch (IncorrectOperationException e) {
                                                LOG.info(e);
                                                boolean bl5 = false;
                                                return bl5;
                                            }
                                        }
                                        RecaptureTypeMapper.clean(encoded);
                                        return bl4;
                                    }
                                    RecaptureTypeMapper.clean(encoded);
                                    return bl3;
                                }
                                RecaptureTypeMapper.clean(encoded);
                                return bl2;
                            }
                            RecaptureTypeMapper.clean(encoded);
                            return call2222;
                        }
                        RecaptureTypeMapper.clean(encoded);
                        return call2222;
                    }
                    RecaptureTypeMapper.clean(encoded);
                    return call2222;
                }
                RecaptureTypeMapper.clean(encoded);
                return elementFactory2;
            }
            RecaptureTypeMapper.clean(encoded);
            return bl;
        }
        RecaptureTypeMapper.clean(encoded);
        return true;
        finally {
            if (encoded != null) {
                RecaptureTypeMapper.clean(encoded);
            }
        }
    }

    private static boolean isInferenceEquivalent(PsiType[] typeArguments2, PsiTypeParameter[] typeParameters2, PsiMethod method, PsiMethodReferenceExpression methodRefCopy) {
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(methodRefCopy.getProject());
        PsiTypeElement qualifierType = methodRefCopy.getQualifierType();
        if (qualifierType != null) {
            qualifierType.replace(elementFactory.createTypeElement(((PsiClassType)qualifierType.getType()).rawType()));
        } else {
            PsiReferenceParameterList parameterList2 = methodRefCopy.getParameterList();
            if (parameterList2 != null) {
                parameterList2.delete();
            }
        }
        JavaResolveResult result2 = methodRefCopy.advancedResolve(false);
        if (method != null && result2.getElement() != method) {
            return false;
        }
        PsiSubstitutor psiSubstitutor = result2.getSubstitutor();
        for (int i = 0; i < typeParameters2.length; ++i) {
            PsiTypeParameter typeParameter = typeParameters2[i];
            PsiType inferredType = psiSubstitutor.getSubstitutionMap().get(typeParameter);
            if (typeArguments2[i].equals(inferredType)) continue;
            return false;
        }
        return PsiDiamondTypeUtil.checkParentApplicability(methodRefCopy);
    }

    private static boolean isInferenceEquivalent(PsiType[] typeArguments2, PsiElementFactory elementFactory, PsiCallExpression exprCopy, PsiMethod method, PsiTypeParameter[] typeParameters2) throws IncorrectOperationException {
        PsiReferenceParameterList list2 = ((PsiCallExpression)elementFactory.createExpressionFromText("foo()", null)).getTypeArgumentList();
        exprCopy.getTypeArgumentList().replace(list2);
        JavaResolveResult copyResult = exprCopy.resolveMethodGenerics();
        if (method != copyResult.getElement()) {
            return false;
        }
        PsiSubstitutor psiSubstitutor = copyResult.getSubstitutor();
        int length = typeParameters2.length;
        for (int i = 0; i < length; ++i) {
            PsiTypeParameter typeParameter = typeParameters2[i];
            PsiType inferredType = psiSubstitutor.getSubstitutionMap().get(typeParameter);
            if (!typeArguments2[i].equals(inferredType)) {
                return false;
            }
            if (PsiUtil.resolveClassInType(method.getReturnType()) != typeParameter || PsiPrimitiveType.getUnboxedType(inferredType) == null) continue;
            return false;
        }
        return PsiDiamondTypeUtil.checkParentApplicability(exprCopy);
    }

    private static boolean isInferenceEquivalent(PsiType[] typeArguments2, PsiElementFactory elementFactory, PsiNewExpression exprCopy) throws IncorrectOperationException {
        PsiJavaCodeReferenceElement collapsedClassReference = ((PsiNewExpression)elementFactory.createExpressionFromText("new A<>()", null)).getClassOrAnonymousClassReference();
        LOG.assertTrue(collapsedClassReference != null);
        PsiReferenceParameterList diamondParameterList = collapsedClassReference.getParameterList();
        LOG.assertTrue(diamondParameterList != null);
        PsiJavaCodeReferenceElement classReference = exprCopy.getClassOrAnonymousClassReference();
        LOG.assertTrue(classReference != null);
        PsiReferenceParameterList parameterList2 = classReference.getParameterList();
        LOG.assertTrue(parameterList2 != null);
        parameterList2.replace(diamondParameterList);
        PsiType[] inferredArgs = classReference.getParameterList().getTypeArguments();
        if (typeArguments2.length != inferredArgs.length) {
            return false;
        }
        for (int i = 0; i < typeArguments2.length; ++i) {
            PsiWildcardType wildcardType;
            PsiType bound;
            PsiType typeArgument = typeArguments2[i];
            if (inferredArgs[i] instanceof PsiWildcardType && (bound = (wildcardType = (PsiWildcardType)inferredArgs[i]).getBound()) != null && (!wildcardType.isExtends() ? typeArgument.isAssignableFrom(bound) : bound.isAssignableFrom(typeArgument)) || typeArgument.equals(inferredArgs[i])) continue;
            return false;
        }
        return PsiDiamondTypeUtil.checkParentApplicability(exprCopy);
    }

    private static boolean checkParentApplicability(PsiExpression exprCopy) {
        while (exprCopy != null) {
            JavaResolveResult resolveResult;
            JavaResolveResult javaResolveResult = resolveResult = exprCopy instanceof PsiCallExpression ? PsiDiamondType.getDiamondsAwareResolveResult((PsiCall)((Object)exprCopy)) : null;
            if (resolveResult instanceof MethodCandidateInfo && !((MethodCandidateInfo)resolveResult).isApplicable()) {
                return false;
            }
            exprCopy = PsiTreeUtil.getParentOfType((PsiElement)exprCopy, PsiCallExpression.class, true);
        }
        return true;
    }
}

