/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.CompilationExceptionKt;
import org.jetbrains.kotlin.backend.common.LowerKt;
import org.jetbrains.kotlin.backend.common.ir.IrInlineUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.LoweredStatementOrigins;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.backend.js.JsStatementOrigins;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrElementBuilderKt;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrClassBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrDeclarationBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrPropertyBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrValueParameterBuilder;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOriginImpl;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrCompositeImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetFieldImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrInstanceInitializerCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrReturnImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrReturnTargetSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00112\u00020\u0001:\u0003\u0010\u0011\u0012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/CallableReferenceLowering;", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "nothingType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "stringType", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "CallableReferenceBuilder", "Companion", "ReferenceTransformer", "backend.js"})
public final class CallableReferenceLowering
implements BodyLoweringPass {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CommonBackendContext context;
    @NotNull
    private final IrType nothingType;
    @NotNull
    private final IrType stringType;
    @NotNull
    private static final Name BOUND_RECEIVER_NAME;

    public CallableReferenceLowering(@NotNull CommonBackendContext context) {
        Intrinsics.checkNotNullParameter(context, "context");
        this.context = context;
        this.nothingType = this.context.getIrBuiltIns().getNothingType();
        this.stringType = this.context.getIrBuiltIns().getStringType();
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter(irFile, "irFile");
        LowerKt.runOnFilePostfix(this, irFile, true);
    }

    @Override
    public void lower(@NotNull IrBody irBody, @NotNull IrDeclaration container) {
        Intrinsics.checkNotNullParameter(irBody, "irBody");
        Intrinsics.checkNotNullParameter(container, "container");
        IrDeclarationParent irDeclarationParent = container instanceof IrDeclarationParent ? (IrDeclarationParent)((Object)container) : null;
        if (irDeclarationParent == null) {
            irDeclarationParent = container.getParent();
        }
        IrDeclarationParent realContainer = irDeclarationParent;
        IrElementTransformerVoidKt.transformChildrenVoid(irBody, new ReferenceTransformer(realContainer));
    }

    static {
        Name name = Name.identifier("$boundThis");
        Intrinsics.checkNotNullExpressionValue(name, "identifier(\"\\$boundThis\")");
        BOUND_RECEIVER_NAME = name;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\t\u001a\u00020\nH\u0002J$\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\u000eH\u0016J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/CallableReferenceLowering$ReferenceTransformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "(Lorg/jetbrains/kotlin/ir/backend/js/lower/CallableReferenceLowering;Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;)V", "buildFunctionReference", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "buildLambdaReference", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionExpression;", "visitBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "body", "visitFunctionExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "visitFunctionReference", "backend.js"})
    private final class ReferenceTransformer
    extends IrElementTransformerVoid {
        @NotNull
        private final IrDeclarationParent container;

        public ReferenceTransformer(IrDeclarationParent container) {
            Intrinsics.checkNotNullParameter(container, "container");
            this.container = container;
        }

        @Override
        @NotNull
        public IrBody visitBody(@NotNull IrBody body2) {
            Intrinsics.checkNotNullParameter(body2, "body");
            return body2;
        }

        @Override
        @NotNull
        public IrExpression visitFunctionExpression(@NotNull IrFunctionExpression expression2) {
            IrElement[] irElementArray;
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
            IrSimpleFunction function2 = expression2.getFunction();
            Pair<IrClass, IrConstructor> pair = this.buildLambdaReference(function2, expression2);
            IrClass clazz = pair.component1();
            IrConstructor ctor = pair.component2();
            clazz.setParent(this.container);
            IrFunctionExpression irFunctionExpression = expression2;
            CallableReferenceLowering callableReferenceLowering2 = CallableReferenceLowering.this;
            IrFunctionExpression $this$visitFunctionExpression_u24lambda_u2d1 = irFunctionExpression;
            boolean bl = false;
            int vpCount = function2.isSuspend() ? 1 : 0;
            IrElement[] $this$visitFunctionExpression_u24lambda_u2d1_u24lambda_u2d0 = irElementArray = new IrConstructorCallImpl($this$visitFunctionExpression_u24lambda_u2d1.getStartOffset(), $this$visitFunctionExpression_u24lambda_u2d1.getEndOffset(), $this$visitFunctionExpression_u24lambda_u2d1.getType(), ctor.getSymbol(), 0, 0, vpCount, JsStatementOrigins.CALLABLE_REFERENCE_CREATE.INSTANCE, null, 256, null);
            boolean bl2 = false;
            if (function2.isSuspend()) {
                $this$visitFunctionExpression_u24lambda_u2d1_u24lambda_u2d0.putValueArgument(0, IrConstImpl.Companion.constNull($this$visitFunctionExpression_u24lambda_u2d1_u24lambda_u2d0.getStartOffset(), $this$visitFunctionExpression_u24lambda_u2d1_u24lambda_u2d0.getEndOffset(), callableReferenceLowering2.context.getIrBuiltIns().getNothingNType()));
            }
            IrElement[] ctorCall = irElementArray;
            irElementArray = new IrElement[]{clazz, (IrElement)ctorCall};
            return new IrCompositeImpl($this$visitFunctionExpression_u24lambda_u2d1.getStartOffset(), $this$visitFunctionExpression_u24lambda_u2d1.getEndOffset(), $this$visitFunctionExpression_u24lambda_u2d1.getType(), $this$visitFunctionExpression_u24lambda_u2d1.getOrigin(), CollectionsKt.listOf(irElementArray));
        }

        @Override
        @NotNull
        public IrExpression visitFunctionReference(@NotNull IrFunctionReference expression2) {
            IrElement[] irElementArray;
            IrExpression boundReceiver;
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
            Pair<IrClass, IrConstructor> pair = this.buildFunctionReference(expression2);
            IrClass clazz = pair.component1();
            IrConstructor ctor = pair.component2();
            clazz.setParent(this.container);
            IrFunctionReference $this$visitFunctionReference_u24lambda_u2d5 = expression2;
            boolean bl = false;
            IrFunctionReference $this$visitFunctionReference_u24lambda_u2d5_u24lambda_u2d2 = expression2;
            boolean bl2 = false;
            IrExpression irExpression = $this$visitFunctionReference_u24lambda_u2d5_u24lambda_u2d2.getDispatchReceiver();
            if (irExpression == null) {
                irExpression = $this$visitFunctionReference_u24lambda_u2d5_u24lambda_u2d2.getExtensionReceiver();
            }
            int vpCount = (boundReceiver = irExpression) != null ? 1 : 0;
            IrElement[] $this$visitFunctionReference_u24lambda_u2d5_u24lambda_u2d4 = irElementArray = new IrConstructorCallImpl($this$visitFunctionReference_u24lambda_u2d5.getStartOffset(), $this$visitFunctionReference_u24lambda_u2d5.getEndOffset(), $this$visitFunctionReference_u24lambda_u2d5.getType(), ctor.getSymbol(), 0, 0, vpCount, JsStatementOrigins.CALLABLE_REFERENCE_CREATE.INSTANCE, null, 256, null);
            boolean bl3 = false;
            IrExpression irExpression2 = boundReceiver;
            if (irExpression2 != null) {
                IrExpression it = irExpression2;
                boolean bl4 = false;
                $this$visitFunctionReference_u24lambda_u2d5_u24lambda_u2d4.putValueArgument(0, it);
            }
            IrElement[] ctorCall = irElementArray;
            irElementArray = new IrElement[]{clazz, (IrElement)ctorCall};
            return new IrCompositeImpl($this$visitFunctionReference_u24lambda_u2d5.getStartOffset(), $this$visitFunctionReference_u24lambda_u2d5.getEndOffset(), $this$visitFunctionReference_u24lambda_u2d5.getType(), $this$visitFunctionReference_u24lambda_u2d5.getOrigin(), CollectionsKt.listOf(irElementArray));
        }

        private final Pair<IrClass, IrConstructor> buildFunctionReference(IrFunctionReference expression2) {
            IrFunction target = ((IrFunctionSymbol)expression2.getSymbol()).getOwner();
            Object object = expression2.getReflectionTarget();
            if (object == null || (object = object.getOwner()) == null) {
                object = target;
            }
            Object reflectionTarget = object;
            return new CallableReferenceBuilder(target, expression2, (IrFunction)reflectionTarget).build();
        }

        private final Pair<IrClass, IrConstructor> buildLambdaReference(IrSimpleFunction function2, IrFunctionExpression expression2) {
            return new CallableReferenceBuilder(function2, expression2, null).build();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00180\u0017J\b\u0010\u0019\u001a\u00020\u0012H\u0002J\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u0012H\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001b\u001a\u00020\u0012H\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\u0012H\u0002J\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#J\b\u0010$\u001a\u00020%H\u0002J\f\u0010&\u001a\u00020'*\u00020\u001dH\u0002J\u0018\u0010(\u001a\u00020\u001f*\u00060)j\u0002`*2\u0006\u0010\"\u001a\u00020+H\u0002J\f\u0010,\u001a\u00020-*\u00020\u0018H\u0002J\f\u0010.\u001a\u00020\u001f*\u00020\u001dH\u0002J\f\u0010/\u001a\u00020\u001f*\u00020\u001dH\u0002J\f\u00100\u001a\u00020\u001f*\u00020\u0012H\u0002R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/CallableReferenceLowering$CallableReferenceBuilder;", "", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "reference", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "reflectionTarget", "(Lorg/jetbrains/kotlin/ir/backend/js/lower/CallableReferenceLowering;Lorg/jetbrains/kotlin/ir/declarations/IrFunction;Lorg/jetbrains/kotlin/ir/expressions/IrExpression;Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)V", "boundReceiverField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "isKReference", "", "isLambda", "()Z", "isSuspendLambda", "referenceType", "Lorg/jetbrains/kotlin/ir/types/IrSimpleType;", "secondFunctionInterface", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "superClass", "Lorg/jetbrains/kotlin/ir/types/IrType;", "superFunctionInterface", "build", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "buildReferenceClass", "createConstructor", "clazz", "createInvokeMethod", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "createNameProperty", "", "getValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetValue;", "d", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "makeContextDependentName", "Lorg/jetbrains/kotlin/name/Name;", "buildInvoke", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "collectNamesForLambda", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "countContextTypeParameters", "", "createFunctionReferenceInvokeMethod", "createLambdaInvokeMethod", "createReceiverField", "backend.js"})
    private final class CallableReferenceBuilder {
        @NotNull
        private final IrFunction function;
        @NotNull
        private final IrExpression reference;
        @Nullable
        private final IrFunction reflectionTarget;
        private final boolean isSuspendLambda;
        @NotNull
        private final IrType superClass;
        @Nullable
        private IrField boundReceiverField;
        @NotNull
        private final IrSimpleType referenceType;
        @NotNull
        private final IrClass superFunctionInterface;
        private final boolean isKReference;
        @Nullable
        private final IrClass secondFunctionInterface;

        public CallableReferenceBuilder(@NotNull IrFunction function2, @Nullable IrExpression reference, IrFunction reflectionTarget) {
            IrClass irClass2;
            Intrinsics.checkNotNullParameter(function2, "function");
            Intrinsics.checkNotNullParameter(reference, "reference");
            this.function = function2;
            this.reference = reference;
            this.reflectionTarget = reflectionTarget;
            this.isSuspendLambda = this.isLambda() && AdditionalIrUtilsKt.isSuspend(this.function);
            this.superClass = this.isSuspendLambda ? (IrType)IrUtilsKt.getDefaultType((IrClass)CallableReferenceLowering.this.context.getIr().getSymbols().getCoroutineImpl().getOwner()) : CallableReferenceLowering.this.context.getIrBuiltIns().getAnyType();
            IrType irType = this.reference.getType();
            Intrinsics.checkNotNull(irType, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
            this.referenceType = (IrSimpleType)irType;
            Object object = IrTypesKt.getClassOrNull(this.referenceType);
            if (object == null || (object = (IrClass)object.getOwner()) == null) {
                CompilationExceptionKt.compilationException("Expected functional type", this.reference);
                throw null;
            }
            this.superFunctionInterface = object;
            boolean bl = this.isKReference = this.superFunctionInterface.getName().getIdentifier().charAt(0) == 'K';
            if (this.isKReference) {
                int arity = this.referenceType.getArguments().size() - 1;
                irClass2 = AdditionalIrUtilsKt.isSuspend(this.function) ? (IrClass)CallableReferenceLowering.this.context.getIr().getSymbols().suspendFunctionN(arity).getOwner() : (IrClass)CallableReferenceLowering.this.context.getIr().getSymbols().functionN(arity).getOwner();
            } else {
                irClass2 = null;
            }
            this.secondFunctionInterface = irClass2;
        }

        private final boolean isLambda() {
            return this.reflectionTarget == null;
        }

        private final void collectNamesForLambda(StringBuilder $this$collectNamesForLambda, IrDeclarationWithName d) {
            IrDeclarationParent parent2 = d.getParent();
            if (parent2 instanceof IrPackageFragment) {
                $this$collectNamesForLambda.append(d.getName().asString());
                return;
            }
            Intrinsics.checkNotNull(parent2, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName");
            this.collectNamesForLambda($this$collectNamesForLambda, (IrDeclarationWithName)((Object)parent2));
            if (d instanceof IrAnonymousInitializer) {
                return;
            }
            if (CallableReferenceBuilder.collectNamesForLambda$isLambdaFun(d)) {
                $this$collectNamesForLambda.append('$');
                if (d instanceof IrSimpleFunction && ((IrSimpleFunction)d).isSuspend()) {
                    $this$collectNamesForLambda.append('s');
                }
                $this$collectNamesForLambda.append("lambda");
            } else if (Intrinsics.areEqual(d.getName(), SpecialNames.NO_NAME_PROVIDED)) {
                $this$collectNamesForLambda.append("$o");
            } else {
                $this$collectNamesForLambda.append('$');
                $this$collectNamesForLambda.append(d.getName().asString());
            }
        }

        private final Name makeContextDependentName() {
            StringBuilder sb = new StringBuilder();
            this.collectNamesForLambda(sb, this.function);
            if (!this.isLambda()) {
                sb.append("$ref");
            }
            Name name = Name.identifier(sb.toString());
            Intrinsics.checkNotNullExpressionValue(name, "identifier(sb.toString())");
            return name;
        }

        private final IrClass buildReferenceClass() {
            IrClass irClass2;
            IrFactory $this$buildClass$iv = CallableReferenceLowering.this.context.getIrFactory();
            boolean $i$f$buildClass = false;
            IrClassBuilder $this$buildClass_u24lambda_u2d1$iv = new IrClassBuilder();
            boolean bl = false;
            IrClassBuilder $this$buildReferenceClass_u24lambda_u2d0 = $this$buildClass_u24lambda_u2d1$iv;
            boolean bl2 = false;
            IrElementBuilderKt.setSourceRange($this$buildReferenceClass_u24lambda_u2d0, this.reference);
            DescriptorVisibility descriptorVisibility = DescriptorVisibilities.LOCAL;
            Intrinsics.checkNotNullExpressionValue(descriptorVisibility, "LOCAL");
            $this$buildReferenceClass_u24lambda_u2d0.setVisibility(descriptorVisibility);
            $this$buildReferenceClass_u24lambda_u2d0.setOrigin(this.isKReference || !this.isLambda() ? (IrDeclarationOrigin)Companion.FUNCTION_REFERENCE_IMPL.INSTANCE : (IrDeclarationOrigin)Companion.LAMBDA_IMPL.INSTANCE);
            $this$buildReferenceClass_u24lambda_u2d0.setName(this.makeContextDependentName());
            IrClass $this$buildReferenceClass_u24lambda_u2d1 = irClass2 = DeclarationBuildersKt.buildClass($this$buildClass$iv, $this$buildClass_u24lambda_u2d1$iv);
            boolean bl3 = false;
            Object object = this.secondFunctionInterface;
            IrType[] irTypeArray = new IrType[]{this.superClass, this.referenceType, object != null && (object = ((IrClass)object).getSymbol()) != null ? IrTypesKt.typeWithArguments((IrClassifierSymbol)object, this.referenceType.getArguments()) : null};
            $this$buildReferenceClass_u24lambda_u2d1.setSuperTypes(CollectionsKt.listOfNotNull(irTypeArray));
            org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.createImplicitParameterDeclarationWithWrappedDescriptor($this$buildReferenceClass_u24lambda_u2d1);
            this.createReceiverField($this$buildReferenceClass_u24lambda_u2d1);
            return irClass2;
        }

        private final void createReceiverField(IrClass $this$createReceiverField) {
            IrExpression boundReceiver;
            IrFunctionReference funRef;
            if (this.isLambda()) {
                return;
            }
            IrExpression irExpression = this.reference;
            Intrinsics.checkNotNull(irExpression, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrFunctionReference");
            IrFunctionReference $this$createReceiverField_u24lambda_u2d2 = funRef = (IrFunctionReference)irExpression;
            boolean bl = false;
            IrExpression irExpression2 = $this$createReceiverField_u24lambda_u2d2.getDispatchReceiver();
            if (irExpression2 == null) {
                irExpression2 = $this$createReceiverField_u24lambda_u2d2.getExtensionReceiver();
            }
            if ((boundReceiver = irExpression2) != null) {
                this.boundReceiverField = DeclarationBuildersKt.addField$default($this$createReceiverField, Companion.getBOUND_RECEIVER_NAME(), boundReceiver.getType(), null, 4, null);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final IrConstructor createConstructor(IrClass clazz) {
            void $this$createConstructor_u24lambda_u2d12_u24lambda_u2d11;
            IrDelegatingConstructorCall irDelegatingConstructorCall;
            void this_$iv$iv;
            void startOffset$iv;
            void $this$irBlockBody$iv;
            IrValueParameter irValueParameter;
            Object $this$createConstructor_u24lambda_u2d12_u24lambda_u2d6_u24lambda_u2d5;
            IrClass $this$addConstructor$iv = clazz;
            boolean $i$f$addConstructor = false;
            Object $this$buildConstructor$iv$iv = $this$addConstructor$iv.getFactory();
            boolean $i$f$buildConstructor = false;
            IrFunctionBuilder $this$buildConstructor_u24lambda_u2d20$iv$iv = new IrFunctionBuilder();
            boolean bl = false;
            IrFunctionBuilder $this$addConstructor_u24lambda_u2d21$iv = $this$buildConstructor_u24lambda_u2d20$iv$iv;
            boolean bl2 = false;
            IrFunctionBuilder $this$createConstructor_u24lambda_u2d3 = $this$addConstructor_u24lambda_u2d21$iv;
            boolean bl3 = false;
            $this$createConstructor_u24lambda_u2d3.setOrigin(Companion.GENERATED_MEMBER_IN_CALLABLE_REFERENCE.INSTANCE);
            $this$createConstructor_u24lambda_u2d3.setReturnType(IrUtilsKt.getDefaultType(clazz));
            $this$createConstructor_u24lambda_u2d3.setPrimary(true);
            $this$addConstructor_u24lambda_u2d21$iv.setReturnType(IrUtilsKt.getDefaultType($this$addConstructor$iv));
            Object constructor$iv = $this$buildConstructor$iv$iv = DeclarationBuildersKt.buildConstructor((IrFactory)$this$buildConstructor$iv$iv, $this$buildConstructor_u24lambda_u2d20$iv$iv);
            boolean bl4 = false;
            $this$addConstructor$iv.getDeclarations().add((IrDeclaration)constructor$iv);
            constructor$iv.setParent($this$addConstructor$iv);
            Object object = $this$buildConstructor$iv$iv;
            CallableReferenceLowering callableReferenceLowering2 = CallableReferenceLowering.this;
            Object $this$createConstructor_u24lambda_u2d12 = object;
            boolean bl5 = false;
            IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(this.superClass);
            Intrinsics.checkNotNull(irClassSymbol);
            Iterable $this$single$iv = ((IrClass)irClassSymbol.getOwner()).getDeclarations();
            boolean $i$f$single = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$single$iv) {
                IrDeclaration it = (IrDeclaration)element$iv;
                boolean bl6 = false;
                if (!(it instanceof IrConstructor && ((IrConstructor)it).isPrimary())) continue;
                if (found$iv) {
                    throw new IllegalArgumentException("Collection contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            Object v1 = single$iv;
            Intrinsics.checkNotNull(v1, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrConstructor");
            IrConstructor superConstructor = v1;
            IrField irField = this.boundReceiverField;
            if (irField != null) {
                IrValueParameter irValueParameter2;
                IrField it = irField;
                boolean bl7 = false;
                IrFunction $this$addValueParameter$iv = (IrFunction)$this$createConstructor_u24lambda_u2d12;
                boolean $i$f$addValueParameter = false;
                IrValueParameterBuilder $this$addValueParameter_u24lambda_u2d28$iv = new IrValueParameterBuilder();
                boolean bl8 = false;
                $this$createConstructor_u24lambda_u2d12_u24lambda_u2d6_u24lambda_u2d5 = $this$addValueParameter_u24lambda_u2d28$iv;
                boolean bl9 = false;
                ((IrDeclarationBuilder)$this$createConstructor_u24lambda_u2d12_u24lambda_u2d6_u24lambda_u2d5).setName(Companion.getBOUND_RECEIVER_NAME());
                ((IrValueParameterBuilder)$this$createConstructor_u24lambda_u2d12_u24lambda_u2d6_u24lambda_u2d5).setType(it.getType());
                ((IrValueParameterBuilder)$this$createConstructor_u24lambda_u2d12_u24lambda_u2d6_u24lambda_u2d5).setIndex(0);
                if ($this$addValueParameter_u24lambda_u2d28$iv.getIndex() == -1) {
                    $this$addValueParameter_u24lambda_u2d28$iv.setIndex($this$addValueParameter$iv.getValueParameters().size());
                }
                IrValueParameter valueParameter$iv = irValueParameter2 = DeclarationBuildersKt.buildValueParameter($this$addValueParameter$iv.getFactory(), $this$addValueParameter_u24lambda_u2d28$iv, $this$addValueParameter$iv);
                boolean bl10 = false;
                $this$addValueParameter$iv.setValueParameters(CollectionsKt.plus((Collection)$this$addValueParameter$iv.getValueParameters(), valueParameter$iv));
                irValueParameter = irValueParameter2;
            } else {
                irValueParameter = null;
            }
            IrValueParameter boundReceiverParameter = irValueParameter;
            Object continuation2 = null;
            if (this.isSuspendLambda) {
                IrValueParameter superContinuation = CollectionsKt.single(superConstructor.getValueParameters());
                IrFunction $this$addValueParameter$iv = (IrFunction)$this$createConstructor_u24lambda_u2d12;
                boolean $i$f$addValueParameter = false;
                IrValueParameterBuilder $this$addValueParameter_u24lambda_u2d28$iv = new IrValueParameterBuilder();
                boolean bl11 = false;
                IrValueParameterBuilder $this$createConstructor_u24lambda_u2d12_u24lambda_u2d7 = $this$addValueParameter_u24lambda_u2d28$iv;
                boolean bl12 = false;
                $this$createConstructor_u24lambda_u2d12_u24lambda_u2d7.setName(superContinuation.getName());
                $this$createConstructor_u24lambda_u2d12_u24lambda_u2d7.setType(superContinuation.getType());
                $this$createConstructor_u24lambda_u2d12_u24lambda_u2d7.setIndex(boundReceiverParameter == null ? 0 : 1);
                if ($this$addValueParameter_u24lambda_u2d28$iv.getIndex() == -1) {
                    $this$addValueParameter_u24lambda_u2d28$iv.setIndex($this$addValueParameter$iv.getValueParameters().size());
                }
                Object valueParameter$iv = $this$createConstructor_u24lambda_u2d12_u24lambda_u2d6_u24lambda_u2d5 = DeclarationBuildersKt.buildValueParameter($this$addValueParameter$iv.getFactory(), $this$addValueParameter_u24lambda_u2d28$iv, $this$addValueParameter$iv);
                boolean bl13 = false;
                $this$addValueParameter$iv.setValueParameters(CollectionsKt.plus((Collection)$this$addValueParameter$iv.getValueParameters(), valueParameter$iv));
                continuation2 = $this$createConstructor_u24lambda_u2d12_u24lambda_u2d6_u24lambda_u2d5;
            }
            IrBuilderWithScope superContinuation = LowerUtilsKt.createIrBuilder$default(callableReferenceLowering2.context, (IrSymbol)((IrConstructor)$this$createConstructor_u24lambda_u2d12).getSymbol(), 0, 0, 6, null);
            int $this$addValueParameter$iv = $this$createConstructor_u24lambda_u2d12.getStartOffset();
            int endOffset$iv = $this$createConstructor_u24lambda_u2d12.getEndOffset();
            boolean $i$f$irBlockBody = false;
            IrBlockBodyBuilder bl11 = new IrBlockBodyBuilder($this$irBlockBody$iv.getContext(), $this$irBlockBody$iv.getScope(), (int)startOffset$iv, endOffset$iv);
            boolean $i$f$blockBody = false;
            void bl12 = this_$iv$iv;
            Object object2 = $this$createConstructor_u24lambda_u2d12;
            boolean bl14 = false;
            IrDelegatingConstructorCall bl13 = irDelegatingConstructorCall = ExpressionHelpersKt.irDelegatingConstructorCall((IrBuilderWithScope)$this$createConstructor_u24lambda_u2d12_u24lambda_u2d11, superConstructor);
            void var18_35 = $this$createConstructor_u24lambda_u2d12_u24lambda_u2d11;
            boolean bl15 = false;
            Object object3 = continuation2;
            if (object3 != null) {
                void $this$createConstructor_u24lambda_u2d12_u24lambda_u2d11_u24lambda_u2d9;
                Object it = object3;
                boolean bl16 = false;
                $this$createConstructor_u24lambda_u2d12_u24lambda_u2d11_u24lambda_u2d9.putValueArgument(0, this.getValue((IrValueDeclaration)it));
            }
            var18_35.unaryPlus(irDelegatingConstructorCall);
            IrValueParameter irValueParameter3 = boundReceiverParameter;
            if (irValueParameter3 != null) {
                IrValueParameter it = irValueParameter3;
                boolean bl17 = false;
                IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$createConstructor_u24lambda_u2d12_u24lambda_u2d11;
                IrBuilderWithScope irBuilderWithScope2 = (IrBuilderWithScope)$this$createConstructor_u24lambda_u2d12_u24lambda_u2d11;
                IrValueParameter irValueParameter4 = clazz.getThisReceiver();
                Intrinsics.checkNotNull(irValueParameter4);
                IrExpression irExpression = ExpressionHelpersKt.irGet(irBuilderWithScope2, irValueParameter4);
                IrField irField2 = this.boundReceiverField;
                Intrinsics.checkNotNull(irField2);
                $this$createConstructor_u24lambda_u2d12_u24lambda_u2d11.unaryPlus(ExpressionHelpersKt.irSetField(irBuilderWithScope, irExpression, irField2, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$createConstructor_u24lambda_u2d12_u24lambda_u2d11, it), LoweredStatementOrigins.STATEMENT_ORIGIN_INITIALIZER_OF_FIELD_FOR_CAPTURED_VALUE.INSTANCE));
            }
            $this$createConstructor_u24lambda_u2d12_u24lambda_u2d11.unaryPlus(new IrInstanceInitializerCallImpl($this$createConstructor_u24lambda_u2d12_u24lambda_u2d11.getStartOffset(), $this$createConstructor_u24lambda_u2d12_u24lambda_u2d11.getEndOffset(), clazz.getSymbol(), $this$createConstructor_u24lambda_u2d12_u24lambda_u2d11.getContext().getIrBuiltIns().getUnitType()));
            ((IrFunction)object2).setBody(this_$iv$iv.doBuild());
            return object;
        }

        /*
         * WARNING - void declaration
         */
        private final IrSimpleFunction createInvokeMethod(IrClass clazz) {
            IrSimpleFunction irSimpleFunction;
            List secondSuperMethods;
            List list2;
            Object object;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = this.superFunctionInterface.getDeclarations();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof IrSimpleFunction)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List superMethods = (List)destination$iv$iv;
            Iterable $this$single$iv = superMethods;
            boolean $i$f$single = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$single$iv) {
                IrSimpleFunction it = (IrSimpleFunction)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getName().asString(), "invoke")) continue;
                if (found$iv) {
                    throw new IllegalArgumentException("Collection contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            IrSimpleFunction superMethod = single$iv;
            IrClass $this$addFunction$iv = clazz;
            boolean $i$f$addFunction = false;
            IrFactory $this$addFunction$iv$iv = $this$addFunction$iv.getFactory();
            boolean $i$f$addFunction2 = false;
            Object $this$buildFun$iv$iv$iv = $this$addFunction$iv$iv;
            boolean $i$f$buildFun = false;
            IrFunctionBuilder $this$buildFun_u24lambda_u2d16$iv$iv$iv = new IrFunctionBuilder();
            boolean bl = false;
            IrFunctionBuilder $this$createInvokeMethod_u24lambda_u2d14 = $this$buildFun_u24lambda_u2d16$iv$iv$iv;
            boolean bl2 = false;
            IrElementBuilderKt.setSourceRange($this$createInvokeMethod_u24lambda_u2d14, this.isLambda() ? (IrElement)this.function : (IrElement)this.reference);
            $this$createInvokeMethod_u24lambda_u2d14.setName(superMethod.getName());
            $this$createInvokeMethod_u24lambda_u2d14.setReturnType(this.function.getReturnType());
            $this$createInvokeMethod_u24lambda_u2d14.setSuspend(superMethod.isSuspend());
            $this$createInvokeMethod_u24lambda_u2d14.setOperator(superMethod.isOperator());
            Object function$iv$iv = $this$buildFun$iv$iv$iv = DeclarationBuildersKt.buildFunction((IrFactory)$this$buildFun$iv$iv$iv, $this$buildFun_u24lambda_u2d16$iv$iv$iv);
            boolean bl3 = false;
            ((IrDeclarationContainer)$this$addFunction$iv).getDeclarations().add((IrDeclaration)function$iv$iv);
            function$iv$iv.setParent($this$addFunction$iv);
            Object $this$createInvokeMethod_u24lambda_u2d16 = object = $this$buildFun$iv$iv$iv;
            boolean bl4 = false;
            Object object2 = this.secondFunctionInterface;
            if (object2 != null && (object2 = object2.getDeclarations()) != null) {
                void $this$filterIsInstanceTo$iv$iv2;
                Iterable $this$filterIsInstance$iv2 = (Iterable)object2;
                boolean $i$f$filterIsInstance2 = false;
                function$iv$iv = $this$filterIsInstance$iv2;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterIsInstanceTo2 = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
                    if (!(element$iv$iv instanceof IrSimpleFunction)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                list2 = (List)destination$iv$iv2;
            } else {
                list2 = null;
            }
            List list3 = secondSuperMethods = list2;
            if (list3 != null) {
                Iterable $this$single$iv2 = list3;
                boolean $i$f$single2 = false;
                Object single$iv2 = null;
                boolean found$iv2 = false;
                for (Object element$iv : $this$single$iv2) {
                    IrSimpleFunction it = (IrSimpleFunction)element$iv;
                    boolean bl5 = false;
                    if (!Intrinsics.areEqual(it.getName().asString(), "invoke")) continue;
                    if (found$iv2) {
                        throw new IllegalArgumentException("Collection contains more than one matching element.");
                    }
                    single$iv2 = element$iv;
                    found$iv2 = true;
                }
                if (!found$iv2) {
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                irSimpleFunction = single$iv2;
            } else {
                irSimpleFunction = null;
            }
            IrSimpleFunction secondSuperMethod = irSimpleFunction;
            IrSimpleFunctionSymbol[] irSimpleFunctionSymbolArray = new IrSimpleFunctionSymbol[2];
            irSimpleFunctionSymbolArray[0] = superMethod.getSymbol();
            IrSimpleFunction irSimpleFunction2 = secondSuperMethod;
            irSimpleFunctionSymbolArray[1] = irSimpleFunction2 != null ? irSimpleFunction2.getSymbol() : null;
            $this$createInvokeMethod_u24lambda_u2d16.setOverriddenSymbols(CollectionsKt.listOfNotNull(irSimpleFunctionSymbolArray));
            ((IrFunction)$this$createInvokeMethod_u24lambda_u2d16).setDispatchReceiverParameter(DeclarationBuildersKt.buildReceiverParameter((IrDeclaration)$this$createInvokeMethod_u24lambda_u2d16, clazz.getOrigin(), IrUtilsKt.getDefaultType(clazz), $this$createInvokeMethod_u24lambda_u2d16.getStartOffset(), $this$createInvokeMethod_u24lambda_u2d16.getEndOffset()));
            if (this.isLambda()) {
                this.createLambdaInvokeMethod((IrSimpleFunction)$this$createInvokeMethod_u24lambda_u2d16);
            } else {
                this.createFunctionReferenceInvokeMethod((IrSimpleFunction)$this$createInvokeMethod_u24lambda_u2d16);
            }
            return object;
        }

        /*
         * WARNING - void declaration
         */
        private final void createLambdaInvokeMethod(IrSimpleFunction $this$createLambdaInvokeMethod) {
            void $this$associateTo$iv$iv;
            $this$createLambdaInvokeMethod.setAnnotations(this.function.getAnnotations());
            Iterable $this$associate$iv = CollectionsKt.withIndex((Iterable)IrUtilsKt.getExplicitParameters(this.function));
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv;
                Object object = (IndexedValue)element$iv$iv;
                boolean bl = false;
                int index2 = ((IndexedValue)object).component1();
                IrValueParameter param = (IrValueParameter)((IndexedValue)object).component2();
                object = TuplesKt.to(param, org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTo$default(param, $this$createLambdaInvokeMethod, null, index2, 0, 0, null, null, null, null, null, false, false, false, 8186, null));
                map.put(((Pair)object).getFirst(), ((Pair)object).getSecond());
            }
            Map valueParameterMap = destination$iv$iv;
            $this$createLambdaInvokeMethod.setValueParameters(CollectionsKt.toList(valueParameterMap.values()));
            $this$createLambdaInvokeMethod.setBody(IrInlineUtilsKt.moveBodyTo(this.function, $this$createLambdaInvokeMethod, valueParameterMap));
        }

        @NotNull
        public final IrGetValue getValue(@NotNull IrValueDeclaration d) {
            Intrinsics.checkNotNullParameter(d, "d");
            return new IrGetValueImpl(-1, -1, d.getType(), d.getSymbol(), JsStatementOrigins.CALLABLE_REFERENCE_INVOKE.INSTANCE);
        }

        private final int countContextTypeParameters(IrConstructor $this$countContextTypeParameters) {
            return CallableReferenceBuilder.countContextTypeParameters$countImpl($this$countContextTypeParameters.getParent());
        }

        private final IrFunctionAccessExpression buildInvoke(IrSimpleFunction $this$buildInvoke) {
            IrFunctionReference funRef;
            IrFunctionAccessExpression irFunctionAccessExpression;
            IrFunction callee = this.function;
            IrExpression $this$buildInvoke_u24lambda_u2d20 = this.reference;
            boolean bl = false;
            IrFunction irFunction2 = callee;
            if (irFunction2 instanceof IrConstructor) {
                irFunctionAccessExpression = new IrConstructorCallImpl($this$buildInvoke_u24lambda_u2d20.getStartOffset(), $this$buildInvoke_u24lambda_u2d20.getEndOffset(), IrUtilsKt.getDefaultType(IrUtilsKt.getParentAsClass(callee)), ((IrConstructor)callee).getSymbol(), this.countContextTypeParameters((IrConstructor)callee), callee.getTypeParameters().size(), callee.getValueParameters().size(), JsStatementOrigins.CALLABLE_REFERENCE_INVOKE.INSTANCE, null, 256, null);
            } else if (irFunction2 instanceof IrSimpleFunction) {
                irFunctionAccessExpression = new IrCallImpl($this$buildInvoke_u24lambda_u2d20.getStartOffset(), $this$buildInvoke_u24lambda_u2d20.getEndOffset(), callee.getReturnType(), ((IrSimpleFunction)callee).getSymbol(), callee.getTypeParameters().size(), callee.getValueParameters().size(), JsStatementOrigins.CALLABLE_REFERENCE_INVOKE.INSTANCE, null, 128, null);
            } else {
                CompilationExceptionKt.compilationException("unknown function kind", callee);
                throw null;
            }
            IrFunctionAccessExpression irCall = irFunctionAccessExpression;
            IrExpression irExpression = this.reference;
            Intrinsics.checkNotNull(irExpression, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrFunctionReference");
            IrFunctionReference $this$buildInvoke_u24lambda_u2d21 = funRef = (IrFunctionReference)irExpression;
            boolean bl2 = false;
            IrExpression irExpression2 = $this$buildInvoke_u24lambda_u2d21.getDispatchReceiver();
            if (irExpression2 == null) {
                irExpression2 = $this$buildInvoke_u24lambda_u2d21.getExtensionReceiver();
            }
            boolean boundReceiver = irExpression2 != null;
            IrFunction $this$buildInvoke_u24lambda_u2d22 = callee;
            boolean bl3 = false;
            IrValueParameter irValueParameter = $this$buildInvoke_u24lambda_u2d22.getDispatchReceiverParameter();
            if (irValueParameter == null) {
                irValueParameter = $this$buildInvoke_u24lambda_u2d22.getExtensionReceiverParameter();
            }
            boolean hasReceiver = irValueParameter != null;
            irCall.setDispatchReceiver(funRef.getDispatchReceiver());
            irCall.setExtensionReceiver(funRef.getExtensionReceiver());
            int i = 0;
            List<IrValueParameter> valueParameters2 = $this$buildInvoke.getValueParameters();
            int n = funRef.getTypeArgumentsCount();
            for (int ti = 0; ti < n; ++ti) {
                irCall.putTypeArgument(ti, funRef.getTypeArgument(ti));
            }
            if (hasReceiver) {
                if (!boundReceiver) {
                    if (callee.getDispatchReceiverParameter() != null) {
                        irCall.setDispatchReceiver(this.getValue(valueParameters2.get(i++)));
                    }
                    if (callee.getExtensionReceiverParameter() != null) {
                        irCall.setExtensionReceiver(this.getValue(valueParameters2.get(i++)));
                    }
                } else {
                    IrField boundReceiverField = this.boundReceiverField;
                    if (boundReceiverField != null) {
                        IrValueParameter irValueParameter2 = $this$buildInvoke.getDispatchReceiverParameter();
                        Intrinsics.checkNotNull(irValueParameter2);
                        IrGetValue thisValue = this.getValue(irValueParameter2);
                        IrGetFieldImpl value2 = new IrGetFieldImpl(-1, -1, boundReceiverField.getSymbol(), boundReceiverField.getType(), thisValue, JsStatementOrigins.CALLABLE_REFERENCE_INVOKE.INSTANCE, null, 64, null);
                        if (funRef.getDispatchReceiver() != null) {
                            irCall.setDispatchReceiver(value2);
                        }
                        if (funRef.getExtensionReceiver() != null) {
                            irCall.setExtensionReceiver(value2);
                        }
                    }
                    if (callee.getDispatchReceiverParameter() != null && funRef.getDispatchReceiver() == null) {
                        irCall.setDispatchReceiver(this.getValue(valueParameters2.get(i++)));
                    }
                    if (callee.getExtensionReceiverParameter() != null && funRef.getExtensionReceiver() == null) {
                        irCall.setExtensionReceiver(this.getValue(valueParameters2.get(i++)));
                    }
                }
            }
            int j = 0;
            while (i < valueParameters2.size()) {
                irCall.putValueArgument(j++, this.getValue(valueParameters2.get(i++)));
            }
            return irCall;
        }

        /*
         * WARNING - void declaration
         */
        private final void createFunctionReferenceInvokeMethod(IrSimpleFunction $this$createFunctionReferenceInvokeMethod) {
            void $this$createFunctionReferenceInvokeMethod_u24lambda_u2d26;
            Object object;
            IrExpression $this$mapIndexedTo$iv$iv;
            void $this$mapIndexed$iv;
            Object object2;
            Object object3;
            void $this$mapTo$iv$iv;
            IrType irType = this.reference.getType();
            Intrinsics.checkNotNull(irType, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
            Iterable $this$map$iv = ((IrSimpleType)irType).getArguments();
            boolean $i$f$map22 = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                object3 = (IrTypeArgument)item$iv$iv;
                object2 = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull(it, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrTypeProjection");
                object2.add(((IrTypeProjection)it).getType());
            }
            List parameterTypes = (List)destination$iv$iv;
            List argumentTypes2 = CollectionsKt.dropLast(parameterTypes, 1);
            Iterable $i$f$map22 = argumentTypes2;
            object2 = $this$createFunctionReferenceInvokeMethod;
            boolean $i$f$mapIndexed = false;
            destination$iv$iv = $this$mapIndexed$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            object3 = $this$mapIndexedTo$iv$iv.iterator();
            while (object3.hasNext()) {
                void t;
                void i;
                int n;
                Object item$iv$iv = object3.next();
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                IrType irType2 = (IrType)item$iv$iv;
                int n2 = n;
                object = destination$iv$iv2;
                boolean bl = false;
                boolean $i$f$buildValueParameter = false;
                IrValueParameterBuilder $this$buildValueParameter_u24lambda_u2d26$iv = new IrValueParameterBuilder();
                boolean bl2 = false;
                IrValueParameterBuilder $this$createFunctionReferenceInvokeMethod_u24lambda_u2d25_u24lambda_u2d24 = $this$buildValueParameter_u24lambda_u2d26$iv;
                boolean bl3 = false;
                Name name = Name.identifier("" + 'p' + (int)i);
                Intrinsics.checkNotNullExpressionValue(name, "identifier(\"p$i\")");
                $this$createFunctionReferenceInvokeMethod_u24lambda_u2d25_u24lambda_u2d24.setName(name);
                $this$createFunctionReferenceInvokeMethod_u24lambda_u2d25_u24lambda_u2d24.setType((IrType)t);
                $this$createFunctionReferenceInvokeMethod_u24lambda_u2d25_u24lambda_u2d24.setIndex((int)i);
                object.add(DeclarationBuildersKt.buildValueParameter(((IrDeclaration)$this$createFunctionReferenceInvokeMethod).getFactory(), $this$buildValueParameter_u24lambda_u2d26$iv, (IrDeclarationParent)((Object)((IrDeclaration)$this$createFunctionReferenceInvokeMethod))));
            }
            ((IrFunction)object2).setValueParameters((List)destination$iv$iv2);
            IrExpression irExpression = this.reference;
            CallableReferenceLowering callableReferenceLowering2 = CallableReferenceLowering.this;
            $this$mapIndexedTo$iv$iv = irExpression;
            int n = this.reference.getEndOffset();
            int n3 = this.reference.getStartOffset();
            object = $this$createFunctionReferenceInvokeMethod.getFactory();
            object2 = $this$createFunctionReferenceInvokeMethod;
            boolean bl = false;
            IrReturnImpl irReturnImpl = new IrReturnImpl($this$createFunctionReferenceInvokeMethod_u24lambda_u2d26.getStartOffset(), $this$createFunctionReferenceInvokeMethod_u24lambda_u2d26.getEndOffset(), callableReferenceLowering2.nothingType, $this$createFunctionReferenceInvokeMethod.getSymbol(), this.buildInvoke($this$createFunctionReferenceInvokeMethod));
            ((IrFunction)object2).setBody(object.createBlockBody(n3, n, CollectionsKt.listOf(irReturnImpl)));
        }

        /*
         * WARNING - void declaration
         */
        private final void createNameProperty(IrClass clazz) {
            void $this$createNameProperty_u24lambda_u2d30;
            IrSimpleFunction irSimpleFunction;
            void $this$addGetter$iv;
            Object nameProperty;
            void $this$filterIsInstanceTo$iv$iv;
            if (!this.isKReference) {
                return;
            }
            Iterable $this$filterIsInstance$iv = this.superFunctionInterface.getDeclarations();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof IrProperty)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$single$iv = (List)destination$iv$iv;
            boolean $i$f$single = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$single$iv) {
                IrProperty it = (IrProperty)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getName(), Name.identifier("name"))) continue;
                if (found$iv) {
                    throw new IllegalArgumentException("Collection contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            IrProperty superProperty = single$iv;
            IrSimpleFunction irSimpleFunction2 = superProperty.getGetter();
            if (irSimpleFunction2 == null) {
                CompilationExceptionKt.compilationException("Expected getter for KFunction.name property", superProperty);
                throw null;
            }
            IrSimpleFunction supperGetter = irSimpleFunction2;
            IrClass $this$addProperty$iv = clazz;
            boolean $i$f$addProperty22 = false;
            Object $this$buildProperty$iv$iv = $this$addProperty$iv.getFactory();
            boolean $i$f$buildProperty = false;
            IrPropertyBuilder $this$buildProperty_u24lambda_u2d8$iv$iv = new IrPropertyBuilder();
            boolean bl = false;
            IrPropertyBuilder $this$createNameProperty_u24lambda_u2d28 = $this$buildProperty_u24lambda_u2d8$iv$iv;
            boolean bl2 = false;
            $this$createNameProperty_u24lambda_u2d28.setVisibility(superProperty.getVisibility());
            $this$createNameProperty_u24lambda_u2d28.setName(superProperty.getName());
            $this$createNameProperty_u24lambda_u2d28.setOrigin(Companion.GENERATED_MEMBER_IN_CALLABLE_REFERENCE.INSTANCE);
            Object property$iv = $this$buildProperty$iv$iv = DeclarationBuildersKt.buildProperty((IrFactory)$this$buildProperty$iv$iv, $this$buildProperty_u24lambda_u2d8$iv$iv);
            boolean bl3 = false;
            $this$addProperty$iv.getDeclarations().add((IrDeclaration)property$iv);
            property$iv.setParent($this$addProperty$iv);
            Object $i$f$addProperty22 = nameProperty = $this$buildProperty$iv$iv;
            $this$buildProperty$iv$iv = CallableReferenceLowering.this;
            boolean $i$f$addGetter = false;
            IrDeclarationBuilder $this$addGetter_u24lambda_u2d11$iv = new IrFunctionBuilder();
            boolean bl4 = false;
            Name name = Name.special("<get-" + $this$addGetter$iv.getName() + '>');
            Intrinsics.checkNotNullExpressionValue(name, "special(\"<get-${this@addGetter.name}>\")");
            $this$addGetter_u24lambda_u2d11$iv.setName(name);
            IrFunctionBuilder $this$createNameProperty_u24lambda_u2d29 = $this$addGetter_u24lambda_u2d11$iv;
            boolean bl5 = false;
            $this$createNameProperty_u24lambda_u2d29.setReturnType(((CallableReferenceLowering)$this$buildProperty$iv$iv).stringType);
            IrSimpleFunction getter$iv = irSimpleFunction = DeclarationBuildersKt.buildFunction($this$addGetter$iv.getFactory(), $this$addGetter_u24lambda_u2d11$iv);
            boolean bl6 = false;
            $this$addGetter$iv.setGetter(getter$iv);
            getter$iv.setCorrespondingPropertySymbol($this$addGetter$iv.getSymbol());
            getter$iv.setParent($this$addGetter$iv.getParent());
            IrSimpleFunction getter2 = irSimpleFunction;
            getter2.setOverriddenSymbols(CollectionsKt.plus((Collection)getter2.getOverriddenSymbols(), supperGetter.getSymbol()));
            boolean $i$f$buildValueParameter = false;
            IrValueParameterBuilder $this$buildValueParameter_u24lambda_u2d26$iv = new IrValueParameterBuilder();
            boolean bl7 = false;
            $this$addGetter_u24lambda_u2d11$iv = $this$buildValueParameter_u24lambda_u2d26$iv;
            IrSimpleFunction irSimpleFunction3 = getter2;
            boolean bl8 = false;
            $this$createNameProperty_u24lambda_u2d30.setName(SpecialNames.THIS);
            $this$createNameProperty_u24lambda_u2d30.setType(IrUtilsKt.getDefaultType(clazz));
            irSimpleFunction3.setDispatchReceiverParameter(DeclarationBuildersKt.buildValueParameter(((IrDeclaration)getter2).getFactory(), $this$buildValueParameter_u24lambda_u2d26$iv, (IrDeclarationParent)((Object)((IrDeclaration)getter2))));
            IrFactory irFactory = CallableReferenceLowering.this.context.getIrFactory();
            IrType irType = CallableReferenceLowering.this.nothingType;
            IrReturnTargetSymbol irReturnTargetSymbol = getter2.getSymbol();
            IrType irType2 = CallableReferenceLowering.this.stringType;
            IrFunction irFunction2 = this.reflectionTarget;
            Intrinsics.checkNotNull(irFunction2);
            String string2 = irFunction2.getName().asString();
            Intrinsics.checkNotNullExpressionValue(string2, "reflectionTarget!!.name.asString()");
            getter2.setBody(irFactory.createBlockBody(-1, -1, CollectionsKt.listOf(new IrReturnImpl(-1, -1, irType, irReturnTargetSymbol, IrConstImpl.Companion.string(-1, -1, irType2, string2)))));
            CallableReferenceLowering.this.context.getMapping().getReflectedNameAccessor().set((IrClass)((IrDeclaration)clazz), getter2);
        }

        @NotNull
        public final Pair<IrClass, IrConstructor> build() {
            IrClass clazz = this.buildReferenceClass();
            IrConstructor ctor = this.createConstructor(clazz);
            this.createInvokeMethod(clazz);
            this.createNameProperty(clazz);
            return new Pair<IrClass, IrConstructor>(clazz, ctor);
        }

        private static final boolean collectNamesForLambda$isLambdaFun(IrDeclaration $this$collectNamesForLambda_u24isLambdaFun) {
            return Intrinsics.areEqual($this$collectNamesForLambda_u24isLambdaFun.getOrigin(), IrDeclarationOrigin.LOCAL_FUNCTION_FOR_LAMBDA.INSTANCE);
        }

        /*
         * WARNING - void declaration
         */
        private static final int countContextTypeParameters$countImpl(IrDeclarationParent container) {
            int n;
            IrDeclarationParent irDeclarationParent = container;
            if (irDeclarationParent instanceof IrClass) {
                void $this$countContextTypeParameters_u24countImpl_u24lambda_u2d18;
                IrClass irClass2 = (IrClass)container;
                int n2 = ((IrClass)container).getTypeParameters().size();
                boolean bl = false;
                int n3 = $this$countContextTypeParameters_u24countImpl_u24lambda_u2d18.isInner() ? CallableReferenceBuilder.countContextTypeParameters$countImpl(((IrClass)container).getParent()) : 0;
                n = n2 + n3;
            } else if (irDeclarationParent instanceof IrFunction) {
                n = ((IrFunction)container).getTypeParameters().size() + CallableReferenceBuilder.countContextTypeParameters$countImpl(((IrFunction)container).getParent());
            } else if (irDeclarationParent instanceof IrProperty) {
                IrElement $this$countContextTypeParameters_u24countImpl_u24lambda_u2d19 = container;
                boolean bl = false;
                IrSimpleFunction irSimpleFunction = ((IrProperty)$this$countContextTypeParameters_u24countImpl_u24lambda_u2d19).getGetter();
                if (irSimpleFunction == null) {
                    irSimpleFunction = ((IrProperty)$this$countContextTypeParameters_u24countImpl_u24lambda_u2d19).getSetter();
                }
                Object object = irSimpleFunction;
                n = (irSimpleFunction != null && (object = object.getTypeParameters()) != null ? object.size() : 0) + CallableReferenceBuilder.countContextTypeParameters$countImpl(((IrProperty)((Object)container)).getParent());
            } else {
                n = irDeclarationParent instanceof IrDeclaration ? CallableReferenceBuilder.countContextTypeParameters$countImpl(((IrDeclaration)((Object)container)).getParent()) : 0;
            }
            return n;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0003\u0007\b\tB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/CallableReferenceLowering$Companion;", "", "()V", "BOUND_RECEIVER_NAME", "Lorg/jetbrains/kotlin/name/Name;", "getBOUND_RECEIVER_NAME", "()Lorg/jetbrains/kotlin/name/Name;", "FUNCTION_REFERENCE_IMPL", "GENERATED_MEMBER_IN_CALLABLE_REFERENCE", "LAMBDA_IMPL", "backend.js"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Name getBOUND_RECEIVER_NAME() {
            return BOUND_RECEIVER_NAME;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/CallableReferenceLowering$Companion$LAMBDA_IMPL;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOriginImpl;", "()V", "backend.js"})
        public static final class LAMBDA_IMPL
        extends IrDeclarationOriginImpl {
            @NotNull
            public static final LAMBDA_IMPL INSTANCE = new LAMBDA_IMPL();

            private LAMBDA_IMPL() {
                super("LAMBDA_IMPL", false, 2, null);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/CallableReferenceLowering$Companion$FUNCTION_REFERENCE_IMPL;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOriginImpl;", "()V", "backend.js"})
        public static final class FUNCTION_REFERENCE_IMPL
        extends IrDeclarationOriginImpl {
            @NotNull
            public static final FUNCTION_REFERENCE_IMPL INSTANCE = new FUNCTION_REFERENCE_IMPL();

            private FUNCTION_REFERENCE_IMPL() {
                super("FUNCTION_REFERENCE_IMPL", false, 2, null);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/CallableReferenceLowering$Companion$GENERATED_MEMBER_IN_CALLABLE_REFERENCE;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOriginImpl;", "()V", "backend.js"})
        public static final class GENERATED_MEMBER_IN_CALLABLE_REFERENCE
        extends IrDeclarationOriginImpl {
            @NotNull
            public static final GENERATED_MEMBER_IN_CALLABLE_REFERENCE INSTANCE = new GENERATED_MEMBER_IN_CALLABLE_REFERENCE();

            private GENERATED_MEMBER_IN_CALLABLE_REFERENCE() {
                super("GENERATED_MEMBER_IN_CALLABLE_REFERENCE", false, 2, null);
            }
        }
    }
}

