/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.highlighting;

import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.project.Project;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolderImpl;
import com.intellij.util.xml.highlighting.DomElementAnnotationsManagerImpl;
import com.intellij.util.xml.highlighting.DomElementProblemDescriptor;
import com.intellij.util.xml.highlighting.DomElementsInspection;
import com.intellij.util.xml.highlighting.DomElementsProblemsHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DomElementsProblemsHolderImpl
implements DomElementsProblemsHolder {
    private final Map<DomElement, Map<Class<? extends DomElementsInspection<?>>, List<DomElementProblemDescriptor>>> myCachedErrors = new ConcurrentHashMap();
    private final Map<DomElement, Map<Class<? extends DomElementsInspection<?>>, List<DomElementProblemDescriptor>>> myCachedChildrenErrors = new ConcurrentHashMap();
    private final List<Annotation> myAnnotations = new ArrayList<Annotation>();
    private final Function<DomElement, List<DomElementProblemDescriptor>> myDomProblemsGetter = s -> {
        Map<Class<DomElementsInspection<?>>, List<DomElementProblemDescriptor>> map = this.myCachedErrors.get(s);
        return map == null ? Collections.emptyList() : ContainerUtil.concat(map.values());
    };
    private final DomFileElement myElement;
    private final Set<Class<? extends DomElementsInspection>> myPassedInspections = new HashSet<Class<? extends DomElementsInspection>>();

    public DomElementsProblemsHolderImpl(DomFileElement element) {
        this.myElement = element;
    }

    public void appendProblems(DomElementAnnotationHolderImpl holder, Class<? extends DomElementsInspection<?>> inspectionClass) {
        if (this.isInspectionCompleted(inspectionClass)) {
            return;
        }
        Iterator iterator = holder.iterator();
        while (iterator.hasNext()) {
            DomElementProblemDescriptor descriptor = (DomElementProblemDescriptor)iterator.next();
            this.addProblem(descriptor, inspectionClass);
        }
        this.myAnnotations.addAll((Collection<Annotation>)holder.getAnnotations());
        this.myPassedInspections.add(inspectionClass);
    }

    public boolean isInspectionCompleted(@NotNull DomElementsInspection inspection) {
        if (inspection == null) {
            DomElementsProblemsHolderImpl.$$$reportNull$$$0(0);
        }
        return this.isInspectionCompleted(inspection.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInspectionCompleted(Class<? extends DomElementsInspection> inspectionClass) {
        Object object = DomElementAnnotationsManagerImpl.LOCK;
        synchronized (object) {
            return this.myPassedInspections.contains(inspectionClass);
        }
    }

    public List<Annotation> getAnnotations() {
        return this.myAnnotations;
    }

    public void addProblem(DomElementProblemDescriptor descriptor, Class<? extends DomElementsInspection<?>> inspection) {
        this.myCachedErrors.computeIfAbsent(descriptor.getDomElement(), __ -> new ConcurrentHashMap()).computeIfAbsent(inspection, __ -> new SmartList()).add(descriptor);
        this.myCachedChildrenErrors.clear();
    }

    @NotNull
    public synchronized List<DomElementProblemDescriptor> getProblems(DomElement domElement) {
        if (domElement == null || !domElement.isValid()) {
            List<DomElementProblemDescriptor> list = Collections.emptyList();
            if (list == null) {
                DomElementsProblemsHolderImpl.$$$reportNull$$$0(1);
            }
            return list;
        }
        List<DomElementProblemDescriptor> list = this.myDomProblemsGetter.apply(domElement);
        if (list == null) {
            DomElementsProblemsHolderImpl.$$$reportNull$$$0(2);
        }
        return list;
    }

    public List<DomElementProblemDescriptor> getProblems(DomElement domElement, boolean includeXmlProblems, boolean withChildren) {
        if (!withChildren || domElement == null || !domElement.isValid()) {
            return this.getProblems(domElement);
        }
        return ContainerUtil.concat(this.getProblemsMap(domElement).values());
    }

    public List<DomElementProblemDescriptor> getProblems(DomElement domElement, boolean includeXmlProblems, boolean withChildren, HighlightSeverity minSeverity) {
        return this.getProblems(domElement, withChildren, minSeverity);
    }

    public List<DomElementProblemDescriptor> getProblems(DomElement domElement, boolean withChildren, HighlightSeverity minSeverity) {
        return ContainerUtil.findAll(this.getProblems(domElement, true, withChildren), object -> SeverityRegistrar.getSeverityRegistrar((Project)domElement.getManager().getProject()).compare(object.getHighlightSeverity(), minSeverity) >= 0);
    }

    @NotNull
    private Map<Class<? extends DomElementsInspection<?>>, List<DomElementProblemDescriptor>> getProblemsMap(DomElement domElement) {
        Map<Class<? extends DomElementsInspection<?>>, List<DomElementProblemDescriptor>> map = this.myCachedChildrenErrors.get(domElement);
        if (map != null) {
            Map<Class<? extends DomElementsInspection<?>>, List<DomElementProblemDescriptor>> map2 = map;
            if (map2 == null) {
                DomElementsProblemsHolderImpl.$$$reportNull$$$0(3);
            }
            return map2;
        }
        final HashMap problems = new HashMap();
        if (domElement == this.myElement) {
            for (Map<Class<? extends DomElementsInspection<?>>, List<DomElementProblemDescriptor>> map3 : this.myCachedErrors.values()) {
                DomElementsProblemsHolderImpl.mergeMaps(problems, map3);
            }
        } else {
            DomElementsProblemsHolderImpl.mergeMaps(problems, this.myCachedErrors.get(domElement));
            if (DomUtil.hasXml((DomElement)domElement)) {
                domElement.acceptChildren(new DomElementVisitor(){

                    public void visitDomElement(DomElement element) {
                        DomElementsProblemsHolderImpl.mergeMaps(problems, DomElementsProblemsHolderImpl.this.getProblemsMap(element));
                    }
                });
            }
        }
        this.myCachedChildrenErrors.put(domElement, problems);
        HashMap hashMap = problems;
        if (hashMap == null) {
            DomElementsProblemsHolderImpl.$$$reportNull$$$0(4);
        }
        return hashMap;
    }

    private static <T> void mergeMaps(@NotNull Map<T, List<DomElementProblemDescriptor>> accumulator, @Nullable Map<T, List<DomElementProblemDescriptor>> toAdd) {
        if (accumulator == null) {
            DomElementsProblemsHolderImpl.$$$reportNull$$$0(5);
        }
        if (toAdd == null) {
            return;
        }
        for (Map.Entry<T, List<DomElementProblemDescriptor>> entry : toAdd.entrySet()) {
            accumulator.computeIfAbsent(entry.getKey(), __ -> new SmartList()).addAll((Collection)entry.getValue());
        }
    }

    public List<DomElementProblemDescriptor> getAllProblems() {
        return this.getProblems((DomElement)this.myElement, false, true);
    }

    public List<DomElementProblemDescriptor> getAllProblems(@NotNull DomElementsInspection inspection) {
        if (inspection == null) {
            DomElementsProblemsHolderImpl.$$$reportNull$$$0(6);
        }
        if (!this.myElement.isValid()) {
            return Collections.emptyList();
        }
        List<DomElementProblemDescriptor> list = this.getProblemsMap((DomElement)this.myElement).get(inspection.getClass());
        return list != null ? new ArrayList<DomElementProblemDescriptor>(list) : Collections.emptyList();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspection";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/highlighting/DomElementsProblemsHolderImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accumulator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/highlighting/DomElementsProblemsHolderImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProblems";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProblemsMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isInspectionCompleted";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "mergeMaps";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAllProblems";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

