/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.diagnostic.LoadingState;
import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.IllegalEnvVarException;
import com.intellij.execution.Platform;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.process.ProcessNotCreatedException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.util.EnvironmentRestorer;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.FastUtilHashingStrategies;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.io.IdeUtilIoBundle;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeneralCommandLine
implements UserDataHolder {
    private static final Logger LOG = Logger.getInstance(GeneralCommandLine.class);
    private String myExePath;
    private File myWorkDirectory;
    private final Map<String, String> myEnvParams;
    private ParentEnvironmentType myParentEnvironmentType;
    private final ParametersList myProgramParams;
    private Charset myCharset;
    private boolean myRedirectErrorStream;
    private File myInputFile;
    private Map<Object, Object> myUserData;

    public GeneralCommandLine() {
        this(Collections.emptyList());
    }

    public GeneralCommandLine(String ... command) {
        if (command == null) {
            GeneralCommandLine.$$$reportNull$$$0(0);
        }
        this(Arrays.asList(command));
    }

    public GeneralCommandLine(@NotNull List<String> command) {
        if (command == null) {
            GeneralCommandLine.$$$reportNull$$$0(1);
        }
        this.myEnvParams = new MyMap();
        this.myParentEnvironmentType = ParentEnvironmentType.CONSOLE;
        this.myProgramParams = new ParametersList();
        this.myCharset = GeneralCommandLine.defaultCharset();
        int size = command.size();
        if (size > 0) {
            this.setExePath(command.get(0));
            if (size > 1) {
                this.addParameters(command.subList(1, size));
            }
        }
    }

    protected GeneralCommandLine(@NotNull GeneralCommandLine original) {
        if (original == null) {
            GeneralCommandLine.$$$reportNull$$$0(2);
        }
        this.myEnvParams = new MyMap();
        this.myParentEnvironmentType = ParentEnvironmentType.CONSOLE;
        this.myProgramParams = new ParametersList();
        this.myCharset = GeneralCommandLine.defaultCharset();
        this.myExePath = original.myExePath;
        this.myWorkDirectory = original.myWorkDirectory;
        this.myEnvParams.putAll(original.myEnvParams);
        this.myParentEnvironmentType = original.myParentEnvironmentType;
        original.myProgramParams.copyTo(this.myProgramParams);
        this.myCharset = original.myCharset;
        this.myRedirectErrorStream = original.myRedirectErrorStream;
        this.myInputFile = original.myInputFile;
        this.myUserData = null;
    }

    private static Charset defaultCharset() {
        return LoadingState.COMPONENTS_LOADED.isOccurred() ? EncodingManager.getInstance().getDefaultConsoleEncoding() : Charset.defaultCharset();
    }

    @NotNull
    @NlsSafe
    public String getExePath() {
        String string2 = this.myExePath;
        if (string2 == null) {
            GeneralCommandLine.$$$reportNull$$$0(3);
        }
        return string2;
    }

    @NotNull
    public GeneralCommandLine withExePath(@NotNull String exePath) {
        if (exePath == null) {
            GeneralCommandLine.$$$reportNull$$$0(4);
        }
        this.myExePath = exePath.trim();
        GeneralCommandLine generalCommandLine = this;
        if (generalCommandLine == null) {
            GeneralCommandLine.$$$reportNull$$$0(5);
        }
        return generalCommandLine;
    }

    public void setExePath(@NotNull String exePath) {
        if (exePath == null) {
            GeneralCommandLine.$$$reportNull$$$0(6);
        }
        this.withExePath(exePath);
    }

    public File getWorkDirectory() {
        return this.myWorkDirectory;
    }

    @NotNull
    public GeneralCommandLine withWorkDirectory(@Nullable String path) {
        GeneralCommandLine generalCommandLine = this.withWorkDirectory(path != null ? new File(path) : null);
        if (generalCommandLine == null) {
            GeneralCommandLine.$$$reportNull$$$0(7);
        }
        return generalCommandLine;
    }

    @NotNull
    public GeneralCommandLine withWorkDirectory(@Nullable File workDirectory) {
        this.myWorkDirectory = workDirectory;
        GeneralCommandLine generalCommandLine = this;
        if (generalCommandLine == null) {
            GeneralCommandLine.$$$reportNull$$$0(8);
        }
        return generalCommandLine;
    }

    public void setWorkDirectory(@Nullable String path) {
        this.withWorkDirectory(path);
    }

    public void setWorkDirectory(@Nullable File workDirectory) {
        this.withWorkDirectory(workDirectory);
    }

    @NotNull
    public Map<String, String> getEnvironment() {
        Map<String, String> map = this.myEnvParams;
        if (map == null) {
            GeneralCommandLine.$$$reportNull$$$0(9);
        }
        return map;
    }

    @NotNull
    public GeneralCommandLine withEnvironment(@Nullable Map<String, String> environment) {
        if (environment != null) {
            this.getEnvironment().putAll(environment);
        }
        GeneralCommandLine generalCommandLine = this;
        if (generalCommandLine == null) {
            GeneralCommandLine.$$$reportNull$$$0(10);
        }
        return generalCommandLine;
    }

    @NotNull
    public GeneralCommandLine withEnvironment(@NotNull String key, @NotNull String value) {
        if (key == null) {
            GeneralCommandLine.$$$reportNull$$$0(11);
        }
        if (value == null) {
            GeneralCommandLine.$$$reportNull$$$0(12);
        }
        this.getEnvironment().put(key, value);
        GeneralCommandLine generalCommandLine = this;
        if (generalCommandLine == null) {
            GeneralCommandLine.$$$reportNull$$$0(13);
        }
        return generalCommandLine;
    }

    public boolean isPassParentEnvironment() {
        return this.myParentEnvironmentType != ParentEnvironmentType.NONE;
    }

    @Deprecated(forRemoval=true)
    public void setPassParentEnvironment(boolean passParentEnvironment) {
        this.withParentEnvironmentType(passParentEnvironment ? ParentEnvironmentType.CONSOLE : ParentEnvironmentType.NONE);
    }

    @NotNull
    public ParentEnvironmentType getParentEnvironmentType() {
        ParentEnvironmentType parentEnvironmentType = this.myParentEnvironmentType;
        if (parentEnvironmentType == null) {
            GeneralCommandLine.$$$reportNull$$$0(14);
        }
        return parentEnvironmentType;
    }

    @NotNull
    public GeneralCommandLine withParentEnvironmentType(@NotNull ParentEnvironmentType type) {
        if (type == null) {
            GeneralCommandLine.$$$reportNull$$$0(15);
        }
        this.myParentEnvironmentType = type;
        GeneralCommandLine generalCommandLine = this;
        if (generalCommandLine == null) {
            GeneralCommandLine.$$$reportNull$$$0(16);
        }
        return generalCommandLine;
    }

    @NotNull
    public Map<String, String> getParentEnvironment() {
        switch (this.myParentEnvironmentType) {
            case SYSTEM: {
                Map<String, String> map = System.getenv();
                if (map == null) {
                    GeneralCommandLine.$$$reportNull$$$0(17);
                }
                return map;
            }
            case CONSOLE: {
                Map<String, String> map = EnvironmentUtil.getEnvironmentMap();
                if (map == null) {
                    GeneralCommandLine.$$$reportNull$$$0(18);
                }
                return map;
            }
        }
        Map<String, String> map = Collections.emptyMap();
        if (map == null) {
            GeneralCommandLine.$$$reportNull$$$0(19);
        }
        return map;
    }

    @NotNull
    public Map<String, String> getEffectiveEnvironment() {
        MyMap env = new MyMap();
        this.setupEnvironment((Map<String, String>)((Object)env));
        MyMap myMap = env;
        if (myMap == null) {
            GeneralCommandLine.$$$reportNull$$$0(20);
        }
        return myMap;
    }

    public void addParameters(String ... parameters) {
        if (parameters == null) {
            GeneralCommandLine.$$$reportNull$$$0(21);
        }
        this.withParameters(parameters);
    }

    public void addParameters(@NotNull List<String> parameters) {
        if (parameters == null) {
            GeneralCommandLine.$$$reportNull$$$0(22);
        }
        this.withParameters(parameters);
    }

    @NotNull
    public GeneralCommandLine withParameters(String ... parameters) {
        if (parameters == null) {
            GeneralCommandLine.$$$reportNull$$$0(23);
        }
        for (String parameter : parameters) {
            this.addParameter(parameter);
        }
        GeneralCommandLine generalCommandLine = this;
        if (generalCommandLine == null) {
            GeneralCommandLine.$$$reportNull$$$0(24);
        }
        return generalCommandLine;
    }

    @NotNull
    public GeneralCommandLine withParameters(@NotNull List<String> parameters) {
        if (parameters == null) {
            GeneralCommandLine.$$$reportNull$$$0(25);
        }
        for (String parameter : parameters) {
            this.addParameter(parameter);
        }
        GeneralCommandLine generalCommandLine = this;
        if (generalCommandLine == null) {
            GeneralCommandLine.$$$reportNull$$$0(26);
        }
        return generalCommandLine;
    }

    public void addParameter(@NotNull String parameter) {
        if (parameter == null) {
            GeneralCommandLine.$$$reportNull$$$0(27);
        }
        this.myProgramParams.add(parameter);
    }

    @NotNull
    public ParametersList getParametersList() {
        ParametersList parametersList = this.myProgramParams;
        if (parametersList == null) {
            GeneralCommandLine.$$$reportNull$$$0(28);
        }
        return parametersList;
    }

    @NotNull
    public Charset getCharset() {
        Charset charset = this.myCharset;
        if (charset == null) {
            GeneralCommandLine.$$$reportNull$$$0(29);
        }
        return charset;
    }

    @NotNull
    public GeneralCommandLine withCharset(@NotNull Charset charset) {
        if (charset == null) {
            GeneralCommandLine.$$$reportNull$$$0(30);
        }
        this.myCharset = charset;
        GeneralCommandLine generalCommandLine = this;
        if (generalCommandLine == null) {
            GeneralCommandLine.$$$reportNull$$$0(31);
        }
        return generalCommandLine;
    }

    public void setCharset(@NotNull Charset charset) {
        if (charset == null) {
            GeneralCommandLine.$$$reportNull$$$0(32);
        }
        this.withCharset(charset);
    }

    public boolean isRedirectErrorStream() {
        return this.myRedirectErrorStream;
    }

    @NotNull
    public GeneralCommandLine withRedirectErrorStream(boolean redirectErrorStream) {
        this.myRedirectErrorStream = redirectErrorStream;
        GeneralCommandLine generalCommandLine = this;
        if (generalCommandLine == null) {
            GeneralCommandLine.$$$reportNull$$$0(33);
        }
        return generalCommandLine;
    }

    public void setRedirectErrorStream(boolean redirectErrorStream) {
        this.withRedirectErrorStream(redirectErrorStream);
    }

    public File getInputFile() {
        return this.myInputFile;
    }

    @NotNull
    public GeneralCommandLine withInput(@Nullable File file2) {
        this.myInputFile = file2;
        GeneralCommandLine generalCommandLine = this;
        if (generalCommandLine == null) {
            GeneralCommandLine.$$$reportNull$$$0(34);
        }
        return generalCommandLine;
    }

    @NlsSafe
    @NotNull
    public String getCommandLineString() {
        String string2 = this.getCommandLineString(null);
        if (string2 == null) {
            GeneralCommandLine.$$$reportNull$$$0(35);
        }
        return string2;
    }

    @NotNull
    public String getCommandLineString(@Nullable String exeName) {
        String string2 = ParametersListUtil.join(this.getCommandLineList(exeName));
        if (string2 == null) {
            GeneralCommandLine.$$$reportNull$$$0(36);
        }
        return string2;
    }

    @NotNull
    public List<String> getCommandLineList(@Nullable String exeName) {
        ArrayList<@NlsSafe String> commands = new ArrayList<String>();
        String exe = StringUtil.notNullize(exeName, StringUtil.notNullize(this.myExePath, "<null>"));
        commands.add(exe);
        commands.addAll(this.myProgramParams.getList());
        ArrayList<String> arrayList = commands;
        if (arrayList == null) {
            GeneralCommandLine.$$$reportNull$$$0(37);
        }
        return arrayList;
    }

    @NotNull
    public String getPreparedCommandLine() {
        String string2 = this.getPreparedCommandLine(Platform.current());
        if (string2 == null) {
            GeneralCommandLine.$$$reportNull$$$0(38);
        }
        return string2;
    }

    @NotNull
    public String getPreparedCommandLine(@NotNull Platform platform) {
        if (platform == null) {
            GeneralCommandLine.$$$reportNull$$$0(39);
        }
        String exePath = this.myExePath != null ? this.myExePath : "";
        String string2 = StringUtil.join(this.prepareCommandLine(exePath, this.myProgramParams.getList(), platform), "\n");
        if (string2 == null) {
            GeneralCommandLine.$$$reportNull$$$0(40);
        }
        return string2;
    }

    @NotNull
    protected List<String> prepareCommandLine(@NotNull String command, @NotNull List<String> parameters, @NotNull Platform platform) {
        if (command == null) {
            GeneralCommandLine.$$$reportNull$$$0(41);
        }
        if (parameters == null) {
            GeneralCommandLine.$$$reportNull$$$0(42);
        }
        if (platform == null) {
            GeneralCommandLine.$$$reportNull$$$0(43);
        }
        List<String> list = CommandLineUtil.toCommandLine(command, parameters, platform);
        if (list == null) {
            GeneralCommandLine.$$$reportNull$$$0(44);
        }
        return list;
    }

    @NotNull
    public Process createProcess() throws ExecutionException {
        Process process;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing [" + this.getCommandLineString() + "]");
            if (this.myWorkDirectory != null) {
                LOG.debug("  working dir: " + this.myWorkDirectory.getAbsolutePath());
            }
            LOG.debug("  environment: " + this.myEnvParams + " (+" + this.myParentEnvironmentType + ")");
            LOG.debug("  charset: " + this.myCharset);
        }
        List<String> commands = this.validateAndPrepareCommandLine();
        try {
            process = this.startProcess(commands);
        }
        catch (IOException e) {
            if (SystemInfo.isWindows) {
                String mode = System.getProperty("jdk.lang.Process.allowAmbiguousCommands");
                SecurityManager sm = System.getSecurityManager();
                if ("false".equalsIgnoreCase(mode) || sm != null) {
                    e.addSuppressed(new IllegalStateException("Suspicious state: allowAmbiguousCommands=" + mode + " SM=" + (sm != null ? sm.getClass() : null)));
                }
            }
            throw new ProcessNotCreatedException(e.getMessage(), e, this);
        }
        if (process == null) {
            GeneralCommandLine.$$$reportNull$$$0(45);
        }
        return process;
    }

    @NotNull
    public ProcessBuilder toProcessBuilder() throws ExecutionException {
        List<String> escapedCommands = this.validateAndPrepareCommandLine();
        ProcessBuilder processBuilder = this.toProcessBuilderInternal(escapedCommands);
        if (processBuilder == null) {
            GeneralCommandLine.$$$reportNull$$$0(46);
        }
        return processBuilder;
    }

    private List<String> validateAndPrepareCommandLine() throws ExecutionException {
        try {
            if (this.myWorkDirectory != null) {
                if (!this.myWorkDirectory.exists()) {
                    throw new ExecutionException(IdeUtilIoBundle.message("run.configuration.error.working.directory.does.not.exist", this.myWorkDirectory));
                }
                if (!this.myWorkDirectory.isDirectory()) {
                    throw new ExecutionException(IdeUtilIoBundle.message("run.configuration.error.working.directory.not.directory", this.myWorkDirectory));
                }
            }
            if (StringUtil.isEmptyOrSpaces(this.myExePath)) {
                throw new ExecutionException(IdeUtilIoBundle.message("run.configuration.error.executable.not.specified", new Object[0]));
            }
        }
        catch (ExecutionException e) {
            LOG.debug(e);
            throw e;
        }
        for (Map.Entry<String, String> entry : this.myEnvParams.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            if (!EnvironmentUtil.isValidName(name)) {
                throw new IllegalEnvVarException(IdeUtilIoBundle.message("run.configuration.invalid.env.name", name));
            }
            if (EnvironmentUtil.isValidValue(value)) continue;
            throw new IllegalEnvVarException(IdeUtilIoBundle.message("run.configuration.invalid.env.value", name, value));
        }
        String exePath = this.myExePath;
        if (exePath.indexOf(File.separatorChar) == -1) {
            File exeFile;
            String shellPath;
            String lookupPath = this.myEnvParams.get("PATH");
            if (lookupPath == null && this.myParentEnvironmentType == ParentEnvironmentType.CONSOLE && SystemInfo.isMac && !Objects.equals(shellPath = EnvironmentUtil.getValue("PATH"), System.getenv("PATH"))) {
                lookupPath = shellPath;
            }
            if (lookupPath != null && (exeFile = PathEnvironmentVariableUtil.findInPath(this.myExePath, lookupPath, null)) != null) {
                LOG.debug(exePath + " => " + exeFile);
                exePath = exeFile.getPath();
            }
        }
        return this.prepareCommandLine(exePath, this.myProgramParams.getList(), Platform.current());
    }

    @NotNull
    protected Process startProcess(@NotNull List<String> escapedCommands) throws IOException {
        if (escapedCommands == null) {
            GeneralCommandLine.$$$reportNull$$$0(47);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Building process with commands: " + escapedCommands);
        }
        Process process = this.toProcessBuilderInternal(escapedCommands).start();
        if (process == null) {
            GeneralCommandLine.$$$reportNull$$$0(48);
        }
        return process;
    }

    private ProcessBuilder toProcessBuilderInternal(List<String> escapedCommands) {
        ProcessBuilder builder = new ProcessBuilder(escapedCommands);
        this.setupEnvironment(builder.environment());
        builder.directory(this.myWorkDirectory);
        builder.redirectErrorStream(this.myRedirectErrorStream);
        if (this.myInputFile != null) {
            builder.redirectInput(ProcessBuilder.Redirect.from(this.myInputFile));
        }
        return this.buildProcess(builder);
    }

    @NotNull
    protected ProcessBuilder buildProcess(@NotNull ProcessBuilder builder) {
        if (builder == null) {
            GeneralCommandLine.$$$reportNull$$$0(49);
        }
        ProcessBuilder processBuilder = builder;
        if (processBuilder == null) {
            GeneralCommandLine.$$$reportNull$$$0(50);
        }
        return processBuilder;
    }

    protected void setupEnvironment(@NotNull Map<String, String> environment) {
        File workDirectory;
        if (environment == null) {
            GeneralCommandLine.$$$reportNull$$$0(51);
        }
        environment.clear();
        if (this.myParentEnvironmentType != ParentEnvironmentType.NONE) {
            environment.putAll(this.getParentEnvironment());
        }
        if (SystemInfo.isUnix && (workDirectory = this.getWorkDirectory()) != null) {
            environment.put("PWD", FileUtil.toSystemDependentName(workDirectory.getAbsolutePath()));
        }
        if (!this.myEnvParams.isEmpty()) {
            if (SystemInfo.isWindows) {
                Map<String, String> envVars = CollectionFactory.createCaseInsensitiveStringMap();
                envVars.putAll(environment);
                envVars.putAll(this.myEnvParams);
                environment.clear();
                environment.putAll(envVars);
            } else {
                environment.putAll(this.myEnvParams);
            }
        }
        EnvironmentRestorer.restoreOverriddenVars(environment);
    }

    @NotNull
    public static String inescapableQuote(@NotNull String parameter) {
        if (parameter == null) {
            GeneralCommandLine.$$$reportNull$$$0(52);
        }
        String string2 = CommandLineUtil.specialQuote(parameter);
        if (string2 == null) {
            GeneralCommandLine.$$$reportNull$$$0(53);
        }
        return string2;
    }

    public String toString() {
        return this.myExePath + " " + this.myProgramParams;
    }

    @Override
    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            GeneralCommandLine.$$$reportNull$$$0(54);
        }
        if (this.myUserData == null) {
            return null;
        }
        Object t = this.myUserData.get(key);
        return (T)t;
    }

    @Override
    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        if (key == null) {
            GeneralCommandLine.$$$reportNull$$$0(55);
        }
        if (this.myUserData == null) {
            if (value == null) {
                return;
            }
            this.myUserData = new HashMap<Object, Object>();
        }
        this.myUserData.put(key, value);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 50: 
            case 53: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 50: 
            case 53: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 50: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/configurations/GeneralCommandLine";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exePath";
                break;
            }
            case 11: 
            case 54: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 27: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 39: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "platform";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "escapedCommands";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/configurations/GeneralCommandLine";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExePath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "withExePath";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "withWorkDirectory";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvironment";
                break;
            }
            case 10: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "withEnvironment";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentEnvironmentType";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "withParentEnvironmentType";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentEnvironment";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getEffectiveEnvironment";
                break;
            }
            case 24: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "withParameters";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getParametersList";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getCharset";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "withCharset";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "withRedirectErrorStream";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "withInput";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandLineString";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandLineList";
                break;
            }
            case 38: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreparedCommandLine";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareCommandLine";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcess";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "toProcessBuilder";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "startProcess";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "buildProcess";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "inescapableQuote";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 50: 
            case 53: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "withExePath";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setExePath";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "withEnvironment";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "withParentEnvironmentType";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addParameters";
                break;
            }
            case 23: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "withParameters";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "addParameter";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "withCharset";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "setCharset";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getPreparedCommandLine";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "prepareCommandLine";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "startProcess";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "buildProcess";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "setupEnvironment";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "inescapableQuote";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 50: 
            case 53: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MyMap
    extends Object2ObjectOpenCustomHashMap<String, String> {
        private MyMap() {
            super(FastUtilHashingStrategies.getStringStrategy(!SystemInfo.isWindows));
        }

        public void putAll(Map<? extends String, ? extends String> map) {
            if (map != null) {
                super.putAll(map);
            }
        }
    }

    public static enum ParentEnvironmentType {
        NONE,
        SYSTEM,
        CONSOLE;

    }
}

