/*
 * Decompiled with CFR 0.152.
 */
package libraries.io.blobs;

import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.security.MessageDigest;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.LongRange;
import kotlinx.atomicfu.AtomicBoolean;
import kotlinx.atomicfu.AtomicFU;
import libraries.io.blobs.BlobUtils;
import libraries.io.blobs.ContentDigest;
import libraries.io.blobs.DigestRequestContent;
import libraries.io.blobs.MessageDigestPool;
import libraries.io.blobs.MessageDigestsPools;
import libraries.io.blobs.RequestContent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001#B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0011\u0010 \u001a\u00020!H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\"R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u001d\u0010\f\u001a\u0004\u0018\u00010\r8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u000b\u001a\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0011\u001a\u0004\u0018\u00010\u00048VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u000b\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082.\u00a2\u0006\u0002\n\u0000R'\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u001c8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010\u000b\u001a\u0004\b\u001d\u0010\u001e\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006$"}, d2={"Llibraries/io/blobs/DigestRequestContent;", "Llibraries/io/blobs/RequestContent;", "delegate", "algorithm", "", "(Llibraries/io/blobs/RequestContent;Ljava/lang/String;)V", "contentLength", "", "getContentLength", "()J", "contentLength$delegate", "Lkotlin/Lazy;", "contentRange", "Lkotlin/ranges/LongRange;", "getContentRange", "()Lkotlin/ranges/LongRange;", "contentRange$delegate", "contentType", "getContentType", "()Ljava/lang/String;", "contentType$delegate", "digest", "Llibraries/io/blobs/ContentDigest;", "getDigest", "()Llibraries/io/blobs/ContentDigest;", "digestChannel", "Llibraries/io/blobs/DigestRequestContent$DigestReadableByteChannel;", "metadata", "", "getMetadata", "()Ljava/util/Map;", "metadata$delegate", "getContent", "Ljava/nio/channels/ReadableByteChannel;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "DigestReadableByteChannel", "libraries-io"})
public final class DigestRequestContent
implements RequestContent {
    @NotNull
    private final RequestContent delegate;
    @NotNull
    private final String algorithm;
    @NotNull
    private final Lazy contentLength$delegate;
    @NotNull
    private final Lazy contentRange$delegate;
    @NotNull
    private final Lazy contentType$delegate;
    @NotNull
    private final Lazy metadata$delegate;
    private DigestReadableByteChannel digestChannel;

    public DigestRequestContent(@NotNull RequestContent delegate, @NotNull String algorithm) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        this.delegate = delegate;
        this.algorithm = algorithm;
        this.contentLength$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Long>(this){
            final /* synthetic */ DigestRequestContent this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Long invoke() {
                return DigestRequestContent.access$getDelegate$p(this.this$0).getContentLength();
            }
        }));
        this.contentRange$delegate = LazyKt.lazy((Function0)((Function0)new Function0<LongRange>(this){
            final /* synthetic */ DigestRequestContent this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final LongRange invoke() {
                return DigestRequestContent.access$getDelegate$p(this.this$0).getContentRange();
            }
        }));
        this.contentType$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ DigestRequestContent this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final String invoke() {
                return DigestRequestContent.access$getDelegate$p(this.this$0).getContentType();
            }
        }));
        this.metadata$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Map<String, ? extends String>>(this){
            final /* synthetic */ DigestRequestContent this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Map<String, String> invoke() {
                return DigestRequestContent.access$getDelegate$p(this.this$0).getMetadata();
            }
        }));
    }

    @Override
    public long getContentLength() {
        Lazy lazy = this.contentLength$delegate;
        return ((Number)lazy.getValue()).longValue();
    }

    @Override
    @Nullable
    public LongRange getContentRange() {
        Lazy lazy = this.contentRange$delegate;
        return (LongRange)lazy.getValue();
    }

    @Override
    @Nullable
    public String getContentType() {
        Lazy lazy = this.contentType$delegate;
        return (String)lazy.getValue();
    }

    @Override
    @NotNull
    public Map<String, String> getMetadata() {
        Lazy lazy = this.metadata$delegate;
        return (Map)lazy.getValue();
    }

    @NotNull
    public final ContentDigest getDigest() {
        DigestReadableByteChannel digestReadableByteChannel = this.digestChannel;
        if (digestReadableByteChannel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"digestChannel");
            digestReadableByteChannel = null;
        }
        return digestReadableByteChannel.getDigest();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object getContent(@NotNull Continuation<? super ReadableByteChannel> var1_1) {
        if (!(var1_1 instanceof getContent.1)) ** GOTO lbl-1000
        var6_2 = var1_1;
        if ((var6_2.label & -2147483648) != 0) {
            var6_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ DigestRequestContent this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getContent((Continuation<? super ReadableByteChannel>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var10_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                digestPool = MessageDigestsPools.INSTANCE.getPool(this.algorithm);
                messageDigest = (MessageDigest)digestPool.borrow();
                var4_7 = this;
                $continuation.L$0 = this;
                $continuation.L$1 = digestPool;
                $continuation.L$2 = messageDigest;
                $continuation.L$3 = var4_7;
                $continuation.label = 1;
                v0 = this.delegate.getContent((Continuation<? super ReadableByteChannel>)$continuation);
                if (v0 == var10_4) {
                    return var10_4;
                }
                ** GOTO lbl31
            }
            case 1: {
                var4_7 = (DigestRequestContent)$continuation.L$3;
                messageDigest = (MessageDigest)$continuation.L$2;
                digestPool = (MessageDigestPool)$continuation.L$1;
                this = (DigestRequestContent)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl31:
                // 2 sources

                var7_8 = (Function0)new Function0<Unit>(digestPool, messageDigest){
                    final /* synthetic */ MessageDigestPool $digestPool;
                    final /* synthetic */ MessageDigest $messageDigest;
                    {
                        this.$digestPool = $digestPool;
                        this.$messageDigest = $messageDigest;
                        super(0);
                    }

                    public final void invoke() {
                        this.$digestPool.recycle(this.$messageDigest);
                    }
                };
                var8_9 = messageDigest;
                var9_10 = (ReadableByteChannel)v0;
                var4_7.digestChannel = new DigestReadableByteChannel(var9_10, var8_9, (Function0<Unit>)var7_8);
                v1 = this.digestChannel;
                if (v1 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"digestChannel");
                    v1 = null;
                }
                return v1;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static final /* synthetic */ RequestContent access$getDelegate$p(DigestRequestContent $this) {
        return $this.delegate;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0010\u001a\u00020\u0007H\u0016J\b\u0010\u000e\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Llibraries/io/blobs/DigestRequestContent$DigestReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "channel", "messageDigest", "Ljava/security/MessageDigest;", "dispose", "Lkotlin/Function0;", "", "(Ljava/nio/channels/ReadableByteChannel;Ljava/security/MessageDigest;Lkotlin/jvm/functions/Function0;)V", "<set-?>", "Llibraries/io/blobs/ContentDigest;", "digest", "getDigest", "()Llibraries/io/blobs/ContentDigest;", "isOpen", "Lkotlinx/atomicfu/AtomicBoolean;", "close", "", "read", "", "dst", "Ljava/nio/ByteBuffer;", "libraries-io"})
    private static final class DigestReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final ReadableByteChannel channel;
        @NotNull
        private final MessageDigest messageDigest;
        @NotNull
        private final Function0<Unit> dispose;
        private ContentDigest digest;
        @NotNull
        private final AtomicBoolean isOpen;

        public DigestReadableByteChannel(@NotNull ReadableByteChannel channel2, @NotNull MessageDigest messageDigest, @NotNull Function0<Unit> dispose) {
            Intrinsics.checkNotNullParameter((Object)channel2, (String)"channel");
            Intrinsics.checkNotNullParameter((Object)messageDigest, (String)"messageDigest");
            Intrinsics.checkNotNullParameter(dispose, (String)"dispose");
            this.channel = channel2;
            this.messageDigest = messageDigest;
            this.dispose = dispose;
            this.isOpen = AtomicFU.atomic((boolean)this.channel.isOpen());
        }

        @NotNull
        public final ContentDigest getDigest() {
            ContentDigest contentDigest = this.digest;
            if (contentDigest != null) {
                return contentDigest;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"digest");
            return null;
        }

        @Override
        public boolean isOpen() {
            return this.channel.isOpen();
        }

        @Override
        public void close() {
            if (this.isOpen.compareAndSet(true, false)) {
                this.channel.close();
                this.digest = BlobUtils.INSTANCE.getDigest(this.messageDigest);
                this.dispose.invoke();
            }
        }

        @Override
        public int read(@NotNull ByteBuffer dst) {
            int n;
            Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
            int it = n = this.channel.read(dst);
            boolean bl = false;
            dst.flip();
            this.messageDigest.update(dst);
            return n;
        }
    }
}

