/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.ant;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.event.IvyEvent;
import org.apache.ivy.plugins.trigger.AbstractTrigger;
import org.apache.ivy.plugins.trigger.Trigger;
import org.apache.ivy.util.Message;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.CallTarget;
import org.apache.tools.ant.taskdefs.Property;

public class AntCallTrigger
extends AbstractTrigger
implements Trigger {
    private boolean onlyonce = true;
    private String target = null;
    private Collection<IvyEvent> calls = new ArrayList<IvyEvent>();
    private String prefix;

    @Override
    public void progress(IvyEvent event2) {
        Project project2 = (Project)IvyContext.peekInContextStack("ant-project");
        if (project2 == null) {
            Message.info("ant call trigger can only be used from an ant build. Ignoring.");
            return;
        }
        if (this.onlyonce && this.isTriggered(event2)) {
            Message.verbose("call already triggered for this event, skipping: " + event2);
        } else {
            CallTarget call2 = new CallTarget();
            call2.setProject(project2);
            call2.setTaskName("antcall");
            Map<String, String> attributes = event2.getAttributes();
            String target = IvyPatternHelper.substituteTokens(this.getTarget(), attributes);
            call2.setTarget(target);
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                Property p2 = call2.createParam();
                p2.setName(this.prefix == null ? entry.getKey() : this.prefix + entry.getKey());
                p2.setValue(entry.getValue() == null ? "" : entry.getValue());
            }
            Message.verbose("triggering ant call: target=" + target + " for " + event2);
            call2.execute();
            this.markTriggered(event2);
            Message.debug("triggered ant call finished: target=" + target + " for " + event2);
        }
    }

    private void markTriggered(IvyEvent event2) {
        this.calls.add(event2);
    }

    private boolean isTriggered(IvyEvent event2) {
        return this.calls.contains(event2);
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public boolean isOnlyonce() {
        return this.onlyonce;
    }

    public void setOnlyonce(boolean onlyonce) {
        this.onlyonce = onlyonce;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
        if (!prefix.endsWith(".")) {
            this.prefix = this.prefix + ".";
        }
    }
}

