/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.ant;

import java.util.Date;
import java.util.Locale;
import org.apache.ivy.Ivy;
import org.apache.ivy.ant.AntMessageLogger;
import org.apache.ivy.ant.IvyAntSettings;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.report.ResolveReport;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.util.DateUtil;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.StringUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Reference;

public abstract class IvyTask
extends Task {
    public static final String ANT_PROJECT_CONTEXT_KEY = "ant-project";
    private Boolean validate = null;
    private Reference antIvyEngineRef = null;

    protected boolean doValidate(IvySettings ivy) {
        if (this.validate == null) {
            return ivy.doValidate();
        }
        return this.validate;
    }

    public boolean isValidate() {
        return this.validate == null || this.validate != false;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    public void setSettingsRef(Reference ref2) {
        this.antIvyEngineRef = ref2;
    }

    public Reference getSettingsRef() {
        return this.antIvyEngineRef;
    }

    protected IvySettings getSettings() {
        return this.getIvyInstance().getSettings();
    }

    protected Ivy getIvyInstance() {
        Object antIvyEngine;
        if (this.antIvyEngineRef == null) {
            antIvyEngine = IvyAntSettings.getDefaultInstance(this);
        } else {
            antIvyEngine = this.antIvyEngineRef.getReferencedObject(this.getProject());
            if (!antIvyEngine.getClass().getName().equals(IvyAntSettings.class.getName())) {
                throw new BuildException(this.antIvyEngineRef.getRefId() + " doesn't reference an ivy:settings", this.getLocation());
            }
            if (!(antIvyEngine instanceof IvyAntSettings)) {
                throw new BuildException(this.antIvyEngineRef.getRefId() + " has been defined in a different classloader.  Please use the same loader when defining your task, or redeclare your ivy:settings in this classloader", this.getLocation());
            }
        }
        Ivy ivy = ((IvyAntSettings)((Object)antIvyEngine)).getConfiguredIvyInstance(this);
        AntMessageLogger.register((ProjectComponent)this, ivy);
        return ivy;
    }

    protected void setResolved(ResolveReport report2, boolean keep) {
        ModuleDescriptor md = report2.getModuleDescriptor();
        String[] confs = report2.getConfigurations();
        if (keep) {
            this.getProject().addReference("ivy.resolved.report", (Object)report2);
            this.getProject().addReference("ivy.resolved.configurations.ref", (Object)confs);
            this.getProject().addReference("ivy.resolved.descriptor", (Object)md);
        }
        String suffix = md.getModuleRevisionId().getModuleId().getOrganisation() + "." + md.getModuleRevisionId().getModuleId().getName();
        this.getProject().addReference("ivy.resolved.report." + suffix, (Object)report2);
        this.getProject().addReference("ivy.resolved.descriptor." + suffix, (Object)md);
        this.getProject().addReference("ivy.resolved.configurations.ref." + suffix, (Object)confs);
    }

    protected void setResolved(ResolveReport report2, String resolveId, boolean keep) {
        this.setResolved(report2, keep);
        if (resolveId == null) {
            return;
        }
        ModuleDescriptor md = report2.getModuleDescriptor();
        String[] confs = report2.getConfigurations();
        this.getProject().addReference("ivy.resolved.report." + resolveId, (Object)report2);
        this.getProject().addReference("ivy.resolved.descriptor." + resolveId, (Object)md);
        this.getProject().addReference("ivy.resolved.configurations.ref." + resolveId, (Object)confs);
    }

    protected String[] getResolvedConfigurations(String org, String module2, boolean strict) {
        return (String[])this.getReference("ivy.resolved.configurations.ref", org, module2, strict);
    }

    protected <T> T getResolvedDescriptor(String resolveId) {
        return this.getResolvedDescriptor(resolveId, true);
    }

    protected <T> T getResolvedDescriptor(String resolveId, boolean strict) {
        Object result2 = this.getProject().getReference("ivy.resolved.descriptor." + resolveId);
        if (strict && result2 == null) {
            throw new BuildException("ModuleDescriptor for resolve with id '" + resolveId + "' not found.");
        }
        return (T)result2;
    }

    protected <T> T getResolvedDescriptor(String org, String module2) {
        return this.getResolvedDescriptor(org, module2, false);
    }

    protected <T> T getResolvedDescriptor(String org, String module2, boolean strict) {
        return this.getReference("ivy.resolved.descriptor", org, module2, strict);
    }

    private <T> T getReference(String prefix, String org, String module2, boolean strict) {
        Object reference = null;
        if (org != null && module2 != null) {
            reference = this.getProject().getReference(prefix + "." + org + "." + module2);
        }
        if (!strict && reference == null) {
            reference = this.getProject().getReference(prefix);
        }
        return (T)reference;
    }

    protected ResolveReport getResolvedReport(String org, String module2, String resolveId) {
        if (resolveId == null) {
            return (ResolveReport)this.getReference("ivy.resolved.report", org, module2, false);
        }
        return (ResolveReport)this.getReference("ivy.resolved.report." + resolveId, null, null, false);
    }

    protected String[] splitConfs(String conf) {
        return StringUtils.splitToArray(conf);
    }

    protected String mergeConfs(String[] conf) {
        return StringUtils.joinArray(conf, ", ");
    }

    protected static Date getPubDate(String date2, Date def) {
        if (date2 == null) {
            return def;
        }
        if ("now".equals(date2.toLowerCase(Locale.US))) {
            return new Date();
        }
        try {
            return DateUtil.parse(date2);
        }
        catch (Exception ex) {
            throw new BuildException("Publication date provided in bad format. Should be 'yyyyMMddHHmmss' and not '" + date2 + "'!");
        }
    }

    protected String getProperty(String value2, IvySettings ivy, String name2) {
        if (value2 == null) {
            return this.getProperty(ivy, name2);
        }
        value2 = ivy.substitute(value2);
        Message.debug("parameter found as attribute value: " + name2 + "=" + value2);
        return value2;
    }

    protected String getProperty(String value2, IvySettings ivy, String name2, String resolveId) {
        if (resolveId == null) {
            return this.getProperty(value2, ivy, name2);
        }
        return this.getProperty(value2, ivy, name2 + "." + resolveId);
    }

    protected String getProperty(IvySettings ivy, String name2, String resolveId) {
        if (resolveId == null) {
            return this.getProperty(ivy, name2);
        }
        return this.getProperty(ivy, name2 + "." + resolveId);
    }

    protected String getProperty(IvySettings ivy, String name2) {
        String val = ivy.getVariable(name2);
        if (val == null) {
            val = ivy.substitute(this.getProject().getProperty(name2));
            if (val == null) {
                Message.debug("parameter not found: " + name2);
            } else {
                Message.debug("parameter found as ant project property: " + name2 + "=" + val);
            }
        } else {
            val = ivy.substitute(val);
            Message.debug("parameter found as ivy variable: " + name2 + "=" + val);
        }
        return val;
    }

    protected void prepareTask() {
        this.getProject().setProperty("ivy.version", Ivy.getIvyVersion());
        IvyContext.pushNewCopyContext();
        IvyContext.getContext().setIvy(this.getIvyInstance());
        IvyContext.getContext().push(ANT_PROJECT_CONTEXT_KEY, this.getProject());
    }

    protected void finalizeTask() {
        if (!IvyContext.getContext().pop(ANT_PROJECT_CONTEXT_KEY, this.getProject())) {
            Message.error("ANT project popped from stack not equals current! Ignoring");
        }
        IvyContext.popContext();
    }

    public final void execute() throws BuildException {
        try {
            this.prepareTask();
            this.doExecute();
        }
        finally {
            this.finalizeTask();
        }
    }

    public abstract void doExecute() throws BuildException;

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + ":" + this.getTaskName();
    }

    protected void cacheAttributeNotSupported() {
        throw new BuildException("cache attribute is not supported any more. See IVY-685 for details.");
    }
}

