/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.resolve;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.cache.ArtifactOrigin;
import org.apache.ivy.core.cache.ResolutionCacheManager;
import org.apache.ivy.core.event.EventManager;
import org.apache.ivy.core.event.download.PrepareDownloadEvent;
import org.apache.ivy.core.event.resolve.EndResolveEvent;
import org.apache.ivy.core.event.resolve.StartResolveEvent;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.report.ConfigurationResolveReport;
import org.apache.ivy.core.report.DownloadReport;
import org.apache.ivy.core.report.DownloadStatus;
import org.apache.ivy.core.report.ResolveReport;
import org.apache.ivy.core.resolve.DownloadOptions;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.core.resolve.IvyNodeCallers;
import org.apache.ivy.core.resolve.IvyNodeEviction;
import org.apache.ivy.core.resolve.ResolveData;
import org.apache.ivy.core.resolve.ResolveEngineSettings;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.apache.ivy.core.resolve.RestartResolveProcess;
import org.apache.ivy.core.resolve.VisitNode;
import org.apache.ivy.core.sort.SortEngine;
import org.apache.ivy.core.sort.SortOptions;
import org.apache.ivy.plugins.conflict.ConflictManager;
import org.apache.ivy.plugins.parser.ModuleDescriptorParser;
import org.apache.ivy.plugins.parser.ModuleDescriptorParserRegistry;
import org.apache.ivy.plugins.repository.url.URLResource;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.plugins.version.VersionMatcher;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.filter.Filter;

public class ResolveEngine {
    private ResolveEngineSettings settings;
    private EventManager eventManager;
    private SortEngine sortEngine;
    private DependencyResolver dictatorResolver;

    public ResolveEngine(ResolveEngineSettings settings2, EventManager eventManager, SortEngine sortEngine) {
        this.settings = settings2;
        this.eventManager = eventManager;
        this.sortEngine = sortEngine;
    }

    public DependencyResolver getDictatorResolver() {
        return this.dictatorResolver;
    }

    public void setDictatorResolver(DependencyResolver dictatorResolver) {
        this.dictatorResolver = dictatorResolver;
        this.settings.setDictatorResolver(dictatorResolver);
    }

    public ResolveReport resolve(File ivySource) throws ParseException, IOException {
        return this.resolve(ivySource.toURI().toURL());
    }

    public ResolveReport resolve(URL ivySource) throws ParseException, IOException {
        return this.resolve(ivySource, new ResolveOptions());
    }

    public ResolveReport resolve(ModuleRevisionId mrid, ResolveOptions options2, boolean changing) throws ParseException, IOException {
        DefaultModuleDescriptor md;
        ResolveOptions optionsToUse = new ResolveOptions(options2);
        if (options2.useSpecialConfs()) {
            ResolvedModuleRevision rmr = this.findModule(mrid, new ResolveOptions(options2));
            if (rmr == null) {
                Message.verbose("module not found " + mrid);
                optionsToUse.setLog("download-only");
                md = DefaultModuleDescriptor.newCallerInstance(mrid, new String[]{"default"}, options2.isTransitive(), changing);
            } else {
                String[] confs = options2.getConfs(rmr.getDescriptor());
                md = DefaultModuleDescriptor.newCallerInstance(ModuleRevisionId.newInstance(mrid, rmr.getId().getRevision()), confs, options2.isTransitive(), changing);
            }
        } else {
            md = DefaultModuleDescriptor.newCallerInstance(mrid, options2.getConfs(), options2.isTransitive(), changing);
        }
        return this.resolve(md, optionsToUse);
    }

    public ResolveReport resolve(URL ivySource, ResolveOptions options2) throws ParseException, IOException {
        URLResource res = new URLResource(ivySource);
        ModuleDescriptorParser parser = ModuleDescriptorParserRegistry.getInstance().getParser(res);
        Message.verbose("using " + parser + " to parse " + ivySource);
        ModuleDescriptor md = parser.parseDescriptor(this.settings, ivySource, options2.isValidate());
        String revision = options2.getRevision();
        if (revision == null && md.getResolvedModuleRevisionId().getRevision() == null) {
            revision = Ivy.getWorkingRevision();
        }
        if (revision != null) {
            md.setResolvedModuleRevisionId(ModuleRevisionId.newInstance(md.getModuleRevisionId(), revision));
        }
        return this.resolve(md, options2);
    }

    public ResolveReport resolve(ModuleDescriptor md, ResolveOptions options2) throws ParseException, IOException {
        DependencyResolver oldDictator = this.getDictatorResolver();
        IvyContext context2 = IvyContext.getContext();
        try {
            String[] confs = options2.getConfs(md);
            options2.setConfs(confs);
            if (options2.getResolveId() == null) {
                options2.setResolveId(ResolveOptions.getDefaultResolveId(md));
            }
            this.eventManager.fireIvyEvent(new StartResolveEvent(md, confs));
            long start2 = System.currentTimeMillis();
            if ("default".equals(options2.getLog())) {
                Message.info(":: resolving dependencies :: " + md.getResolvedModuleRevisionId() + (options2.isTransitive() ? "" : " [not transitive]"));
                Message.info("\tconfs: " + Arrays.asList(confs));
            } else {
                Message.verbose(":: resolving dependencies :: " + md.getResolvedModuleRevisionId() + (options2.isTransitive() ? "" : " [not transitive]"));
                Message.verbose("\tconfs: " + Arrays.asList(confs));
            }
            Message.verbose("\tvalidate = " + options2.isValidate());
            Message.verbose("\trefresh = " + options2.isRefresh());
            ResolveReport report2 = new ResolveReport(md, options2.getResolveId());
            ResolveData data2 = new ResolveData(this, options2);
            context2.setResolveData(data2);
            IvyNode[] dependencies = this.getDependencies(md, options2, report2);
            report2.setDependencies(Arrays.asList(dependencies), options2.getArtifactFilter());
            if (options2.getCheckIfChanged()) {
                report2.checkIfChanged();
            }
            ResolutionCacheManager cacheManager = this.settings.getResolutionCacheManager();
            cacheManager.saveResolvedModuleDescriptor(md);
            File ivyPropertiesInCache = cacheManager.getResolvedIvyPropertiesInCache(md.getResolvedModuleRevisionId());
            Properties props = new Properties();
            if (dependencies.length > 0) {
                DependencyDescriptor dd;
                HashMap<ModuleId, ModuleRevisionId> forcedRevisions = new HashMap<ModuleId, ModuleRevisionId>();
                for (IvyNode dependency : dependencies) {
                    if (dependency.getModuleRevision() == null || !dependency.getModuleRevision().isForce()) continue;
                    forcedRevisions.put(dependency.getModuleId(), dependency.getResolvedId());
                }
                IvyNode ivyNode = dependencies[0].getRoot();
                HashMap<ModuleId, IvyNode> topLevelDeps = new HashMap<ModuleId, IvyNode>();
                for (IvyNode dependency : dependencies) {
                    if (dependency.hasProblem() || (dd = dependency.getDependencyDescriptor(ivyNode)) == null) continue;
                    ModuleId orgMod = dependency.getModuleId();
                    topLevelDeps.put(orgMod, dependency);
                }
                for (IvyNode dependency : dependencies) {
                    ModuleId mid;
                    IvyNode tlDep;
                    if (dependency.hasProblem() || dependency.isCompletelyEvicted()) continue;
                    dd = dependency.getDependencyDescriptor(ivyNode);
                    if (dd == null && (tlDep = (IvyNode)topLevelDeps.get(mid = dependency.getModuleId())) != null) {
                        dd = tlDep.getDependencyDescriptor(ivyNode);
                    }
                    if (dd == null) continue;
                    ModuleRevisionId depResolvedId = dependency.getResolvedId();
                    ModuleDescriptor depDescriptor = dependency.getDescriptor();
                    ModuleRevisionId depRevisionId = dd.getDependencyRevisionId();
                    ModuleRevisionId forcedRevisionId = (ModuleRevisionId)forcedRevisions.get(dependency.getModuleId());
                    if (dependency.getModuleRevision() != null && dependency.getModuleRevision().isForce() && !depResolvedId.equals(depRevisionId) && !this.settings.getVersionMatcher().isDynamic(depRevisionId)) {
                        depResolvedId = depRevisionId;
                        depDescriptor = null;
                    }
                    if (depResolvedId == null) {
                        throw new NullPointerException("getResolvedId() is null for " + dependency.toString());
                    }
                    if (depRevisionId == null) {
                        throw new NullPointerException("getDependencyRevisionId() is null for " + dd.toString());
                    }
                    String rev = depResolvedId.getRevision();
                    String forcedRev = forcedRevisionId == null ? rev : forcedRevisionId.getRevision();
                    String status2 = depDescriptor == null ? "?" : depDescriptor.getStatus();
                    Message.debug("storing dependency " + depResolvedId + " in props");
                    props.put(depRevisionId.encodeToString(), rev + " " + status2 + " " + forcedRev + " " + depResolvedId.getBranch());
                }
            }
            FileOutputStream out = new FileOutputStream(ivyPropertiesInCache);
            props.store(out, md.getResolvedModuleRevisionId() + " resolved revisions");
            out.close();
            Message.verbose("\tresolved ivy file produced in cache");
            report2.setResolveTime(System.currentTimeMillis() - start2);
            if (options2.isDownload()) {
                Message.verbose(":: downloading artifacts ::");
                DownloadOptions downloadOptions = new DownloadOptions();
                downloadOptions.setLog(options2.getLog());
                this.downloadArtifacts(report2, options2.getArtifactFilter(), downloadOptions);
            }
            if (options2.isOutputReport()) {
                this.outputReport(report2, cacheManager, options2);
            }
            Message.verbose("\tresolve done (" + report2.getResolveTime() + "ms resolve - " + report2.getDownloadTime() + "ms download)");
            Message.sumupProblems();
            this.eventManager.fireIvyEvent(new EndResolveEvent(md, confs, report2));
            ResolveReport resolveReport = report2;
            return resolveReport;
        }
        catch (RuntimeException ex) {
            Message.debug(ex);
            Message.error(ex.getMessage());
            Message.sumupProblems();
            throw ex;
        }
        finally {
            context2.setResolveData(null);
            this.setDictatorResolver(oldDictator);
        }
    }

    public void outputReport(ResolveReport report2, ResolutionCacheManager cacheMgr, ResolveOptions options2) throws IOException {
        if ("default".equals(options2.getLog())) {
            Message.info(":: resolution report :: resolve " + report2.getResolveTime() + "ms :: artifacts dl " + report2.getDownloadTime() + "ms");
        } else {
            Message.verbose(":: resolution report :: resolve " + report2.getResolveTime() + "ms :: artifacts dl " + report2.getDownloadTime() + "ms");
        }
        report2.setProblemMessages(Message.getProblems());
        report2.output(this.settings.getReportOutputters(), cacheMgr, options2);
    }

    public void downloadArtifacts(ResolveReport report2, Filter<Artifact> artifactFilter, DownloadOptions options2) {
        long start2 = System.currentTimeMillis();
        this.eventManager.fireIvyEvent(new PrepareDownloadEvent(report2.getArtifacts().toArray(new Artifact[report2.getArtifacts().size()])));
        long totalSize = 0L;
        for (IvyNode dependency : report2.getDependencies()) {
            this.checkInterrupted();
            if (dependency.isCompletelyEvicted() || dependency.hasProblem() || dependency.getModuleRevision() == null) continue;
            DependencyResolver resolver2 = dependency.getModuleRevision().getArtifactResolver();
            Artifact[] selectedArtifacts = dependency.getSelectedArtifacts(artifactFilter);
            DownloadReport dReport = resolver2.download(selectedArtifacts, options2);
            for (ArtifactDownloadReport adr : dReport.getArtifactsReports()) {
                if (adr.getDownloadStatus() == DownloadStatus.FAILED) {
                    if (adr.getArtifact().getExtraAttribute("ivy:merged") != null) {
                        Message.warn("\tmerged artifact not found: " + adr.getArtifact() + ". It was required in " + adr.getArtifact().getExtraAttribute("ivy:merged"));
                        continue;
                    }
                    Message.warn("\t" + adr);
                    resolver2.reportFailure(adr.getArtifact());
                    continue;
                }
                if (adr.getDownloadStatus() != DownloadStatus.SUCCESSFUL) continue;
                totalSize += adr.getSize();
            }
            for (String dconf : dependency.getRootModuleConfigurations()) {
                if (dependency.isEvicted(dconf) || dependency.isBlacklisted(dconf)) {
                    report2.getConfigurationReport(dconf).addDependency(dependency);
                    continue;
                }
                report2.getConfigurationReport(dconf).addDependency(dependency, dReport);
            }
        }
        report2.setDownloadTime(System.currentTimeMillis() - start2);
        report2.setDownloadSize(totalSize);
    }

    public ArtifactDownloadReport download(Artifact artifact, DownloadOptions options2) {
        DependencyResolver resolver2 = this.settings.getResolver(artifact.getModuleRevisionId());
        DownloadReport r = resolver2.download(new Artifact[]{artifact}, options2);
        return r.getArtifactReport(artifact);
    }

    public ArtifactOrigin locate(Artifact artifact) {
        DependencyResolver resolver2 = this.settings.getResolver(artifact.getModuleRevisionId());
        return resolver2.locate(artifact);
    }

    public ArtifactDownloadReport download(ArtifactOrigin origin, DownloadOptions options2) {
        DependencyResolver resolver2 = this.settings.getResolver(origin.getArtifact().getModuleRevisionId());
        return resolver2.download(origin, options2);
    }

    public IvyNode[] getDependencies(URL ivySource, ResolveOptions options2) throws ParseException, IOException {
        return this.getDependencies(ModuleDescriptorParserRegistry.getInstance().parseDescriptor(this.settings, ivySource, options2.isValidate()), options2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IvyNode[] getDependencies(ModuleDescriptor md, ResolveOptions options2, ResolveReport report2) {
        if (md == null) {
            throw new NullPointerException("module descriptor must not be null");
        }
        String[] confs = options2.getConfs(md);
        ArrayList<String> missingConfs = new ArrayList<String>();
        for (String conf : confs) {
            if (conf == null) {
                throw new NullPointerException("null conf not allowed: confs where: " + Arrays.asList(confs));
            }
            if (md.getConfiguration(conf) != null) continue;
            missingConfs.add(" '" + conf + "' ");
        }
        if (!missingConfs.isEmpty()) {
            throw new IllegalArgumentException("requested configuration" + (missingConfs.size() > 1 ? "s" : "") + " not found in " + md.getModuleRevisionId() + ": " + missingConfs);
        }
        IvyContext context2 = IvyContext.pushNewCopyContext();
        try {
            options2.setConfs(confs);
            Date reportDate = new Date();
            ResolveData data2 = context2.getResolveData();
            if (data2 == null) {
                data2 = new ResolveData(this, options2);
                context2.setResolveData(data2);
            }
            IvyNode rootNode = new IvyNode(data2, md);
            for (String conf : confs) {
                Message.verbose("resolving dependencies for configuration '" + conf + "'");
                ConfigurationResolveReport confReport = null;
                if (report2 != null && (confReport = report2.getConfigurationReport(conf)) == null) {
                    confReport = new ConfigurationResolveReport(this, md, conf, reportDate, options2);
                    report2.addReport(conf, confReport);
                }
                data2.setReport(confReport);
                VisitNode root2 = new VisitNode(data2, rootNode, null, conf, null);
                root2.setRequestedConf(conf);
                rootNode.updateConfsToFetch(Collections.singleton(conf));
                boolean fetched = false;
                while (!fetched) {
                    try {
                        this.fetchDependencies(root2, conf, new HashSet<String>(), false);
                        fetched = true;
                    }
                    catch (RestartResolveProcess restart) {
                        Message.verbose("====================================================");
                        Message.verbose("=           RESTARTING RESOLVE PROCESS");
                        Message.verbose("= " + restart.getMessage());
                        Message.verbose("====================================================");
                    }
                }
                for (IvyNode dep : data2.getNodes()) {
                    dep.clean();
                }
            }
            Collection<IvyNode> nodes2 = data2.getNodes();
            LinkedHashSet<IvyNode> dependencies = new LinkedHashSet<IvyNode>(nodes2.size());
            for (IvyNode node : nodes2) {
                if (node == null || node.isRoot() || node.isCompletelyBlacklisted()) continue;
                dependencies.add(node);
            }
            List<IvyNode> sortedDependencies = this.sortEngine.sortNodes(dependencies, SortOptions.SILENT);
            Collections.reverse(sortedDependencies);
            this.handleTransitiveEviction(md, confs, data2, sortedDependencies);
            IvyNode[] ivyNodeArray = dependencies.toArray(new IvyNode[dependencies.size()]);
            return ivyNodeArray;
        }
        finally {
            IvyContext.popContext();
        }
    }

    private void handleTransitiveEviction(ModuleDescriptor md, String[] confs, ResolveData data2, List<IvyNode> sortedDependencies) {
        for (IvyNode node : sortedDependencies) {
            if (node.isCompletelyEvicted()) continue;
            for (String conf : confs) {
                IvyNodeCallers.Caller[] callers = node.getCallers(conf);
                if (this.settings.debugConflictResolution()) {
                    Message.debug("checking if " + node.getId() + " is transitively evicted in " + conf);
                }
                boolean allEvicted = callers.length > 0;
                for (IvyNodeCallers.Caller caller : callers) {
                    if (caller.getModuleRevisionId().equals(md.getModuleRevisionId())) {
                        allEvicted = false;
                        break;
                    }
                    IvyNode callerNode = data2.getNode(caller.getModuleRevisionId());
                    if (callerNode == null) {
                        Message.warn("ivy internal error: no node found for " + caller.getModuleRevisionId() + ": looked in " + data2.getNodeIds() + " and root module id was " + md.getModuleRevisionId());
                        continue;
                    }
                    if (!callerNode.isEvicted(conf)) {
                        allEvicted = false;
                        break;
                    }
                    if (!this.settings.debugConflictResolution()) continue;
                    Message.debug("caller " + callerNode.getId() + " of " + node.getId() + " is evicted");
                }
                if (allEvicted) {
                    Message.verbose("all callers are evicted for " + node + ": evicting too");
                    node.markEvicted(conf, null, null, null);
                    continue;
                }
                if (!this.settings.debugConflictResolution()) continue;
                Message.debug(node.getId() + " isn't transitively evicted, at least one caller was not evicted");
            }
        }
    }

    private void fetchDependencies(VisitNode node, String conf, Set<String> fetchedSet, boolean shouldBePublic) {
        IvyNodeEviction.EvictionData ed;
        this.checkInterrupted();
        long start2 = System.currentTimeMillis();
        if (node.getParent() != null) {
            Message.verbose("== resolving dependencies " + node.getParent().getId() + "->" + node.getId() + " [" + node.getParentConf() + "->" + conf + "]");
        } else {
            Message.verbose("== resolving dependencies for " + node.getId() + " [" + conf + "]");
        }
        ResolveData data2 = node.getNode().getData();
        VisitNode parentVisitNode = data2.getCurrentVisitNode();
        data2.setCurrentVisitNode(node);
        DependencyDescriptor dd = node.getDependencyDescriptor();
        VersionMatcher versionMatcher = node.getNode().getData().getSettings().getVersionMatcher();
        if (!(dd == null || node.getRoot() == node.getParent() && versionMatcher.isDynamic(dd.getDependencyRevisionId()))) {
            this.resolveConflict(node, conf);
        }
        if (node.loadData(conf, shouldBePublic)) {
            this.resolveConflict(node, conf);
            if (!node.isEvicted() && !node.isCircular()) {
                for (String rconf : node.getRealConfs(conf)) {
                    this.doFetchDependencies(node, rconf, fetchedSet);
                }
            }
        } else if (!(node.hasProblem() || node.isEvicted() || node.isCircular())) {
            for (String rconf : node.getRealConfs(conf)) {
                this.doFetchDependencies(node, rconf, fetchedSet);
            }
        }
        if (node.isEvicted() && (ed = node.getEvictedData()).getSelected() != null) {
            for (IvyNode selected2 : ed.getSelected()) {
                if (!selected2.isLoaded()) {
                    selected2.updateConfsToFetch(Collections.singleton(conf));
                    continue;
                }
                this.fetchDependencies(node.gotoNode(selected2), conf, fetchedSet, true);
            }
        }
        if (this.settings.debugConflictResolution()) {
            Message.debug(node.getId() + " => dependencies resolved in " + conf + " (" + (System.currentTimeMillis() - start2) + "ms)");
        }
        data2.setCurrentVisitNode(parentVisitNode);
    }

    private void doFetchDependencies(VisitNode node, String conf, Set<String> fetchedSet) {
        String[] extendedConfs;
        Configuration c = node.getConfiguration(conf);
        if (c == null) {
            if (!node.isConfRequiredByMergedUsageOnly(conf)) {
                Message.warn("configuration not found '" + conf + "' in " + node.getResolvedId() + ": ignoring");
                if (node.getParent() != null) {
                    Message.warn("it was required from " + node.getParent().getResolvedId());
                }
            }
            return;
        }
        boolean requestedConfSet = false;
        if (node.getRequestedConf() == null) {
            node.setRequestedConf(conf);
            requestedConfSet = true;
        }
        if ((extendedConfs = c.getExtends()).length > 0) {
            node.updateConfsToFetch(Arrays.asList(extendedConfs));
        }
        for (String extendedConf : extendedConfs) {
            this.fetchDependencies(node, extendedConf, fetchedSet, false);
        }
        if (!this.isDependenciesFetched(node.getNode(), conf, fetchedSet) && node.isTransitive()) {
            for (VisitNode dep : node.getDependencies(conf)) {
                dep.useRealNode();
                for (String rconf : dep.getRequiredConfigurations(node, conf)) {
                    this.fetchDependencies(dep, rconf, fetchedSet, true);
                }
                if (dep.isEvicted() || dep.hasProblem()) continue;
                for (String fconf : dep.getConfsToFetch()) {
                    this.fetchDependencies(dep, fconf, fetchedSet, false);
                }
            }
            this.markDependenciesFetched(node.getNode(), conf, fetchedSet);
        }
        if (requestedConfSet) {
            node.setRequestedConf(null);
        }
    }

    private boolean isDependenciesFetched(IvyNode node, String conf, Set<String> fetchedSet) {
        String key2 = this.getDependenciesFetchedKey(node, conf);
        return fetchedSet.contains(key2);
    }

    private void markDependenciesFetched(IvyNode node, String conf, Set<String> fetchedSet) {
        String key2 = this.getDependenciesFetchedKey(node, conf);
        fetchedSet.add(key2);
    }

    private String getDependenciesFetchedKey(IvyNode node, String conf) {
        ModuleRevisionId moduleRevisionId = node.getResolvedId();
        return moduleRevisionId.getOrganisation() + "|" + moduleRevisionId.getName() + "|" + moduleRevisionId.getRevision() + "|" + conf;
    }

    private void resolveConflict(VisitNode node, String conf) {
        this.resolveConflict(node, node.getParent(), conf, Collections.emptySet());
    }

    private boolean resolveConflict(VisitNode node, VisitNode ancestor, String conf, Collection<IvyNode> toevict) {
        Collection<IvyNode> resolved2;
        if (ancestor == null || node == ancestor) {
            return true;
        }
        if (this.checkConflictSolvedEvicted(node, ancestor)) {
            return true;
        }
        boolean debugConflictResolution = this.settings.debugConflictResolution();
        if (this.checkConflictSolvedSelected(node, ancestor)) {
            if (this.resolveConflict(node, ancestor.getParent(), conf, toevict)) {
                IvyNodeEviction.EvictionData evictionData = node.getEvictionDataInRoot(node.getRootModuleConf(), ancestor);
                if (evictionData != null) {
                    if (debugConflictResolution) {
                        Message.debug(node + " was previously evicted in root module conf " + node.getRootModuleConf());
                    }
                    node.markEvicted(evictionData);
                    if (debugConflictResolution) {
                        Message.debug("evicting " + node + " by " + evictionData);
                    }
                }
                return true;
            }
            return false;
        }
        Set<IvyNode> resolvedNodes = ancestor.getNode().getResolvedNodes(node.getModuleId(), node.getRootModuleConf());
        resolvedNodes.addAll(ancestor.getNode().getPendingConflicts(node.getRootModuleConf(), node.getModuleId()));
        Collection<IvyNode> conflicts = this.computeConflicts(node, ancestor, conf, toevict, resolvedNodes);
        ConflictManager conflictManager = null;
        for (VisitNode visitNode : ancestor.getPath()) {
            ModuleDescriptor descriptor2 = visitNode.getNode().getDescriptor();
            if (descriptor2 == null) {
                throw new IllegalStateException("impossible to get conflict manager when data has not been loaded. IvyNode = " + visitNode.getNode());
            }
            conflictManager = descriptor2.getConflictManager(node.getModuleId());
            if (conflictManager == null) continue;
            break;
        }
        if (conflictManager == null) {
            conflictManager = this.settings.getConflictManager(node.getModuleId());
        }
        if ((resolved2 = this.resolveConflicts(node, ancestor, conflicts, conflictManager)) == null) {
            if (debugConflictResolution) {
                Message.debug("impossible to resolve conflicts for " + node + " in " + ancestor + " yet");
                Message.debug("setting all nodes as pending conflicts for later conflict resolution: " + conflicts);
            }
            ancestor.getNode().setPendingConflicts(node.getModuleId(), node.getRootModuleConf(), conflicts);
            return false;
        }
        if (debugConflictResolution) {
            Message.debug("selected revisions for " + node + " in " + ancestor + ": " + resolved2);
        }
        if (resolved2.contains(node.getNode())) {
            toevict = resolvedNodes;
            toevict.removeAll(resolved2);
            for (IvyNode te : toevict) {
                te.markEvicted(node.getRootModuleConf(), ancestor.getNode(), conflictManager, resolved2);
                if (!debugConflictResolution) continue;
                Message.debug("evicting " + te + " by " + te.getEvictedData(node.getRootModuleConf()));
            }
            ancestor.getNode().setResolvedNodes(node.getModuleId(), node.getRootModuleConf(), resolved2);
            HashSet<IvyNode> hashSet = new HashSet<IvyNode>(ancestor.getNode().getEvictedNodes(node.getModuleId(), node.getRootModuleConf()));
            hashSet.removeAll(resolved2);
            hashSet.addAll(toevict);
            ancestor.getNode().setEvictedNodes(node.getModuleId(), node.getRootModuleConf(), hashSet);
            ancestor.getNode().setPendingConflicts(node.getModuleId(), node.getRootModuleConf(), Collections.emptySet());
            return this.resolveConflict(node, ancestor.getParent(), conf, toevict);
        }
        if (resolved2.isEmpty() && debugConflictResolution) {
            Message.verbose("conflict manager '" + conflictManager + "' evicted all revisions among " + conflicts);
        }
        HashSet<IvyNode> hashSet = new HashSet<IvyNode>(ancestor.getNode().getEvictedNodes(node.getModuleId(), node.getRootModuleConf()));
        toevict.removeAll(resolved2);
        hashSet.removeAll(resolved2);
        hashSet.addAll(toevict);
        hashSet.add(node.getNode());
        ancestor.getNode().setEvictedNodes(node.getModuleId(), node.getRootModuleConf(), hashSet);
        ancestor.getNode().setPendingConflicts(node.getModuleId(), node.getRootModuleConf(), Collections.emptySet());
        node.markEvicted(ancestor, conflictManager, resolved2);
        if (debugConflictResolution) {
            Message.debug("evicting " + node + " by " + node.getEvictedData());
        }
        Set<IvyNode> prevResolved = ancestor.getNode().getResolvedNodes(node.getModuleId(), node.getRootModuleConf());
        boolean solved = true;
        if (!prevResolved.equals(resolved2)) {
            ancestor.getNode().setResolvedNodes(node.getModuleId(), node.getRootModuleConf(), resolved2);
            for (IvyNode sel : resolved2) {
                if (prevResolved.contains(sel)) continue;
                solved &= this.resolveConflict(node.gotoNode(sel), ancestor.getParent(), conf, toevict);
            }
        }
        return solved;
    }

    private Collection<IvyNode> resolveConflicts(VisitNode node, VisitNode ancestor, Collection<IvyNode> conflicts, ConflictManager conflictManager) {
        if (node.getParent() != ancestor && conflictManager == this.settings.getConflictManager(node.getModuleId()) && node.getParent().getNode().getResolvedNodes(node.getModuleId(), node.getRootModuleConf()).equals(conflicts)) {
            if (this.settings.debugConflictResolution()) {
                Message.debug("no new conflicting revisions for " + node + " in " + ancestor + ": " + conflicts);
            }
            return conflicts;
        }
        if (this.settings.debugConflictResolution()) {
            Message.debug("found conflicting revisions for " + node + " in " + ancestor + ": " + conflicts);
        }
        return conflictManager.resolveConflicts(ancestor.getNode(), conflicts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<IvyNode> computeConflicts(VisitNode node, VisitNode ancestor, String conf, Collection<IvyNode> toevict, Collection<IvyNode> selectedNodes) {
        LinkedHashSet<IvyNode> conflicts = new LinkedHashSet<IvyNode>();
        conflicts.add(node.getNode());
        boolean evictedInSelected = selectedNodes.removeAll(toevict);
        if (evictedInSelected || selectedNodes.isEmpty() && !node.getParent().getNode().equals(ancestor.getNode())) {
            IvyContext context2 = IvyContext.getContext();
            ResolveData data2 = context2.getResolveData();
            VisitNode oldVisitNode = data2.getCurrentVisitNode();
            data2.setCurrentVisitNode(ancestor);
            try {
                Collection<IvyNode> deps = ancestor.getNode().getDependencies(node.getRootModuleConf(), ancestor.getNode().getConfigurations(node.getRootModuleConf()), ancestor.getRequestedConf());
                for (IvyNode dep : deps) {
                    if (dep.getModuleId().equals(node.getModuleId())) {
                        conflicts.add(dep);
                    }
                    conflicts.addAll(dep.getResolvedNodes(node.getModuleId(), node.getRootModuleConf()));
                }
            }
            finally {
                data2.setCurrentVisitNode(oldVisitNode);
            }
        } else if (selectedNodes.isEmpty()) {
            VisitNode parent = node.getParent();
            Collection<IvyNode> parentDepIvyNodes = parent.getNode().getDependencies(node.getRootModuleConf(), parent.getNode().getConfigurations(node.getRootModuleConf()), parent.getRequestedConf());
            for (IvyNode parentDep : parentDepIvyNodes) {
                if (!parentDep.getModuleId().equals(node.getModuleId())) continue;
                conflicts.add(parentDep);
            }
        } else {
            conflicts.addAll(selectedNodes);
        }
        return conflicts;
    }

    private boolean checkConflictSolvedSelected(VisitNode node, VisitNode ancestor) {
        if (ancestor.getResolvedRevisions(node.getModuleId()).contains(node.getResolvedId())) {
            if (this.settings.debugConflictResolution()) {
                Message.debug("conflict resolution already done for " + node + " in " + ancestor);
            }
            return true;
        }
        return false;
    }

    private boolean checkConflictSolvedEvicted(VisitNode node, VisitNode ancestor) {
        if (ancestor.getEvictedRevisions(node.getModuleId()).contains(node.getResolvedId())) {
            if (this.settings.debugConflictResolution()) {
                Message.debug("conflict resolution already done for " + node + " in " + ancestor);
            }
            return true;
        }
        return false;
    }

    public ResolvedModuleRevision findModule(ModuleRevisionId id, ResolveOptions options2) {
        DependencyResolver r = this.settings.getResolver(id);
        if (r == null) {
            throw new IllegalStateException("no resolver found for " + id.getModuleId());
        }
        DefaultModuleDescriptor md = DefaultModuleDescriptor.newCallerInstance(id, new String[]{"*"}, false, false);
        if (options2.getResolveId() == null) {
            options2.setResolveId(ResolveOptions.getDefaultResolveId(md));
        }
        try {
            return r.getDependency(new DefaultDependencyDescriptor(id, true), new ResolveData(this, options2, new ConfigurationResolveReport(this, md, "default", null, options2)));
        }
        catch (ParseException e) {
            throw new RuntimeException("problem while parsing repository module descriptor for " + id + ": " + e, e);
        }
    }

    public DependencyDescriptor mediate(DependencyDescriptor dd, ResolveOptions options2) {
        String resolveMode;
        if (dd == null) {
            return null;
        }
        String string2 = resolveMode = options2.getResolveMode() == null ? this.settings.getResolveMode(dd.getDependencyId()) : options2.getResolveMode();
        if ("dynamic".equals(resolveMode) && !dd.getDynamicConstraintDependencyRevisionId().equals(dd.getDependencyRevisionId())) {
            return dd.clone(ModuleRevisionId.newInstance(dd.getDynamicConstraintDependencyRevisionId(), dd.getDynamicConstraintDependencyRevisionId().getRevision()));
        }
        return dd;
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public ResolveEngineSettings getSettings() {
        return this.settings;
    }

    public SortEngine getSortEngine() {
        return this.sortEngine;
    }

    private void checkInterrupted() {
        IvyContext.getContext().getIvy().checkInterrupted();
    }
}

