/*
 * Decompiled with CFR 0.152.
 */
package runtime.reactive;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import libraries.basics.DebugCommonKt;
import libraries.basics.DebugKt;
import libraries.collections.Collections;
import libraries.collections.MutableSetLike;
import libraries.coroutines.extra.Lifetime;
import libraries.coroutines.extra.LifetimeSource;
import libraries.klogging.GroupsKt;
import libraries.klogging.KLogger;
import libraries.klogging.RichLogRecord;
import libraries.klogging.RichLogRecordKt;
import libraries.klogging.RichLoggable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.reactive.CellTracker;
import runtime.reactive.Computed;
import runtime.reactive.ComputedExpression;
import runtime.reactive.ComputedKt;
import runtime.reactive.DependenciesState;
import runtime.reactive.DevCellTrackerChecks;
import runtime.reactive.Maybe;
import runtime.reactive.Property;
import runtime.reactive.PropertyLiveKt;
import runtime.reactive.ReactionsKt;
import runtime.reactive.Signal;
import runtime.reactive.XTrackableLifetimed;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0010\b&\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001?B*\u0012#\u0010\u0003\u001a\u001f\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\u0010\bJ6\u0010\u0011\u001a\"\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0013\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0002\b\u00030\u0015j\u0002`\u00160\u00140\u00122\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006H\bJ8\u0010\u0018\u001a\u001c\u0012\u0004\u0012\u00028\u0000\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0002\b\u00030\u0015j\u0002`\u00160\u00140\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006H\bJ\u001d\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00028\u00002\u0006\u0010\u001e\u001a\u00028\u0000H\b\u00a2\u0006\u0002\u0010\u001fJ$\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001a2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020!0$H\u0016J$\u0010%\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001a2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020!0$H\u0016J\b\u0010'\u001a\u00020(H$J\b\u0010)\u001a\u00020\u001cH&J\u000e\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013H\bJ2\u0010+\u001a\u001e\u0012\u0004\u0012\u00020\u001c\u0012\u0014\u0012\u0012\u0012\f\u0012\n\u0012\u0002\b\u00030\u0015j\u0002`\u0016\u0018\u00010\u00140\u00122\f\u0010,\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013H\bJ\b\u0010-\u001a\u00020\u001cH$J\u0010\u0010.\u001a\u00020!2\u0006\u0010/\u001a\u000200H\u0002J\"\u00101\u001a\u00020!2\f\u00102\u001a\b\u0012\u0004\u0012\u00028\u00000\u00132\n\u00103\u001a\u0006\u0012\u0002\b\u00030\u0000H\bJ\u0016\u00104\u001a\u00020!2\f\u00102\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013H\bJ\u0016\u00105\u001a\u0004\u0018\u00010(2\n\u00102\u001a\u0006\u0012\u0002\b\u00030\u0013H$J:\u00106\u001a\u00020!2\f\u0010,\u001a\b\u0012\u0004\u0012\u00028\u00000\u00132\f\u00107\u001a\b\u0012\u0004\u0012\u00028\u00000\u00132\u0014\u00108\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u00030\u0015j\u0002`\u00160\u0014H\bJ,\u00109\u001a\u00020!2\f\u00102\u001a\b\u0012\u0004\u0012\u00028\u00000\u00132\u0014\u0010:\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u00030\u0015j\u0002`\u00160\u0014H\bJ,\u0010;\u001a\u00020!2\f\u0010,\u001a\b\u0012\u0004\u0012\u00028\u00000\u00132\u0014\u00108\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u00030\u0015j\u0002`\u00160\u0014H\bJ\u0006\u0010<\u001a\u00020\u001cJ.\u0010=\u001a\u00020!2\f\u0010,\u001a\b\u0012\u0004\u0012\u00028\u00000\u00132\u0016\u0010>\u001a\u0012\u0012\f\u0012\n\u0012\u0002\b\u00030\u0015j\u0002`\u0016\u0018\u00010\u0014H\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\u0003\u001a\u001f\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\b\u0007X\u0088\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\rX\u0088\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00028\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006@"}, d2={"Lruntime/reactive/ComputedExpression;", "T", "Lruntime/reactive/Computed;", "expression", "Lkotlin/Function2;", "Lruntime/reactive/XTrackableLifetimed;", "Lruntime/reactive/Maybe;", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function2;)V", "changeEvents", "Lruntime/reactive/Signal;", "Lruntime/reactive/Computed$ChangeEvent;", "lastValue", "Lruntime/reactive/ComputedExpression$ComputedValueState;", "value", "getValue", "()Ljava/lang/Object;", "compute", "Lkotlin/Pair;", "Lruntime/reactive/ComputedExpression$ComputedValueState$Computed;", "Llibraries/collections/MutableSetLike;", "Lruntime/reactive/Property;", "Lruntime/reactive/CellTrackerDependency;", "prevValue", "computeExpression", "expressionLifetime", "Llibraries/coroutines/extra/Lifetime;", "equals", "", "val1", "val2", "(Ljava/lang/Object;Ljava/lang/Object;)Z", "forEach", "", "lifetime", "sink", "Lkotlin/Function1;", "forEachChange", "handler", "getNewExpressionLifetime", "Llibraries/coroutines/extra/LifetimeSource;", "hasTracker", "invalidate", "isNeedToBeRecomputed", "currentValue", "isRecomputingDisabled", "logInvalidate", "froOrTo", "", "markAsPossiblyStale", "cachedRecord", "dependency", "markAsStale", "newTrackingLifetime", "swapOldValueWithNewOne", "newValue", "newDependencies", "trackDependencies", "dependencies", "trackOldValueAgain", "tryInvalidate", "updateStateIfNotTracked", "currentDependencies", "ComputedValueState", "platform-ui"})
public abstract class ComputedExpression<T>
implements Computed<T> {
    @NotNull
    private final Function2<XTrackableLifetimed, Maybe<? extends T>, T> expression;
    @NotNull
    private ComputedValueState<? extends T> lastValue;
    @NotNull
    private final Signal<Computed.ChangeEvent> changeEvents;

    public ComputedExpression(@NotNull Function2<? super XTrackableLifetimed, ? super Maybe<? extends T>, ? extends T> expression) {
        Intrinsics.checkNotNullParameter(expression, (String)"expression");
        this.expression = expression;
        this.lastValue = ComputedValueState.None.INSTANCE;
        this.changeEvents = Signal.Companion.create();
    }

    @Override
    public void forEachChange(@NotNull Lifetime lifetime, @NotNull Function1<? super Computed.ChangeEvent, Unit> handler) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        this.changeEvents.forEach(lifetime, handler);
    }

    @Override
    public T getValue() {
        DevCellTrackerChecks this_$iv = DevCellTrackerChecks.INSTANCE;
        boolean $i$f$suspendRenderInProcessChecks = false;
        boolean bl = false;
        return this.invalidate().getValue();
    }

    @Override
    public void forEach(@NotNull Lifetime lifetime, @NotNull Function1<? super T, Unit> sink2) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter(sink2, (String)"sink");
        Function1 effect2 = (Function1)new Function1<XTrackableLifetimed, Unit>(sink2, this){
            final /* synthetic */ Function1<T, Unit> $sink;
            final /* synthetic */ ComputedExpression<T> this$0;
            {
                this.$sink = $sink;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull XTrackableLifetimed xTrackableLifetimed) {
                Intrinsics.checkNotNullParameter((Object)xTrackableLifetimed, (String)"<this>");
                this.$sink.invoke(xTrackableLifetimed.getLive((Property)this.this$0));
            }
        };
        DebugKt.assignDbgName(effect2, DebugCommonKt.getDbgName(sink2));
        ReactionsKt.effect(lifetime, effect2);
    }

    public final boolean tryInvalidate() {
        ComputedValueState<? extends T> prevCacheRecord = this.lastValue;
        ComputedValueState.Computed<T> newCacheRecord = this.invalidate();
        return !Intrinsics.areEqual(prevCacheRecord, newCacheRecord);
    }

    public abstract boolean hasTracker();

    protected abstract boolean isRecomputingDisabled();

    private final boolean equals(T val1, T val2) {
        return Intrinsics.areEqual(val1, val2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final ComputedValueState.Computed<T> invalidate() {
        ComputedValueState.Computed computed2;
        String string2;
        String string3 = DebugCommonKt.getDbgName(this);
        if (string3 == null) {
            string2 = null;
        } else {
            String it = string3;
            boolean bl = false;
            string2 = "Computed(" + it + "): invalidate";
        }
        String label$iv = string2;
        boolean collapsed$iv = true;
        boolean $i$f$logGroup = false;
        if (label$iv != null) {
            GroupsKt.logGroupStart(label$iv, collapsed$iv);
        }
        try {
            String dbgName$iv;
            Object it;
            Object object;
            Object object2;
            ComputedValueState computedValueState;
            boolean bl = false;
            ComputedValueState currentValue = this.lastValue;
            if (currentValue instanceof ComputedValueState.Computed) {
                if (this.isRecomputingDisabled()) {
                    void dbgName$iv2;
                    computedValueState = currentValue;
                    ComputedValueState.Computed it2 = (ComputedValueState.Computed)computedValueState;
                    boolean bl2 = false;
                    object2 = ComputedKt.access$getLog$p();
                    String string4 = DebugCommonKt.getDbgName(this);
                    Function2 msg$iv = (Function2)new Function2<RichLogRecord, String, Unit>(currentValue){
                        final /* synthetic */ ComputedValueState<T> $currentValue;
                        {
                            this.$currentValue = $currentValue;
                            super(2);
                        }

                        public final void invoke(@NotNull RichLogRecord $this$richDebug, @NotNull String it) {
                            Intrinsics.checkNotNullParameter((Object)$this$richDebug, (String)"$this$richDebug");
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            $this$richDebug.unaryPlus("recomputing disabled:");
                            $this$richDebug.unaryPlus(((ComputedValueState.Computed)this.$currentValue).getValue());
                        }
                    };
                    boolean $i$f$richDebug = false;
                    if (dbgName$iv2 != null) {
                        void $this$richDebug$iv;
                        void this_$iv$iv = $this$richDebug$iv;
                        boolean $i$f$debug = false;
                        if (this_$iv$iv.isDebugEnabled()) {
                            void var16_34 = this_$iv$iv;
                            boolean bl3 = false;
                            var16_34.debug(RichLogRecordKt.richLog((Function1<? super RichLogRecord, Unit>)((Function1)new Function1<RichLogRecord, Unit>(msg$iv, (String)dbgName$iv2){
                                final /* synthetic */ Function2 $msg;
                                final /* synthetic */ String $dbgName;
                                {
                                    this.$msg = $msg;
                                    this.$dbgName = $dbgName;
                                    super(1);
                                }

                                public final void invoke(@NotNull RichLogRecord $this$richLog) {
                                    Intrinsics.checkNotNullParameter((Object)$this$richLog, (String)"$this$richLog");
                                    this.$msg.invoke((Object)$this$richLog, (Object)this.$dbgName);
                                }
                            })));
                        }
                    }
                    object = (ComputedValueState.Computed)computedValueState;
                } else {
                    Object it3;
                    computedValueState = this.isNeedToBeRecomputed((ComputedValueState.Computed)currentValue);
                    boolean needsToBeRecomputed = (Boolean)computedValueState.component1();
                    MutableSetLike currentDependencies = (MutableSetLike)computedValueState.component2();
                    if (needsToBeRecomputed) {
                        object2 = this.compute(new Maybe.Just(((ComputedValueState.Computed)currentValue).getValue()));
                        ComputedValueState.Computed newValue = (ComputedValueState.Computed)object2.component1();
                        MutableSetLike newDependencies = (MutableSetLike)object2.component2();
                        if (!this.equals(newValue.getValue(), ((ComputedValueState.Computed)currentValue).getValue())) {
                            void dbgName$iv3;
                            this.swapOldValueWithNewOne((ComputedValueState.Computed)currentValue, newValue, newDependencies);
                            this.changeEvents.fire(Computed.ChangeEvent.ChangeVerified);
                            ComputedValueState.Computed $i$f$richDebug = newValue;
                            it3 = $i$f$richDebug;
                            boolean bl4 = false;
                            KLogger kLogger = ComputedKt.access$getLog$p();
                            String bl3 = DebugCommonKt.getDbgName(this);
                            Function2 msg$iv = (Function2)new Function2<RichLogRecord, String, Unit>(newValue){
                                final /* synthetic */ ComputedValueState.Computed<T> $newValue;
                                {
                                    this.$newValue = $newValue;
                                    super(2);
                                }

                                public final void invoke(@NotNull RichLogRecord $this$richDebug, @NotNull String it) {
                                    Intrinsics.checkNotNullParameter((Object)$this$richDebug, (String)"$this$richDebug");
                                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                    $this$richDebug.unaryPlus("new value:");
                                    $this$richDebug.unaryPlus(this.$newValue.getValue());
                                }
                            };
                            boolean $i$f$richDebug2 = false;
                            if (dbgName$iv3 != null) {
                                void $this$richDebug$iv;
                                void this_$iv$iv = $this$richDebug$iv;
                                boolean $i$f$debug = false;
                                if (this_$iv$iv.isDebugEnabled()) {
                                    void var22_58 = this_$iv$iv;
                                    boolean bl5 = false;
                                    var22_58.debug(RichLogRecordKt.richLog((Function1<? super RichLogRecord, Unit>)((Function1)new Function1<RichLogRecord, Unit>(msg$iv, (String)dbgName$iv3){
                                        final /* synthetic */ Function2 $msg;
                                        final /* synthetic */ String $dbgName;
                                        {
                                            this.$msg = $msg;
                                            this.$dbgName = $dbgName;
                                            super(1);
                                        }

                                        public final void invoke(@NotNull RichLogRecord $this$richLog) {
                                            Intrinsics.checkNotNullParameter((Object)$this$richLog, (String)"$this$richLog");
                                            this.$msg.invoke((Object)$this$richLog, (Object)this.$dbgName);
                                        }
                                    })));
                                }
                            }
                            object = $i$f$richDebug;
                        } else {
                            this.swapOldValueWithNewOne((ComputedValueState.Computed)currentValue, newValue, newDependencies);
                            ComputedValueState.Computed $i$f$richDebug = newValue;
                            it3 = $i$f$richDebug;
                            boolean bl6 = false;
                            KLogger $this$richDebug$iv = ComputedKt.access$getLog$p();
                            String dbgName$iv3 = DebugCommonKt.getDbgName(this);
                            Function2 msg$iv = (Function2)new Function2<RichLogRecord, String, Unit>(currentValue, newValue){
                                final /* synthetic */ ComputedValueState<T> $currentValue;
                                final /* synthetic */ ComputedValueState.Computed<T> $newValue;
                                {
                                    this.$currentValue = $currentValue;
                                    this.$newValue = $newValue;
                                    super(2);
                                }

                                public final void invoke(@NotNull RichLogRecord $this$richDebug, @NotNull String it) {
                                    Intrinsics.checkNotNullParameter((Object)$this$richDebug, (String)"$this$richDebug");
                                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                    $this$richDebug.unaryPlus("new value equals to old:");
                                    $this$richDebug.unaryPlus("\nold value:");
                                    $this$richDebug.unaryPlus(((ComputedValueState.Computed)this.$currentValue).getValue());
                                    $this$richDebug.unaryPlus("\nnew value:");
                                    $this$richDebug.unaryPlus(this.$newValue.getValue());
                                }
                            };
                            boolean $i$f$richDebug3 = false;
                            if (dbgName$iv3 != null) {
                                KLogger this_$iv$iv = $this$richDebug$iv;
                                boolean $i$f$debug = false;
                                if (this_$iv$iv.isDebugEnabled()) {
                                    KLogger kLogger = this_$iv$iv;
                                    boolean bl7 = false;
                                    kLogger.debug(RichLogRecordKt.richLog((Function1<? super RichLogRecord, Unit>)((Function1)new Function1<RichLogRecord, Unit>(msg$iv, dbgName$iv3){
                                        final /* synthetic */ Function2 $msg;
                                        final /* synthetic */ String $dbgName;
                                        {
                                            this.$msg = $msg;
                                            this.$dbgName = $dbgName;
                                            super(1);
                                        }

                                        public final void invoke(@NotNull RichLogRecord $this$richLog) {
                                            Intrinsics.checkNotNullParameter((Object)$this$richLog, (String)"$this$richLog");
                                            this.$msg.invoke((Object)$this$richLog, (Object)this.$dbgName);
                                        }
                                    })));
                                }
                            }
                            object = $i$f$richDebug;
                        }
                    } else {
                        this.updateStateIfNotTracked((ComputedValueState.Computed)currentValue, currentDependencies);
                        object2 = currentValue;
                        it = (ComputedValueState.Computed)object2;
                        boolean bl8 = false;
                        KLogger $i$f$richDebug = ComputedKt.access$getLog$p();
                        it3 = DebugCommonKt.getDbgName(this);
                        Function2 msg$iv = (Function2)new Function2<RichLogRecord, String, Unit>(currentValue){
                            final /* synthetic */ ComputedValueState<T> $currentValue;
                            {
                                this.$currentValue = $currentValue;
                                super(2);
                            }

                            public final void invoke(@NotNull RichLogRecord $this$richDebug, @NotNull String it) {
                                Intrinsics.checkNotNullParameter((Object)$this$richDebug, (String)"$this$richDebug");
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                $this$richDebug.unaryPlus("recalculation isn't needed:");
                                $this$richDebug.unaryPlus(((ComputedValueState.Computed)this.$currentValue).getValue());
                            }
                        };
                        boolean $i$f$richDebug4 = false;
                        if (dbgName$iv != null) {
                            void $this$richDebug$iv;
                            void this_$iv$iv = $this$richDebug$iv;
                            boolean $i$f$debug = false;
                            if (this_$iv$iv.isDebugEnabled()) {
                                void var19_50 = this_$iv$iv;
                                boolean bl9 = false;
                                var19_50.debug(RichLogRecordKt.richLog((Function1<? super RichLogRecord, Unit>)((Function1)new Function1<RichLogRecord, Unit>(msg$iv, dbgName$iv){
                                    final /* synthetic */ Function2 $msg;
                                    final /* synthetic */ String $dbgName;
                                    {
                                        this.$msg = $msg;
                                        this.$dbgName = $dbgName;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull RichLogRecord $this$richLog) {
                                        Intrinsics.checkNotNullParameter((Object)$this$richLog, (String)"$this$richLog");
                                        this.$msg.invoke((Object)$this$richLog, (Object)this.$dbgName);
                                    }
                                })));
                            }
                        }
                        object = (ComputedValueState.Computed)object2;
                    }
                }
            } else if (Intrinsics.areEqual((Object)currentValue, (Object)ComputedValueState.None.INSTANCE)) {
                computedValueState = this.compute(Maybe.None.INSTANCE);
                ComputedValueState.Computed newValue = (ComputedValueState.Computed)computedValueState.component1();
                MutableSetLike dependencies = (MutableSetLike)computedValueState.component2();
                this.trackDependencies(newValue, dependencies);
                this.lastValue = newValue;
                it = object2 = newValue;
                boolean bl10 = false;
                KLogger $this$richDebug$iv = ComputedKt.access$getLog$p();
                dbgName$iv = DebugCommonKt.getDbgName(this);
                Function2 msg$iv = (Function2)new Function2<RichLogRecord, String, Unit>(newValue){
                    final /* synthetic */ ComputedValueState.Computed<T> $newValue;
                    {
                        this.$newValue = $newValue;
                        super(2);
                    }

                    public final void invoke(@NotNull RichLogRecord $this$richDebug, @NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)$this$richDebug, (String)"$this$richDebug");
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        $this$richDebug.unaryPlus("calculated first time:");
                        $this$richDebug.unaryPlus(this.$newValue.getValue());
                    }
                };
                boolean $i$f$richDebug = false;
                if (dbgName$iv != null) {
                    KLogger this_$iv$iv = $this$richDebug$iv;
                    boolean $i$f$debug = false;
                    if (this_$iv$iv.isDebugEnabled()) {
                        KLogger kLogger = this_$iv$iv;
                        boolean bl11 = false;
                        kLogger.debug(RichLogRecordKt.richLog((Function1<? super RichLogRecord, Unit>)((Function1)new Function1<RichLogRecord, Unit>(msg$iv, dbgName$iv){
                            final /* synthetic */ Function2 $msg;
                            final /* synthetic */ String $dbgName;
                            {
                                this.$msg = $msg;
                                this.$dbgName = $dbgName;
                                super(1);
                            }

                            public final void invoke(@NotNull RichLogRecord $this$richLog) {
                                Intrinsics.checkNotNullParameter((Object)$this$richLog, (String)"$this$richLog");
                                this.$msg.invoke((Object)$this$richLog, (Object)this.$dbgName);
                            }
                        })));
                    }
                }
                object = object2;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            computed2 = object;
        }
        finally {
            if (label$iv != null) {
                GroupsKt.logGroupEnd(label$iv);
            }
        }
        return computed2;
    }

    private final void updateStateIfNotTracked(ComputedValueState.Computed<T> currentValue, MutableSetLike<Property<?>> currentDependencies) {
        if (this.hasTracker()) {
            currentValue.setDependenciesState(DependenciesState.Tracked.UpToDate.INSTANCE);
        } else if (!(currentValue.getDependenciesState() instanceof DependenciesState.NotTracked) || currentDependencies != null) {
            currentValue.setDependenciesState(new DependenciesState.NotTracked(currentDependencies));
        }
    }

    private final void trackOldValueAgain(ComputedValueState.Computed<T> currentValue, MutableSetLike<Property<?>> newDependencies) {
        if (this.hasTracker()) {
            if (Intrinsics.areEqual((Object)currentValue.getDependenciesState(), (Object)DependenciesState.Tracked.Stale.INSTANCE) || currentValue.getDependenciesState() instanceof DependenciesState.NotTracked) {
                this.trackDependencies(currentValue, newDependencies);
            } else {
                currentValue.setDependenciesState(DependenciesState.Tracked.UpToDate.INSTANCE);
            }
        } else {
            currentValue.setDependenciesState(new DependenciesState.NotTracked(newDependencies));
        }
    }

    private final void swapOldValueWithNewOne(ComputedValueState.Computed<T> currentValue, ComputedValueState.Computed<T> newValue, MutableSetLike<Property<?>> newDependencies) {
        DebugKt.assignDbgName(currentValue.getLifetime(), null);
        currentValue.getLifetime().terminate();
        DebugCommonKt.assignDbgName(newValue.getLifetime(), this, "expressionLifetime");
        if (this.hasTracker()) {
            this.trackDependencies(newValue, newDependencies);
        }
        this.lastValue = newValue;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<Boolean, MutableSetLike<Property<?>>> isNeedToBeRecomputed(ComputedValueState.Computed<T> currentValue) {
        Pair pair;
        DependenciesState dependenciesState = currentValue.getDependenciesState();
        if (Intrinsics.areEqual((Object)dependenciesState, (Object)DependenciesState.Tracked.UpToDate.INSTANCE)) {
            pair = TuplesKt.to((Object)false, null);
        } else if (dependenciesState instanceof DependenciesState.NotTracked) {
            List list2;
            MutableSetLike<Property<?>> mutableSetLike = ((DependenciesState.NotTracked)dependenciesState).getDependencies();
            if (mutableSetLike == null) {
                list2 = null;
            } else {
                List<Property<?>> list3 = mutableSetLike.toList();
                if (list3 == null) {
                    list2 = null;
                } else {
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv = list3;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        Property property2 = (Property)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(it.getValue());
                    }
                    list2 = (List)destination$iv$iv;
                }
            }
            List newDependenciesValues = list2;
            boolean areDependenciesChanged = ((DependenciesState.NotTracked)dependenciesState).getDependenciesValues() == null || Intrinsics.areEqual(((DependenciesState.NotTracked)dependenciesState).getDependenciesValues(), newDependenciesValues);
            pair = TuplesKt.to((Object)areDependenciesChanged, ((DependenciesState.NotTracked)dependenciesState).getDependencies());
        } else if (Intrinsics.areEqual((Object)dependenciesState, (Object)DependenciesState.Tracked.Stale.INSTANCE)) {
            pair = TuplesKt.to((Object)true, null);
        } else if (dependenciesState instanceof DependenciesState.Tracked.PossiblyStale) {
            boolean dependenciesInvalidated2 = ((DependenciesState.Tracked.PossiblyStale)dependenciesState).getDependenciesMightHaveChanged().any(isNeedToBeRecomputed.dependenciesInvalidated.1.INSTANCE);
            boolean becameStale = Intrinsics.areEqual((Object)currentValue.getDependenciesState(), (Object)DependenciesState.Tracked.Stale.INSTANCE);
            pair = TuplesKt.to((Object)(dependenciesInvalidated2 || becameStale ? 1 : 0), null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return pair;
    }

    /*
     * WARNING - void declaration
     */
    private final void logInvalidate(String froOrTo) {
        void dbgName$iv;
        KLogger kLogger = ComputedKt.access$getLog$p();
        String string2 = DebugCommonKt.getDbgName(this);
        Function2 msg$iv = (Function2)new Function2<RichLogRecord, String, Unit>(froOrTo, this){
            final /* synthetic */ String $froOrTo;
            final /* synthetic */ ComputedExpression<T> this$0;
            {
                this.$froOrTo = $froOrTo;
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull RichLogRecord $this$richDebug, @NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)$this$richDebug, (String)"$this$richDebug");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                $this$richDebug.unaryPlus("Computed(" + it + "): invalidate " + this.$froOrTo);
                $this$richDebug.unaryPlus(ComputedExpression.access$getLastValue$p(this.this$0));
            }
        };
        boolean $i$f$richDebug = false;
        if (dbgName$iv != null) {
            void $this$richDebug$iv;
            void this_$iv$iv = $this$richDebug$iv;
            boolean $i$f$debug = false;
            if (this_$iv$iv.isDebugEnabled()) {
                void var8_8 = this_$iv$iv;
                boolean bl = false;
                var8_8.debug(RichLogRecordKt.richLog((Function1<? super RichLogRecord, Unit>)((Function1)new Function1<RichLogRecord, Unit>(msg$iv, (String)dbgName$iv){
                    final /* synthetic */ Function2 $msg;
                    final /* synthetic */ String $dbgName;
                    {
                        this.$msg = $msg;
                        this.$dbgName = $dbgName;
                        super(1);
                    }

                    public final void invoke(@NotNull RichLogRecord $this$richLog) {
                        Intrinsics.checkNotNullParameter((Object)$this$richLog, (String)"$this$richLog");
                        this.$msg.invoke((Object)$this$richLog, (Object)this.$dbgName);
                    }
                })));
            }
        }
    }

    @NotNull
    protected abstract LifetimeSource getNewExpressionLifetime();

    private final Pair<ComputedValueState.Computed<T>, MutableSetLike<Property<?>>> compute(Maybe<? extends T> prevValue) {
        Pair<? extends T, MutableSetLike<Property<?>>> pair;
        LifetimeSource newExpressionLifetime = this.getNewExpressionLifetime();
        try {
            pair = this.computeExpression(newExpressionLifetime, prevValue);
        }
        catch (Throwable e) {
            newExpressionLifetime.terminate();
            throw e;
        }
        Pair<? extends T, MutableSetLike<Property<?>>> pair2 = pair;
        Object result2 = pair2.component1();
        MutableSetLike dependencies = (MutableSetLike)pair2.component2();
        ComputedValueState.Computed computedValue = new ComputedValueState.Computed(result2, newExpressionLifetime, null, 4, null);
        return TuplesKt.to(computedValue, (Object)dependencies);
    }

    @Nullable
    protected abstract LifetimeSource newTrackingLifetime(@NotNull ComputedValueState.Computed<?> var1);

    private final void trackDependencies(ComputedValueState.Computed<T> cachedRecord, MutableSetLike<Property<?>> dependencies) {
        LifetimeSource trackingLifetime = this.newTrackingLifetime(cachedRecord);
        if (trackingLifetime != null && !trackingLifetime.isTerminated()) {
            cachedRecord.setDependenciesState(DependenciesState.Tracked.UpToDate.INSTANCE);
            cachedRecord.getLifetime().add((Function0<Unit>)((Function0)new Function0<Unit>(cachedRecord, this, dependencies){
                final /* synthetic */ ComputedValueState.Computed<T> $cachedRecord;
                final /* synthetic */ ComputedExpression<T> this$0;
                final /* synthetic */ MutableSetLike<Property<?>> $dependencies;
                {
                    this.$cachedRecord = $cachedRecord;
                    this.this$0 = $receiver;
                    this.$dependencies = $dependencies;
                    super(0);
                }

                public final void invoke() {
                    this.$cachedRecord.setDependenciesState(new DependenciesState.NotTracked(this.this$0.isRecomputingDisabled() ? (MutableSetLike<Property<?>>)null : this.$dependencies));
                }
            }));
            ComputedExpression $this$getDbgName$iv = this;
            boolean $i$f$getDbgName = false;
            ComputedKt.trackDependencies(trackingLifetime, dependencies, (Function1)new Function1<ComputedExpression<?>, Unit>(this, cachedRecord){
                final /* synthetic */ ComputedExpression<T> this$0;
                final /* synthetic */ ComputedValueState.Computed<T> $cachedRecord;
                {
                    this.this$0 = $receiver;
                    this.$cachedRecord = $cachedRecord;
                    super(1);
                }

                public final void invoke(@NotNull ComputedExpression<?> dependency) {
                    Intrinsics.checkNotNullParameter(dependency, (String)"dependency");
                    ComputedExpression.access$markAsPossiblyStale(this.this$0, this.$cachedRecord, dependency);
                }
            }, (Function1)new Function1<Property<?>, Unit>(this, cachedRecord){
                final /* synthetic */ ComputedExpression<T> this$0;
                final /* synthetic */ ComputedValueState.Computed<T> $cachedRecord;
                {
                    this.this$0 = $receiver;
                    this.$cachedRecord = $cachedRecord;
                    super(1);
                }

                public final void invoke(@NotNull Property<?> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    ComputedExpression.access$markAsStale(this.this$0, this.$cachedRecord);
                }
            }, null);
        } else {
            cachedRecord.setDependenciesState(new DependenciesState.NotTracked(dependencies));
        }
    }

    private final void markAsPossiblyStale(ComputedValueState.Computed<T> cachedRecord, ComputedExpression<?> dependency) {
        DependenciesState dependenciesState = cachedRecord.getDependenciesState();
        if (Intrinsics.areEqual((Object)dependenciesState, (Object)DependenciesState.Tracked.UpToDate.INSTANCE)) {
            DependenciesState.Tracked.PossiblyStale newDependenciesState = new DependenciesState.Tracked.PossiblyStale();
            cachedRecord.setDependenciesState(newDependenciesState);
            newDependenciesState.getDependenciesMightHaveChanged().add(dependency);
            this.changeEvents.fire(Computed.ChangeEvent.MaybeChanged);
        } else if (dependenciesState instanceof DependenciesState.Tracked.PossiblyStale) {
            ((DependenciesState.Tracked.PossiblyStale)dependenciesState).getDependenciesMightHaveChanged().add(dependency);
        }
    }

    private final void markAsStale(ComputedValueState.Computed<T> cachedRecord) {
        DependenciesState prevDependenciesState = cachedRecord.getDependenciesState();
        cachedRecord.setDependenciesState(DependenciesState.Tracked.Stale.INSTANCE);
        if (Intrinsics.areEqual((Object)prevDependenciesState, (Object)DependenciesState.Tracked.UpToDate.INSTANCE)) {
            this.changeEvents.fire(Computed.ChangeEvent.MaybeChanged);
        }
    }

    private final Pair<T, MutableSetLike<Property<?>>> computeExpression(Lifetime expressionLifetime, Maybe<? extends T> prevValue) {
        MutableSetLike dependencies = Collections.INSTANCE.fastSet();
        return TuplesKt.to(CellTracker.INSTANCE.frameAccess((Function1)new Function1<Property<?>, Unit>(dependencies){

            public final void invoke(@NotNull Property<?> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                ((MutableSetLike)this.receiver).add(p0);
            }
        }, (Function0)new Function0<T>(this, expressionLifetime, prevValue){
            final /* synthetic */ ComputedExpression<T> this$0;
            final /* synthetic */ Lifetime $expressionLifetime;
            final /* synthetic */ Maybe<T> $prevValue;
            {
                this.this$0 = $receiver;
                this.$expressionLifetime = $expressionLifetime;
                this.$prevValue = $prevValue;
                super(0);
            }

            public final T invoke() {
                return (T)ComputedExpression.access$getExpression$p(this.this$0).invoke((Object)PropertyLiveKt.XTrackableLifetimed(this.$expressionLifetime), this.$prevValue);
            }
        }), dependencies);
    }

    @Override
    public void forEachWithPrevious(@NotNull Lifetime lifetime, @NotNull Function2<? super T, ? super T, Unit> consume) {
        Computed.DefaultImpls.forEachWithPrevious(this, lifetime, consume);
    }

    public static final /* synthetic */ void access$markAsPossiblyStale(ComputedExpression $this, ComputedValueState.Computed cachedRecord, ComputedExpression dependency) {
        $this.markAsPossiblyStale(cachedRecord, dependency);
    }

    public static final /* synthetic */ void access$markAsStale(ComputedExpression $this, ComputedValueState.Computed cachedRecord) {
        $this.markAsStale(cachedRecord);
    }

    public static final /* synthetic */ Function2 access$getExpression$p(ComputedExpression $this) {
        return $this.expression;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b4\u0018\u0000*\u0006\b\u0001\u0010\u0001 \u00012\u00020\u0002:\u0002\u0004\u0005B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0003\u0082\u0001\u0002\u0006\u0007\u00a8\u0006\b"}, d2={"Lruntime/reactive/ComputedExpression$ComputedValueState;", "T", "Llibraries/klogging/RichLoggable;", "()V", "Computed", "None", "Lruntime/reactive/ComputedExpression$ComputedValueState$None;", "Lruntime/reactive/ComputedExpression$ComputedValueState$Computed;", "platform-ui"})
    protected static abstract class ComputedValueState<T>
    implements RichLoggable {
        private ComputedValueState() {
        }

        @Override
        public void richLog(@NotNull RichLogRecord $this$richLog) {
            RichLoggable.DefaultImpls.richLog(this, $this$richLog);
        }

        public /* synthetic */ ComputedValueState(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lruntime/reactive/ComputedExpression$ComputedValueState$None;", "Lruntime/reactive/ComputedExpression$ComputedValueState;", "", "()V", "toString", "", "platform-ui"})
        public static final class None
        extends ComputedValueState {
            @NotNull
            public static final None INSTANCE = new None();

            private None() {
                super(null);
            }

            @NotNull
            public String toString() {
                return "ComputedValueState.None";
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u0004\b\u0002\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00028\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0096\u0002J\f\u0010\u0016\u001a\u00020\u0017*\u00020\u0018H\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0003\u001a\u00028\u0002\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0019"}, d2={"Lruntime/reactive/ComputedExpression$ComputedValueState$Computed;", "T", "Lruntime/reactive/ComputedExpression$ComputedValueState;", "value", "lifetime", "Llibraries/coroutines/extra/LifetimeSource;", "dependenciesState", "Lruntime/reactive/DependenciesState;", "(Ljava/lang/Object;Llibraries/coroutines/extra/LifetimeSource;Lruntime/reactive/DependenciesState;)V", "getDependenciesState", "()Lruntime/reactive/DependenciesState;", "setDependenciesState", "(Lruntime/reactive/DependenciesState;)V", "getLifetime", "()Llibraries/coroutines/extra/LifetimeSource;", "getValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "equals", "", "other", "", "richLog", "", "Llibraries/klogging/RichLogRecord;", "platform-ui"})
        public static final class Computed<T>
        extends ComputedValueState<T> {
            private final T value;
            @NotNull
            private final LifetimeSource lifetime;
            @NotNull
            private DependenciesState dependenciesState;

            public Computed(T value2, @NotNull LifetimeSource lifetime, @NotNull DependenciesState dependenciesState) {
                Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
                Intrinsics.checkNotNullParameter((Object)dependenciesState, (String)"dependenciesState");
                super(null);
                this.value = value2;
                this.lifetime = lifetime;
                this.dependenciesState = dependenciesState;
            }

            public /* synthetic */ Computed(Object object, LifetimeSource lifetimeSource, DependenciesState dependenciesState, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 4) != 0) {
                    dependenciesState = new DependenciesState.NotTracked(null, 1, null);
                }
                this(object, lifetimeSource, dependenciesState);
            }

            public final T getValue() {
                return this.value;
            }

            @NotNull
            public final LifetimeSource getLifetime() {
                return this.lifetime;
            }

            @NotNull
            public final DependenciesState getDependenciesState() {
                return this.dependenciesState;
            }

            public final void setDependenciesState(@NotNull DependenciesState dependenciesState) {
                Intrinsics.checkNotNullParameter((Object)dependenciesState, (String)"<set-?>");
                this.dependenciesState = dependenciesState;
            }

            @Override
            public void richLog(@NotNull RichLogRecord $this$richLog) {
                Intrinsics.checkNotNullParameter((Object)$this$richLog, (String)"<this>");
                $this$richLog.unaryPlus("ComputedValueState.Computed( value =");
                T t = this.value;
                if (t != null) {
                    T $this$getDbgName$iv = t;
                    boolean $i$f$getDbgName = false;
                }
                $this$richLog.unaryPlus(this.value);
                $this$richLog.unaryPlus(", dependenciesState =");
                $this$richLog.unaryPlus(this.dependenciesState);
                $this$richLog.unaryPlus(")");
            }

            public boolean equals(@Nullable Object other) {
                return other instanceof Computed && Intrinsics.areEqual(((Computed)other).value, this.value);
            }
        }
    }
}

