/*
 * Decompiled with CFR 0.152.
 */
package runtime.reactive;

import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import libraries.basics.DebugCommonKt;
import libraries.coroutines.extra.Lifetime;
import libraries.coroutines.extra.LifetimeSource;
import libraries.coroutines.extra.LifetimeUtilsKt;
import org.jetbrains.annotations.NotNull;
import runtime.reactive.ComputedExpression;
import runtime.reactive.Maybe;
import runtime.reactive.XTrackableLifetimed;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B2\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012#\u0010\u0005\u001a\u001f\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\b\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0014J\u0014\u0010\u0010\u001a\u00020\f2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lruntime/reactive/LifetimedComputedExpression;", "T", "Lruntime/reactive/ComputedExpression;", "parentLifetime", "Llibraries/coroutines/extra/Lifetime;", "expression", "Lkotlin/Function2;", "Lruntime/reactive/XTrackableLifetimed;", "Lruntime/reactive/Maybe;", "Lkotlin/ExtensionFunctionType;", "(Llibraries/coroutines/extra/Lifetime;Lkotlin/jvm/functions/Function2;)V", "getNewExpressionLifetime", "Llibraries/coroutines/extra/LifetimeSource;", "hasTracker", "", "isRecomputingDisabled", "newTrackingLifetime", "cachedRecord", "Lruntime/reactive/ComputedExpression$ComputedValueState$Computed;", "platform-ui"})
public final class LifetimedComputedExpression<T>
extends ComputedExpression<T> {
    @NotNull
    private final Lifetime parentLifetime;

    public LifetimedComputedExpression(@NotNull Lifetime parentLifetime, @NotNull Function2<? super XTrackableLifetimed, ? super Maybe<? extends T>, ? extends T> expression) {
        Intrinsics.checkNotNullParameter((Object)parentLifetime, (String)"parentLifetime");
        Intrinsics.checkNotNullParameter(expression, (String)"expression");
        super(expression);
        this.parentLifetime = parentLifetime;
    }

    @Override
    protected boolean isRecomputingDisabled() {
        return this.parentLifetime.isTerminated();
    }

    @Override
    @NotNull
    protected LifetimeSource getNewExpressionLifetime() {
        return LifetimeUtilsKt.nested(this.parentLifetime);
    }

    @Override
    @NotNull
    protected LifetimeSource newTrackingLifetime(@NotNull ComputedExpression.ComputedValueState.Computed<?> cachedRecord) {
        Intrinsics.checkNotNullParameter(cachedRecord, (String)"cachedRecord");
        return DebugCommonKt.assignDbgName(LifetimeUtilsKt.nestedOrTerminated(cachedRecord.getLifetime()), this, "trackingLifetime");
    }

    @Override
    public boolean hasTracker() {
        return !this.parentLifetime.isTerminated();
    }
}

