/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.integrations.scala;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.util.Order;
import java.util.Collections;
import java.util.Set;
import org.gradle.tooling.model.idea.IdeaModule;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.data.ScalaCompileOptionsData;
import org.jetbrains.plugins.gradle.model.data.ScalaModelData;
import org.jetbrains.plugins.gradle.model.scala.ScalaCompileOptions;
import org.jetbrains.plugins.gradle.model.scala.ScalaForkOptions;
import org.jetbrains.plugins.gradle.model.scala.ScalaModel;
import org.jetbrains.plugins.gradle.service.project.AbstractProjectResolverExtension;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Order(value=1000)
public class ScalaGradleProjectResolverExtension
extends AbstractProjectResolverExtension {
    private static final Logger LOG = Logger.getInstance(ScalaGradleProjectResolverExtension.class);

    public void populateModuleExtraModels(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule) {
        ScalaModel scalaModel;
        if (gradleModule == null) {
            ScalaGradleProjectResolverExtension.$$$reportNull$$$0(0);
        }
        if (ideModule == null) {
            ScalaGradleProjectResolverExtension.$$$reportNull$$$0(1);
        }
        if ((scalaModel = (ScalaModel)this.resolverCtx.getExtraProject(gradleModule, ScalaModel.class)) != null) {
            ScalaModelData scalaModelData = ScalaGradleProjectResolverExtension.create(scalaModel);
            ideModule.createChild(ScalaModelData.KEY, (Object)scalaModelData);
        }
        this.nextResolver.populateModuleExtraModels(gradleModule, ideModule);
    }

    @NotNull
    public Set<Class<?>> getExtraProjectModelClasses() {
        Set<Class<?>> set = Collections.singleton(ScalaModel.class);
        if (set == null) {
            ScalaGradleProjectResolverExtension.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    private static ScalaModelData create(@NotNull ScalaModel scalaModel) {
        if (scalaModel == null) {
            ScalaGradleProjectResolverExtension.$$$reportNull$$$0(3);
        }
        ScalaModelData scalaModelData = new ScalaModelData(GradleConstants.SYSTEM_ID);
        scalaModelData.setZincClasspath(scalaModel.getZincClasspath());
        scalaModelData.setScalaClasspath(scalaModel.getScalaClasspath());
        scalaModelData.setScalaCompileOptions(ScalaGradleProjectResolverExtension.create(scalaModel.getScalaCompileOptions()));
        scalaModelData.setSourceCompatibility(scalaModel.getSourceCompatibility());
        scalaModelData.setTargetCompatibility(scalaModel.getTargetCompatibility());
        ScalaModelData scalaModelData2 = scalaModelData;
        if (scalaModelData2 == null) {
            ScalaGradleProjectResolverExtension.$$$reportNull$$$0(4);
        }
        return scalaModelData2;
    }

    @Nullable
    @Contract(value="null -> null")
    private static ScalaCompileOptionsData create(@Nullable ScalaCompileOptions options) {
        if (options == null) {
            return null;
        }
        ScalaCompileOptionsData result = new ScalaCompileOptionsData();
        result.setAdditionalParameters(options.getAdditionalParameters());
        result.setDaemonServer(options.getDaemonServer());
        result.setDebugLevel(options.getDebugLevel());
        result.setDeprecation(options.isDeprecation());
        result.setEncoding(options.getEncoding());
        result.setFailOnError(options.isFailOnError());
        result.setForce(options.getForce());
        result.setFork(options.isFork());
        result.setListFiles(options.isListFiles());
        result.setLoggingLevel(options.getLoggingLevel());
        result.setDebugLevel(options.getDebugLevel());
        result.setLoggingPhases(options.getLoggingPhases());
        result.setOptimize(options.isOptimize());
        result.setUnchecked(options.isUnchecked());
        result.setUseAnt(options.isUseAnt());
        result.setUseCompileDaemon(options.isUseCompileDaemon());
        result.setForkOptions(ScalaGradleProjectResolverExtension.create(options.getForkOptions()));
        return result;
    }

    @Nullable
    @Contract(value="null -> null")
    private static ScalaCompileOptionsData.ScalaForkOptions create(@Nullable ScalaForkOptions options) {
        if (options == null) {
            return null;
        }
        ScalaCompileOptionsData.ScalaForkOptions result = new ScalaCompileOptionsData.ScalaForkOptions();
        result.setJvmArgs(options.getJvmArgs());
        result.setMemoryInitialSize(options.getMemoryInitialSize());
        result.setMemoryMaximumSize(options.getMemoryMaximumSize());
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleModule";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideModule";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/integrations/scala/ScalaGradleProjectResolverExtension";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scalaModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/integrations/scala/ScalaGradleProjectResolverExtension";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtraProjectModelClasses";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "populateModuleExtraModels";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

