/*
 * Decompiled with CFR 0.152.
 */
package git4idea.checkin;

import com.intellij.CommonBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.VcsCheckinHandlerFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PairConsumer;
import com.intellij.util.ui.UIUtil;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.checkin.GitCommitAndPushExecutor;
import git4idea.checkin.GitUserNameNotDefinedDialog;
import git4idea.commands.Git;
import git4idea.config.GitConfigUtil;
import git4idea.config.GitExecutableManager;
import git4idea.config.GitVcsSettings;
import git4idea.config.GitVersion;
import git4idea.config.GitVersionSpecialty;
import git4idea.crlf.GitCrlfDialog;
import git4idea.crlf.GitCrlfProblemsDetector;
import git4idea.crlf.GitCrlfUtil;
import git4idea.i18n.GitBundle;
import git4idea.rebase.GitRebaseUtils;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitCheckinHandlerFactory
extends VcsCheckinHandlerFactory {
    private static final Logger LOG = Logger.getInstance(GitCheckinHandlerFactory.class);

    public GitCheckinHandlerFactory() {
        super(GitVcs.getKey());
    }

    @NotNull
    protected CheckinHandler createVcsHandler(@NotNull CheckinProjectPanel panel2, @NotNull CommitContext commitContext) {
        if (panel2 == null) {
            GitCheckinHandlerFactory.$$$reportNull$$$0(0);
        }
        if (commitContext == null) {
            GitCheckinHandlerFactory.$$$reportNull$$$0(1);
        }
        return new MyCheckinHandler(panel2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "panel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "commitContext";
                break;
            }
        }
        objectArray[1] = "git4idea/checkin/GitCheckinHandlerFactory";
        objectArray[2] = "createVcsHandler";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyCheckinHandler
    extends CheckinHandler {
        @NotNull
        private final CheckinProjectPanel myPanel;
        @NotNull
        private final Project myProject;

        MyCheckinHandler(@NotNull CheckinProjectPanel panel2) {
            if (panel2 == null) {
                MyCheckinHandler.$$$reportNull$$$0(0);
            }
            this.myPanel = panel2;
            this.myProject = this.myPanel.getProject();
        }

        public CheckinHandler.ReturnResult beforeCheckin(@Nullable CommitExecutor executor, PairConsumer<Object, Object> additionalDataConsumer) {
            if (this.emptyCommitMessage()) {
                return CheckinHandler.ReturnResult.CANCEL;
            }
            if (MyCheckinHandler.commitOrCommitAndPush(executor)) {
                CheckinHandler.ReturnResult result2 = this.checkGitVersionAndEnv();
                if (result2 != CheckinHandler.ReturnResult.COMMIT) {
                    return result2;
                }
                result2 = this.checkUserName();
                if (result2 != CheckinHandler.ReturnResult.COMMIT) {
                    return result2;
                }
                result2 = this.warnAboutCrlfIfNeeded();
                if (result2 != CheckinHandler.ReturnResult.COMMIT) {
                    return result2;
                }
                return this.warnAboutDetachedHeadIfNeeded();
            }
            return CheckinHandler.ReturnResult.COMMIT;
        }

        @NotNull
        private CheckinHandler.ReturnResult warnAboutCrlfIfNeeded() {
            GitVcsSettings settings = GitVcsSettings.getInstance(this.myProject);
            if (!settings.warnAboutCrlf()) {
                CheckinHandler.ReturnResult returnResult = CheckinHandler.ReturnResult.COMMIT;
                if (returnResult == null) {
                    MyCheckinHandler.$$$reportNull$$$0(1);
                }
                return returnResult;
            }
            final Git git = Git.getInstance();
            final Collection files = this.myPanel.getVirtualFiles();
            final AtomicReference crlfHelper = new AtomicReference();
            ProgressManager.getInstance().run((Task)new Task.Modal(this.myProject, GitBundle.message("progress.checking.line.separator.issues", new Object[0]), true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    crlfHelper.set(GitCrlfProblemsDetector.detect(myProject, git, files));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/checkin/GitCheckinHandlerFactory$MyCheckinHandler$1", "run"));
                }
            });
            if (crlfHelper.get() == null) {
                CheckinHandler.ReturnResult returnResult = CheckinHandler.ReturnResult.CANCEL;
                if (returnResult == null) {
                    MyCheckinHandler.$$$reportNull$$$0(2);
                }
                return returnResult;
            }
            if (((GitCrlfProblemsDetector)crlfHelper.get()).shouldWarn()) {
                Pair codeAndDontWarn = (Pair)UIUtil.invokeAndWaitIfNeeded(() -> {
                    GitCrlfDialog dialog2 = new GitCrlfDialog(this.myProject);
                    dialog2.show();
                    return Pair.create((Object)dialog2.getExitCode(), (Object)dialog2.dontWarnAgain());
                });
                int decision = (Integer)codeAndDontWarn.first;
                boolean dontWarnAgain = (Boolean)codeAndDontWarn.second;
                if (decision == 1) {
                    CheckinHandler.ReturnResult returnResult = CheckinHandler.ReturnResult.CANCEL;
                    if (returnResult == null) {
                        MyCheckinHandler.$$$reportNull$$$0(3);
                    }
                    return returnResult;
                }
                if (decision == 0) {
                    VirtualFile anyRoot = (VirtualFile)this.myPanel.getRoots().iterator().next();
                    this.setCoreAutoCrlfAttribute(anyRoot);
                } else if (dontWarnAgain) {
                    settings.setWarnAboutCrlf(false);
                }
                CheckinHandler.ReturnResult returnResult = CheckinHandler.ReturnResult.COMMIT;
                if (returnResult == null) {
                    MyCheckinHandler.$$$reportNull$$$0(4);
                }
                return returnResult;
            }
            CheckinHandler.ReturnResult returnResult = CheckinHandler.ReturnResult.COMMIT;
            if (returnResult == null) {
                MyCheckinHandler.$$$reportNull$$$0(5);
            }
            return returnResult;
        }

        private void setCoreAutoCrlfAttribute(final @NotNull VirtualFile aRoot) {
            if (aRoot == null) {
                MyCheckinHandler.$$$reportNull$$$0(6);
            }
            ProgressManager.getInstance().run((Task)new Task.Modal(this.myProject, GitBundle.message("progress.setting.config.value", new Object[0]), true){

                public void run(@NotNull ProgressIndicator pi) {
                    if (pi == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    try {
                        GitConfigUtil.setValue(this.myProject, aRoot, "core.autocrlf", GitCrlfUtil.RECOMMENDED_VALUE, "--global");
                    }
                    catch (VcsException e) {
                        LOG.warn("Couldn't globally set core.autocrlf in " + aRoot, (Throwable)e);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pi", "git4idea/checkin/GitCheckinHandlerFactory$MyCheckinHandler$2", "run"));
                }
            });
        }

        private CheckinHandler.ReturnResult checkGitVersionAndEnv() {
            GitVersion version = GitExecutableManager.getInstance().getVersionUnderModalProgressOrCancel(this.myProject);
            if (System.getenv("HOME") == null && GitVersionSpecialty.DOESNT_DEFINE_HOME_ENV_VAR.existsIn(version)) {
                Messages.showErrorDialog((Project)this.myProject, (String)GitBundle.message("error.message.git.version.does.not.define.home.env", version.getPresentation()), (String)GitBundle.message("error.title.git.version.does.not.define.home.env", new Object[0]));
                return CheckinHandler.ReturnResult.CANCEL;
            }
            return CheckinHandler.ReturnResult.COMMIT;
        }

        private CheckinHandler.ReturnResult checkUserName() {
            GitUserNameNotDefinedDialog dialog2;
            Project project = this.myPanel.getProject();
            GitVcs vcs = GitVcs.getInstance(project);
            Collection<VirtualFile> affectedRoots = this.getSelectedRoots();
            Map<VirtualFile, Couple<String>> defined = MyCheckinHandler.getDefinedUserNames(project, affectedRoots, false);
            ArrayList<VirtualFile> allRoots = new ArrayList<VirtualFile>(Arrays.asList(ProjectLevelVcsManager.getInstance((Project)project).getRootsUnderVcs((AbstractVcs)vcs)));
            ArrayList<VirtualFile> notDefined = new ArrayList<VirtualFile>(affectedRoots);
            notDefined.removeAll(defined.keySet());
            if (notDefined.isEmpty()) {
                return CheckinHandler.ReturnResult.COMMIT;
            }
            if (defined.isEmpty() && allRoots.size() > affectedRoots.size()) {
                allRoots.removeAll(affectedRoots);
                defined.putAll(MyCheckinHandler.getDefinedUserNames(project, allRoots, true));
            }
            if ((dialog2 = new GitUserNameNotDefinedDialog(project, notDefined, affectedRoots, defined)).showAndGet()) {
                GitVcsSettings.getInstance(project).setUserNameGlobally(dialog2.isGlobal());
                return this.setUserNameUnderProgress(project, notDefined, dialog2) ? CheckinHandler.ReturnResult.COMMIT : CheckinHandler.ReturnResult.CANCEL;
            }
            return CheckinHandler.ReturnResult.CLOSE_WINDOW;
        }

        @NotNull
        private static Map<VirtualFile, Couple<String>> getDefinedUserNames(final @NotNull Project project, final @NotNull Collection<? extends VirtualFile> roots, final boolean stopWhenFoundFirst) {
            if (project == null) {
                MyCheckinHandler.$$$reportNull$$$0(7);
            }
            if (roots == null) {
                MyCheckinHandler.$$$reportNull$$$0(8);
            }
            final HashMap<VirtualFile, Couple<String>> defined = new HashMap<VirtualFile, Couple<String>>();
            ProgressManager.getInstance().run((Task)new Task.Modal(project, GitBundle.message("progress.checking.user.name.email", new Object[0]), true){

                public void run(@NotNull ProgressIndicator pi) {
                    if (pi == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    for (VirtualFile root : roots) {
                        try {
                            Couple<String> nameAndEmail = MyCheckinHandler.getUserNameAndEmailFromGitConfig(project, root);
                            String name = (String)nameAndEmail.getFirst();
                            String email = (String)nameAndEmail.getSecond();
                            if (name == null || email == null) continue;
                            defined.put(root, nameAndEmail);
                            if (!stopWhenFoundFirst) continue;
                            return;
                        }
                        catch (VcsException e) {
                            LOG.error("Couldn't get user.name and user.email for root " + root, (Throwable)e);
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pi", "git4idea/checkin/GitCheckinHandlerFactory$MyCheckinHandler$3", "run"));
                }
            });
            HashMap<VirtualFile, Couple<String>> hashMap = defined;
            if (hashMap == null) {
                MyCheckinHandler.$$$reportNull$$$0(9);
            }
            return hashMap;
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        private boolean setUserNameUnderProgress(final @NotNull Project project, final @NotNull Collection<? extends VirtualFile> notDefined, final @NotNull GitUserNameNotDefinedDialog dialog2) {
            if (project == null) {
                MyCheckinHandler.$$$reportNull$$$0(10);
            }
            if (notDefined == null) {
                MyCheckinHandler.$$$reportNull$$$0(11);
            }
            if (dialog2 == null) {
                MyCheckinHandler.$$$reportNull$$$0(12);
            }
            final @Nls Ref error = Ref.create();
            ProgressManager.getInstance().run((Task)new Task.Modal(project, GitBundle.message("progress.setting.user.name.email", new Object[0]), true){

                public void run(@NotNull ProgressIndicator pi) {
                    if (pi == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    try {
                        if (dialog2.isGlobal()) {
                            GitConfigUtil.setValue(project, (VirtualFile)notDefined.iterator().next(), "user.name", dialog2.getUserName(), "--global");
                            GitConfigUtil.setValue(project, (VirtualFile)notDefined.iterator().next(), "user.email", dialog2.getUserEmail(), "--global");
                        } else {
                            for (VirtualFile root : notDefined) {
                                GitConfigUtil.setValue(project, root, "user.name", dialog2.getUserName(), new String[0]);
                                GitConfigUtil.setValue(project, root, "user.email", dialog2.getUserEmail(), new String[0]);
                            }
                        }
                    }
                    catch (VcsException e) {
                        LOG.error("Couldn't set user.name and user.email", (Throwable)e);
                        error.set((Object)GitBundle.message("error.cant.set.user.name.email", new Object[0]));
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pi", "git4idea/checkin/GitCheckinHandlerFactory$MyCheckinHandler$4", "run"));
                }
            });
            if (error.isNull()) {
                return true;
            }
            Messages.showErrorDialog((Component)this.myPanel.getComponent(), (String)((String)error.get()));
            return false;
        }

        @NotNull
        private static Couple<String> getUserNameAndEmailFromGitConfig(@NotNull Project project, @NotNull VirtualFile root) throws VcsException {
            if (project == null) {
                MyCheckinHandler.$$$reportNull$$$0(13);
            }
            if (root == null) {
                MyCheckinHandler.$$$reportNull$$$0(14);
            }
            String name = GitConfigUtil.getValue(project, root, "user.name");
            String email = GitConfigUtil.getValue(project, root, "user.email");
            Couple couple = Couple.of((Object)name, (Object)email);
            if (couple == null) {
                MyCheckinHandler.$$$reportNull$$$0(15);
            }
            return couple;
        }

        private boolean emptyCommitMessage() {
            if (this.myPanel.getCommitMessage().trim().isEmpty()) {
                Messages.showMessageDialog((Component)this.myPanel.getComponent(), (String)GitBundle.message("git.commit.message.empty", new Object[0]), (String)GitBundle.message("git.commit.message.empty.title", new Object[0]), (Icon)Messages.getErrorIcon());
                return true;
            }
            return false;
        }

        private CheckinHandler.ReturnResult warnAboutDetachedHeadIfNeeded() {
            String title;
            DetachedRoot detachedRoot = this.getDetachedRoot();
            if (detachedRoot == null || !GitVcsSettings.getInstance(this.myProject).warnAboutDetachedHead()) {
                return CheckinHandler.ReturnResult.COMMIT;
            }
            HtmlChunk.Element rootPath = HtmlChunk.text((String)detachedRoot.myRoot.getPresentableUrl()).bold();
            @NlsContexts.DialogMessage HtmlBuilder message = new HtmlBuilder();
            if (detachedRoot.myRebase) {
                title = GitBundle.message("warning.title.commit.with.unfinished.rebase", new Object[0]);
                message.appendRaw(GitBundle.message("warning.message.commit.with.unfinished.rebase", rootPath.toString())).br().appendLink("https://www.kernel.org/pub/software/scm/git/docs/git-rebase.html", GitBundle.message("link.label.commit.with.unfinished.rebase.read.more", new Object[0]));
            } else {
                title = GitBundle.message("warning.title.commit.with.detached.head", new Object[0]);
                message.appendRaw(GitBundle.message("warning.message.commit.with.detached.head", rootPath.toString())).br().appendLink("http://gitolite.com/detached-head.html", GitBundle.message("link.label.commit.with.detached.head.read.more", new Object[0]));
            }
            DialogWrapper.DoNotAskOption.Adapter dontAskAgain = new DialogWrapper.DoNotAskOption.Adapter(){

                public void rememberChoice(boolean isSelected, int exitCode) {
                    GitVcsSettings.getInstance(myProject).setWarnAboutDetachedHead(!isSelected);
                }

                @NotNull
                public String getDoNotShowMessage() {
                    String string = GitBundle.message("checkbox.dont.warn.again", new Object[0]);
                    if (string == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/checkin/GitCheckinHandlerFactory$MyCheckinHandler$5", "getDoNotShowMessage"));
                }
            };
            int choice = Messages.showOkCancelDialog((Project)this.myProject, (String)message.wrapWithHtmlBody().toString(), (String)title, (String)GitBundle.message("commit.action.name", new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getWarningIcon(), (DialogWrapper.DoNotAskOption)dontAskAgain);
            if (choice == 0) {
                return CheckinHandler.ReturnResult.COMMIT;
            }
            return CheckinHandler.ReturnResult.CLOSE_WINDOW;
        }

        private static boolean commitOrCommitAndPush(@Nullable CommitExecutor executor) {
            return executor == null || executor instanceof GitCommitAndPushExecutor;
        }

        @Nullable
        private DetachedRoot getDetachedRoot() {
            GitRepositoryManager repositoryManager = GitUtil.getRepositoryManager(this.myPanel.getProject());
            for (VirtualFile root : this.getSelectedRoots()) {
                GitRepository repository = (GitRepository)repositoryManager.getRepositoryForRootQuick(root);
                if (repository == null || repository.isOnBranch() || GitRebaseUtils.isInteractiveRebaseInProgress(repository)) continue;
                return new DetachedRoot(root, repository.isRebaseInProgress());
            }
            return null;
        }

        @NotNull
        private Collection<VirtualFile> getSelectedRoots() {
            ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
            GitVcs git = GitVcs.getInstance(this.myProject);
            HashSet<VirtualFile> result2 = new HashSet<VirtualFile>();
            for (FilePath path : ChangesUtil.getPaths((Collection)this.myPanel.getSelectedChanges())) {
                VcsRoot vcsRoot = vcsManager.getVcsRootObjectFor(path);
                if (vcsRoot == null) continue;
                VirtualFile root = vcsRoot.getPath();
                if (!git.equals(vcsRoot.getVcs())) continue;
                result2.add(root);
            }
            HashSet<VirtualFile> hashSet = result2;
            if (hashSet == null) {
                MyCheckinHandler.$$$reportNull$$$0(16);
            }
            return hashSet;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 9: 
                case 15: 
                case 16: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 9: 
                case 15: 
                case 16: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "panel";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 9: 
                case 15: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/checkin/GitCheckinHandlerFactory$MyCheckinHandler";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aRoot";
                    break;
                }
                case 7: 
                case 10: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "roots";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "notDefined";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dialog";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/checkin/GitCheckinHandlerFactory$MyCheckinHandler";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "warnAboutCrlfIfNeeded";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefinedUserNames";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUserNameAndEmailFromGitConfig";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSelectedRoots";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 9: 
                case 15: 
                case 16: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "setCoreAutoCrlfAttribute";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getDefinedUserNames";
                    break;
                }
                case 10: 
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "setUserNameUnderProgress";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "getUserNameAndEmailFromGitConfig";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 9: 
                case 15: 
                case 16: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class DetachedRoot {
            final VirtualFile myRoot;
            final boolean myRebase;

            DetachedRoot(@NotNull VirtualFile root, boolean rebase) {
                if (root == null) {
                    DetachedRoot.$$$reportNull$$$0(0);
                }
                this.myRoot = root;
                this.myRebase = rebase;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/checkin/GitCheckinHandlerFactory$MyCheckinHandler$DetachedRoot", "<init>"));
            }
        }
    }
}

