/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit.codeInsight;

import com.intellij.codeInsight.daemon.quickFix.ExternalLibraryResolver;
import com.intellij.execution.junit.JUnitExternalLibraryDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JUnit5ExternalLibraryResolver
extends ExternalLibraryResolver {
    private static final Set<String> JUNIT5_ANNOTATIONS = ContainerUtil.set((Object[])new String[]{"Test", "Disabled", "TestFactory", "BeforeEach", "BeforeAll", "AfterEach", "AfterAll", "DisplayName", "Nested"});

    @Nullable
    public ExternalLibraryResolver.ExternalClassResolveResult resolveClass(@NotNull String shortClassName, @NotNull ThreeState isAnnotation, @NotNull Module contextModule) {
        if (shortClassName == null) {
            JUnit5ExternalLibraryResolver.$$$reportNull$$$0(0);
        }
        if (isAnnotation == null) {
            JUnit5ExternalLibraryResolver.$$$reportNull$$$0(1);
        }
        if (contextModule == null) {
            JUnit5ExternalLibraryResolver.$$$reportNull$$$0(2);
        }
        if (isAnnotation == ThreeState.YES && JUNIT5_ANNOTATIONS.contains(shortClassName)) {
            return new ExternalLibraryResolver.ExternalClassResolveResult("org.junit.jupiter.api." + shortClassName, JUnitExternalLibraryDescriptor.JUNIT5);
        }
        return null;
    }

    @Nullable
    public ExternalLibraryDescriptor resolvePackage(@NotNull String packageName) {
        if (packageName == null) {
            JUnit5ExternalLibraryResolver.$$$reportNull$$$0(3);
        }
        if (packageName.equals("org.junit.jupiter") || packageName.equals("org.junit")) {
            return JUnitExternalLibraryDescriptor.JUNIT5;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortClassName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isAnnotation";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextModule";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/junit/codeInsight/JUnit5ExternalLibraryResolver";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveClass";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "resolvePackage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

