/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.codeInsight.inspections;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.Query;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.javaFX.fxml.refs.JavaFxScopeEnlarger;
import org.jetbrains.plugins.javaFX.indexing.JavaFxControllerClassIndex;
import org.jetbrains.plugins.javaFX.indexing.JavaFxIdsIndex;

public class JavaFxImplicitUsageProvider
implements ImplicitUsageProvider {
    public boolean isImplicitUsage(@NotNull PsiElement element) {
        if (element == null) {
            JavaFxImplicitUsageProvider.$$$reportNull$$$0(0);
        }
        if (element instanceof PsiMethod) {
            return JavaFxImplicitUsageProvider.isImplicitMethodUsage((PsiMethod)element);
        }
        return this.isImplicitWrite(element);
    }

    private static boolean isImplicitMethodUsage(@NotNull PsiMethod method) {
        if (method == null) {
            JavaFxImplicitUsageProvider.$$$reportNull$$$0(1);
        }
        if (!JavaFxImplicitUsageProvider.isImplicitFxmlAccess((PsiModifierListOwner)method)) {
            return false;
        }
        if (JavaFxImplicitUsageProvider.isInvokedByFxmlLoader(method)) {
            return true;
        }
        GlobalSearchScope projectScope = GlobalSearchScope.projectScope((Project)method.getProject());
        JavaFxScopeEnlarger.GlobalFxmlSearchScope fxmlScope = new JavaFxScopeEnlarger.GlobalFxmlSearchScope(projectScope);
        return JavaFxImplicitUsageProvider.isFxmlUsage((PsiMember)method, (GlobalSearchScope)fxmlScope);
    }

    private static boolean isFxmlUsage(PsiMember member, GlobalSearchScope scope) {
        String name = member.getName();
        if (name == null) {
            return false;
        }
        Project project = member.getProject();
        PsiSearchHelper searchHelper = PsiSearchHelper.getInstance((Project)project);
        PsiSearchHelper.SearchCostResult searchCost = searchHelper.isCheapEnoughToSearch(name, scope, null, null);
        if (searchCost == PsiSearchHelper.SearchCostResult.FEW_OCCURRENCES) {
            Query query = ReferencesSearch.search((PsiElement)member, (SearchScope)scope);
            return query.findFirst() != null;
        }
        return false;
    }

    public boolean isImplicitRead(@NotNull PsiElement element) {
        if (element == null) {
            JavaFxImplicitUsageProvider.$$$reportNull$$$0(2);
        }
        return false;
    }

    public boolean isImplicitWrite(@NotNull PsiElement element) {
        if (element == null) {
            JavaFxImplicitUsageProvider.$$$reportNull$$$0(3);
        }
        if (element instanceof PsiField) {
            PsiField field = (PsiField)element;
            if (!JavaFxImplicitUsageProvider.isImplicitFxmlAccess((PsiModifierListOwner)field)) {
                return false;
            }
            String fieldName = field.getName();
            PsiClass containingClass = field.getContainingClass();
            if (containingClass == null) {
                return false;
            }
            String qualifiedName = containingClass.getQualifiedName();
            if (qualifiedName == null) {
                return false;
            }
            Project project = element.getProject();
            if (JavaFxImplicitUsageProvider.isInjectedByFxmlLoader(field)) {
                return true;
            }
            Collection<VirtualFile> containingFiles = JavaFxIdsIndex.getContainingFiles(project, fieldName);
            if (containingFiles.isEmpty()) {
                return false;
            }
            List<VirtualFile> fxmls = JavaFxControllerClassIndex.findFxmlsWithController(project, qualifiedName);
            for (VirtualFile fxml : fxmls) {
                if (!containingFiles.contains(fxml)) continue;
                return true;
            }
            return JavaFxImplicitUsageProvider.isFxmlUsage((PsiMember)field, GlobalSearchScope.filesScope((Project)project, containingFiles));
        }
        return false;
    }

    private static boolean isInvokedByFxmlLoader(@NotNull PsiMethod method) {
        if (method == null) {
            JavaFxImplicitUsageProvider.$$$reportNull$$$0(4);
        }
        return "initialize".equals(method.getName()) && method.getParameterList().isEmpty() && JavaFxImplicitUsageProvider.isDeclaredInControllerClass((PsiMember)method);
    }

    private static boolean isInjectedByFxmlLoader(@NotNull PsiField field) {
        if (field == null) {
            JavaFxImplicitUsageProvider.$$$reportNull$$$0(5);
        }
        String fieldName = field.getName();
        PsiType fieldType = field.getType();
        return ("resources".equals(fieldName) && InheritanceUtil.isInheritor((PsiType)fieldType, (String)"java.util.ResourceBundle") || "location".equals(fieldName) && InheritanceUtil.isInheritor((PsiType)fieldType, (String)"java.net.URL")) && JavaFxImplicitUsageProvider.isDeclaredInControllerClass((PsiMember)field);
    }

    private static boolean isDeclaredInControllerClass(@NotNull PsiMember member) {
        PsiClass containingClass;
        if (member == null) {
            JavaFxImplicitUsageProvider.$$$reportNull$$$0(6);
        }
        String qualifiedName = (containingClass = member.getContainingClass()) != null ? containingClass.getQualifiedName() : null;
        return qualifiedName != null && !JavaFxControllerClassIndex.findFxmlsWithController(member.getProject(), qualifiedName).isEmpty();
    }

    private static boolean isImplicitFxmlAccess(PsiModifierListOwner member) {
        return !member.hasModifierProperty("public") && AnnotationUtil.isAnnotated((PsiModifierListOwner)member, (String)"javafx.fxml.FXML", (int)0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxImplicitUsageProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplicitUsage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplicitMethodUsage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplicitRead";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplicitWrite";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isInvokedByFxmlLoader";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isInjectedByFxmlLoader";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isDeclaredInControllerClass";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

