/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class MavenResource
implements Serializable {
    private final String myDirectory;
    private final boolean myFiltered;
    private final String myTargetPath;
    private final List<String> myIncludes;
    private final List<String> myExcludes;

    public MavenResource(String directory, boolean filtered, String targetPath, List<String> includes, List<String> excludes) {
        this.myDirectory = directory;
        this.myFiltered = filtered;
        this.myTargetPath = targetPath;
        this.myIncludes = includes == null ? Collections.emptyList() : new ArrayList<String>(includes);
        this.myExcludes = excludes == null ? Collections.emptyList() : new ArrayList<String>(excludes);
    }

    public String getDirectory() {
        return this.myDirectory;
    }

    public boolean isFiltered() {
        return this.myFiltered;
    }

    public String getTargetPath() {
        return this.myTargetPath;
    }

    public List<String> getIncludes() {
        return this.myIncludes;
    }

    public List<String> getExcludes() {
        return this.myExcludes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MavenResource that = (MavenResource)o;
        if (this.myFiltered != that.myFiltered) {
            return false;
        }
        if (!Objects.equals(this.myDirectory, that.myDirectory)) {
            return false;
        }
        if (!this.myExcludes.equals(that.myExcludes)) {
            return false;
        }
        if (!this.myIncludes.equals(that.myIncludes)) {
            return false;
        }
        return Objects.equals(this.myTargetPath, that.myTargetPath);
    }

    public int hashCode() {
        int result = this.myDirectory != null ? this.myDirectory.hashCode() : 0;
        result = 31 * result + (this.myFiltered ? 1 : 0);
        result = 31 * result + (this.myTargetPath != null ? this.myTargetPath.hashCode() : 0);
        result = 31 * result + this.myIncludes.hashCode();
        result = 31 * result + this.myExcludes.hashCode();
        return result;
    }
}

