/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.connection;

import com.intellij.internal.statistic.config.EventLogConfigParserException;
import com.intellij.internal.statistic.config.EventLogExternalSendSettings;
import com.intellij.internal.statistic.config.EventLogExternalSettings;
import com.intellij.internal.statistic.config.bean.EventLogSendConfiguration;
import com.intellij.internal.statistic.config.eventLog.EventLogBuildType;
import com.intellij.internal.statistic.eventLog.EventLogApplicationInfo;
import com.intellij.internal.statistic.eventLog.connection.StatisticsCachingSupplier;
import com.intellij.internal.statistic.eventLog.connection.request.StatsHttpRequests;
import com.intellij.internal.statistic.eventLog.connection.request.StatsResponseException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.http.HttpTimeoutException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.net.ssl.SSLHandshakeException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SettingsConnectionService {
    @Nullable
    private final String myConfigUrl;
    @NotNull
    private final EventLogApplicationInfo myApplicationInfo;
    @NotNull
    private final Supplier<EventLogExternalSendSettings> myCachedExternalSettings;

    protected SettingsConnectionService(@Nullable String settingsUrl, @NotNull String recorderId, @NotNull EventLogApplicationInfo appInfo, long settingsCacheTimeoutMs) {
        if (recorderId == null) {
            SettingsConnectionService.$$$reportNull$$$0(0);
        }
        if (appInfo == null) {
            SettingsConnectionService.$$$reportNull$$$0(1);
        }
        this.myConfigUrl = settingsUrl;
        this.myApplicationInfo = appInfo;
        this.myCachedExternalSettings = new StatisticsCachingSupplier<EventLogExternalSendSettings>(() -> this.myConfigUrl != null ? this.loadSettings(recorderId, this.myConfigUrl, this.myApplicationInfo.getProductVersion()) : null, settingsCacheTimeoutMs);
    }

    @Nullable
    protected EventLogSendConfiguration getConfiguration(@NotNull EventLogBuildType type) {
        EventLogExternalSendSettings settings;
        if (type == null) {
            SettingsConnectionService.$$$reportNull$$$0(2);
        }
        return (settings = this.getExternalSettings()) != null ? settings.getConfiguration(type) : null;
    }

    @Nullable
    protected String getEndpointValue(@NotNull String attribute) {
        EventLogExternalSendSettings settings;
        if (attribute == null) {
            SettingsConnectionService.$$$reportNull$$$0(3);
        }
        return (settings = this.getExternalSettings()) != null ? settings.getEndpoint(attribute) : null;
    }

    @NotNull
    public Map<String, String> getOptions() {
        EventLogExternalSendSettings settings = this.getExternalSettings();
        Map<String, String> map = settings != null ? settings.getOptions() : Collections.emptyMap();
        if (map == null) {
            SettingsConnectionService.$$$reportNull$$$0(4);
        }
        return map;
    }

    @Nullable
    protected synchronized EventLogExternalSendSettings getExternalSettings() {
        return this.myCachedExternalSettings.get();
    }

    @Nullable
    public EventLogExternalSendSettings loadSettings(@NotNull String recorderId, @NotNull String configUrl, @NotNull String appVersion) {
        if (recorderId == null) {
            SettingsConnectionService.$$$reportNull$$$0(5);
        }
        if (configUrl == null) {
            SettingsConnectionService.$$$reportNull$$$0(6);
        }
        if (appVersion == null) {
            SettingsConnectionService.$$$reportNull$$$0(7);
        }
        try {
            return StatsHttpRequests.request(configUrl, this.myApplicationInfo.getConnectionSettings()).send(r -> {
                try {
                    InputStream content = r.read();
                    if (content != null) {
                        InputStreamReader reader = new InputStreamReader(content, StandardCharsets.UTF_8);
                        return EventLogExternalSettings.parseSendSettings(reader, appVersion);
                    }
                    return null;
                }
                catch (EventLogConfigParserException e) {
                    throw new StatsResponseException(e);
                }
            }).getResult();
        }
        catch (StatsResponseException | IOException e) {
            this.logError(recorderId, e);
            return null;
        }
    }

    private void logError(@NotNull String recorderId, Exception e) {
        if (recorderId == null) {
            SettingsConnectionService.$$$reportNull$$$0(8);
        }
        String message = String.format(Locale.ENGLISH, "%s: %s", e.getClass().getName(), Objects.requireNonNullElse(e.getMessage(), "No message provided"));
        if (e instanceof ConnectException || e instanceof HttpTimeoutException || e instanceof SSLHandshakeException || e instanceof StatsResponseException) {
            this.myApplicationInfo.getLogger().info(message);
        } else {
            this.myApplicationInfo.getLogger().warn(message, e);
        }
        this.myApplicationInfo.getEventLogger().logErrorEvent(recorderId, "loading.config.failed", e);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recorderId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appInfo";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/eventLog/connection/SettingsConnectionService";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configUrl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/eventLog/connection/SettingsConnectionService";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getConfiguration";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getEndpointValue";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadSettings";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "logError";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

