/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.events;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.events.BaseEventId;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB3\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u001a\u0010\u0006\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\b0\u0007\"\u0006\u0012\u0002\b\u00030\b\u00a2\u0006\u0002\u0010\tJ\u001a\u0010\u000b\u001a\u00020\f2\u0010\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\u000eH\u0002J\u0012\u0010\u0010\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u000eH\u0016J1\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u001a\u0010\r\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u000f0\u0007\"\u0006\u0012\u0002\b\u00030\u000f\u00a2\u0006\u0002\u0010\u0015J\"\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0010\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\u000eJ'\u0010\u0011\u001a\u00020\u00122\u001a\u0010\r\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u000f0\u0007\"\u0006\u0012\u0002\b\u00030\u000f\u00a2\u0006\u0002\u0010\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0010\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\u000eJ'\u0010\u0017\u001a\u00020\u00182\u001a\u0010\r\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u000f0\u0007\"\u0006\u0012\u0002\b\u00030\u000f\u00a2\u0006\u0002\u0010\u0019J\u0018\u0010\u0017\u001a\u00020\u00182\u0010\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\u000eR\u0018\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "Lcom/intellij/internal/statistic/eventLog/events/BaseEventId;", "group", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "eventId", "", "fields", "", "Lcom/intellij/internal/statistic/eventLog/events/EventField;", "(Lcom/intellij/internal/statistic/eventLog/EventLogGroup;Ljava/lang/String;[Lcom/intellij/internal/statistic/eventLog/events/EventField;)V", "", "buildUsageData", "Lcom/intellij/internal/statistic/eventLog/FeatureUsageData;", "pairs", "", "Lcom/intellij/internal/statistic/eventLog/events/EventPair;", "getFields", "log", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/internal/statistic/eventLog/events/EventPair;)V", "([Lcom/intellij/internal/statistic/eventLog/events/EventPair;)V", "metric", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "([Lcom/intellij/internal/statistic/eventLog/events/EventPair;)Lcom/intellij/internal/statistic/beans/MetricEvent;", "Companion", "intellij.platform.statistics"})
public final class VarargEventId
extends BaseEventId {
    private final List<EventField<?>> fields;
    private final EventLogGroup group;
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    public final void log(EventPair<?> ... pairs) {
        Intrinsics.checkNotNullParameter(pairs, (String)"pairs");
        this.log(CollectionsKt.listOf((Object[])Arrays.copyOf(pairs, pairs.length)));
    }

    public final void log(@NotNull List<? extends EventPair<?>> pairs) {
        Intrinsics.checkNotNullParameter(pairs, (String)"pairs");
        this.getLogger$intellij_platform_statistics().logAsync(this.group, this.getEventId(), this.buildUsageData(pairs).build(), false);
    }

    public final void log(@Nullable Project project, EventPair<?> ... pairs) {
        Intrinsics.checkNotNullParameter(pairs, (String)"pairs");
        this.log(project, CollectionsKt.listOf((Object[])Arrays.copyOf(pairs, pairs.length)));
    }

    public final void log(@Nullable Project project, @NotNull List<? extends EventPair<?>> pairs) {
        Intrinsics.checkNotNullParameter(pairs, (String)"pairs");
        this.getLogger$intellij_platform_statistics().logAsync(this.group, this.getEventId(), this.buildUsageData(pairs).addProject(project).build(), false);
    }

    @NotNull
    public final MetricEvent metric(EventPair<?> ... pairs) {
        Intrinsics.checkNotNullParameter(pairs, (String)"pairs");
        return this.metric(CollectionsKt.listOf((Object[])Arrays.copyOf(pairs, pairs.length)));
    }

    @NotNull
    public final MetricEvent metric(@NotNull List<? extends EventPair<?>> pairs) {
        Intrinsics.checkNotNullParameter(pairs, (String)"pairs");
        return new MetricEvent(this.getEventId(), this.buildUsageData(pairs));
    }

    private final FeatureUsageData buildUsageData(List<? extends EventPair<?>> pairs) {
        FeatureUsageData data = new FeatureUsageData();
        for (EventPair<?> pair : pairs) {
            if (!this.fields.contains(pair.getField())) {
                throw (Throwable)new IllegalArgumentException("Field " + pair.getField().getName() + " not in fields for event ID " + this.getEventId());
            }
            EventField<?> eventField = pair.getField();
            if (eventField == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.internal.statistic.eventLog.events.EventField<kotlin.Any?>");
            }
            eventField.addData(data, pair.getData());
        }
        return data;
    }

    @Override
    @NotNull
    public List<EventField<?>> getFields() {
        return CollectionsKt.toList((Iterable)this.fields);
    }

    public VarargEventId(@NotNull EventLogGroup group, @NotNull String eventId, EventField<?> ... fields) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        Intrinsics.checkNotNullParameter(fields, (String)"fields");
        super(eventId, group.getRecorder());
        this.group = group;
        this.fields = ArraysKt.toMutableList((Object[])fields);
    }

    static {
        Companion = new Companion(null);
        Logger logger2 = Logger.getInstance(VarargEventId.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"Logger.getInstance(VarargEventId::class.java)");
        LOG = logger2;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/internal/statistic/eventLog/events/VarargEventId$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.statistics"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

