/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.server;

import java.awt.Toolkit;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.projector.server.HeadlessInitializerKt;
import org.jetbrains.projector.server.PAwtProvider;
import org.jetbrains.projector.server.ProjectorServer;
import org.jetbrains.projector.server.ProjectorStarter;
import org.jetbrains.projector.server.service.ProjectorFontProvider;
import org.jetbrains.projector.util.loading.UseProjectorLoader;
import org.jetbrains.projector.util.logging.Logger;

@UseProjectorLoader
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0017\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/jetbrains/projector/server/ProjectorStarter;", "", "()V", "Companion", "projector-server-common"})
public class ProjectorStarter {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @JvmStatic
    public static final void start(@NotNull String[] args, @NotNull PAwtProvider awtProvider) {
        Companion.start(args, awtProvider);
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean runProjectorServer(@NotNull PAwtProvider awtProvider, @NotNull Function1<? super String, ? extends Logger> loggerFactory2) {
        return Companion.runProjectorServer(awtProvider, loggerFactory2);
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean runProjectorServer(@NotNull PAwtProvider awtProvider) {
        return Companion.runProjectorServer(awtProvider);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\bH\u0002J5\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2#\b\u0002\u0010\u0010\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\u00150\u0011H\u0007J\u0010\u0010\u0016\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J#\u0010\u0017\u001a\u00020\b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\u00192\u0006\u0010\u000e\u001a\u00020\u000fH\u0007\u00a2\u0006\u0002\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/projector/server/ProjectorStarter$Companion;", "", "()V", "getMainMethodOf", "Ljava/lang/reflect/Method;", "canonicalClassName", "", "initializeHeadlessFull", "", "projectorToolkit", "Ljava/awt/Toolkit;", "initializeHeadlessGeneral", "runProjectorServer", "", "awtProvider", "Lorg/jetbrains/projector/server/PAwtProvider;", "loggerFactory", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "tag", "Lorg/jetbrains/projector/util/logging/Logger;", "setupSingletons", "start", "args", "", "([Ljava/lang/String;Lorg/jetbrains/projector/server/PAwtProvider;)V", "projector-server-common"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void start(@NotNull String[] args, @NotNull PAwtProvider awtProvider) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            Intrinsics.checkNotNullParameter((Object)awtProvider, (String)"awtProvider");
            String string = System.getProperty("org.jetbrains.projector.server.classToLaunch");
            if (string == null) {
                boolean bl = false;
                String string2 = "System property `org.jetbrains.projector.server.classToLaunch` isn't assigned, so can't understand which class to launch";
                throw new IllegalArgumentException(string2.toString());
            }
            String canonicalMainClassName = string;
            Method mainMethod = this.getMainMethodOf(canonicalMainClassName);
            if (!org.jetbrains.projector.server.ProjectorStarter$Companion.runProjectorServer$default(this, awtProvider, null, 2, null)) {
                System.exit(1);
                throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
            Object[] objectArray = new Object[]{args};
            mainMethod.invoke(null, objectArray);
        }

        private final Method getMainMethodOf(String canonicalClassName) {
            Class<?> mainClass = Class.forName(canonicalClassName);
            Class[] classArray = new Class[]{String[].class};
            Method method = mainClass.getMethod("main", classArray);
            Intrinsics.checkNotNullExpressionValue((Object)method, (String)"mainClass.getMethod(\"mai\u2026rray<String>::class.java)");
            return method;
        }

        private final void setupSingletons(Toolkit projectorToolkit) {
            HeadlessInitializerKt.setupToolkit(projectorToolkit);
            HeadlessInitializerKt.setupFontManager();
            HeadlessInitializerKt.setupRepaintManager();
        }

        private final void initializeHeadlessGeneral() {
            HeadlessInitializerKt.setupSystemProperties();
            ProjectorFontProvider.INSTANCE.setAgent(false);
        }

        private final void initializeHeadlessFull(Toolkit projectorToolkit) {
            this.setupSingletons(projectorToolkit);
        }

        @JvmStatic
        @JvmOverloads
        public final boolean runProjectorServer(@NotNull PAwtProvider awtProvider, @NotNull Function1<? super String, ? extends Logger> loggerFactory2) {
            Intrinsics.checkNotNullParameter((Object)awtProvider, (String)"awtProvider");
            Intrinsics.checkNotNullParameter(loggerFactory2, (String)"loggerFactory");
            System.setProperty("org.jetbrains.projector.server.enable", "true");
            boolean bl = ProjectorServer.Companion.isEnabled();
            if (_Assertions.ENABLED && !bl) {
                boolean bl2 = false;
                String string = "Can't start the " + Reflection.getOrCreateKotlinClass(ProjectorServer.class).getSimpleName() + " because it's disabled...";
                throw new AssertionError((Object)string);
            }
            ProjectorServer server = ProjectorServer.Companion.startServer(false, loggerFactory2, Companion::runProjectorServer$lambda-2, () -> Companion.runProjectorServer$lambda-3(awtProvider));
            Runtime.getRuntime().addShutdownHook(new Thread(server){
                final /* synthetic */ ProjectorServer $server;
                {
                    this.$server = $server;
                }

                public void run() {
                    ProjectorServer.stop$default(this.$server, 0, 1, null);
                }
            });
            return server.getWasStarted();
        }

        public static /* synthetic */ boolean runProjectorServer$default(Companion companion, PAwtProvider pAwtProvider, Function1 function1, int n, Object object) {
            if ((n & 2) != 0) {
                function1 = runProjectorServer.1.INSTANCE;
            }
            return companion.runProjectorServer(pAwtProvider, (Function1<? super String, ? extends Logger>)function1);
        }

        @JvmStatic
        @JvmOverloads
        public final boolean runProjectorServer(@NotNull PAwtProvider awtProvider) {
            Intrinsics.checkNotNullParameter((Object)awtProvider, (String)"awtProvider");
            return org.jetbrains.projector.server.ProjectorStarter$Companion.runProjectorServer$default(this, awtProvider, null, 2, null);
        }

        private static final void runProjectorServer$lambda-2() {
            Companion.initializeHeadlessGeneral();
        }

        private static final void runProjectorServer$lambda-3(PAwtProvider $awtProvider) {
            Intrinsics.checkNotNullParameter((Object)$awtProvider, (String)"$awtProvider");
            Companion.initializeHeadlessFull($awtProvider.createToolkit());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

