/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.server.platform;

import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.BuildNumber;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.projector.server.platform.CompatibilityKt;
import org.jetbrains.projector.util.loading.UseProjectorLoader;

@UseProjectorLoader(attachPackage=true)
@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0014\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\"\u001b\u0010\u0000\u001a\u00020\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0004\u001a\u0004\b\u0000\u0010\u0002\u00a8\u0006\r"}, d2={"isColorSchemeRequired", "", "()Z", "isColorSchemeRequired$delegate", "Lkotlin/Lazy;", "buildAtLeast", "version", "", "getTextAttributesCompat", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "colorScheme", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "projector-server-common"})
public final class CompatibilityKt {
    @NotNull
    private static final Lazy isColorSchemeRequired$delegate = LazyKt.lazy((Function0)isColorSchemeRequired.2.INSTANCE);

    public static final boolean buildAtLeast(@NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        BuildNumber buildNumber = BuildNumber.fromString((String)version);
        if (buildNumber == null) {
            throw new IllegalArgumentException("Invalid version string " + version);
        }
        BuildNumber versionToCheck = buildNumber;
        BuildNumber buildNumber2 = ApplicationInfo.getInstance().getBuild();
        Intrinsics.checkNotNullExpressionValue((Object)buildNumber2, (String)"getInstance().build");
        BuildNumber currentVersion = buildNumber2;
        return currentVersion.compareTo(versionToCheck) >= 0;
    }

    private static final boolean isColorSchemeRequired() {
        Lazy lazy = isColorSchemeRequired$delegate;
        return (Boolean)lazy.getValue();
    }

    @Nullable
    public static final TextAttributes getTextAttributesCompat(@NotNull RangeHighlighter $this$getTextAttributesCompat, @NotNull EditorColorsScheme colorScheme) {
        Intrinsics.checkNotNullParameter((Object)$this$getTextAttributesCompat, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)colorScheme, (String)"colorScheme");
        return CompatibilityKt.isColorSchemeRequired() ? $this$getTextAttributesCompat.getTextAttributes(colorScheme) : $this$getTextAttributesCompat.getTextAttributes();
    }
}

