/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.binding;

import com.intellij.lang.properties.PropertiesUtilBase;
import com.intellij.lang.properties.ResourceBundleManager;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.uiDesigner.binding.FormReferenceProvider;
import com.intellij.uiDesigner.binding.ReferenceInForm;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public final class ResourceBundleFileReference
extends ReferenceInForm {
    private static final Logger LOG = Logger.getInstance(ResourceBundleFileReference.class);

    public ResourceBundleFileReference(PsiPlainTextFile file, TextRange bundleNameRange) {
        super(file, bundleNameRange);
    }

    public PsiElement resolve() {
        Project project = this.myFile.getProject();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        VirtualFile formVirtualFile = this.myFile.getVirtualFile();
        if (formVirtualFile == null) {
            return null;
        }
        Module module = fileIndex.getModuleForFile(formVirtualFile);
        if (module == null) {
            return null;
        }
        PropertiesFile propertiesFile = PropertiesUtilBase.getPropertiesFile((String)this.getRangeText(), (Module)module, null);
        return propertiesFile == null ? null : propertiesFile.getContainingFile();
    }

    @Override
    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            ResourceBundleFileReference.$$$reportNull$$$0(0);
        }
        if (!(element instanceof PropertiesFile)) {
            return false;
        }
        String baseName = ResourceBundleManager.getInstance((Project)element.getProject()).getFullName((PropertiesFile)element);
        if (baseName == null) {
            return false;
        }
        baseName = baseName.replace('.', '/');
        String rangeText = this.getRangeText();
        return rangeText.equals(baseName);
    }

    @Override
    public PsiElement handleElementRename(@NotNull String newElementName) {
        if (newElementName == null) {
            ResourceBundleFileReference.$$$reportNull$$$0(1);
        }
        return this.handleFileRename(newElementName, ".properties", false);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            ResourceBundleFileReference.$$$reportNull$$$0(2);
        }
        if (!(element instanceof PropertiesFile)) {
            throw new IncorrectOperationException();
        }
        PropertiesFile propertyFile = (PropertiesFile)element;
        String bundleName = FormReferenceProvider.getBundleName(propertyFile);
        LOG.assertTrue(bundleName != null);
        this.updateRangeText(bundleName);
        return this.myFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/uiDesigner/binding/ResourceBundleFileReference";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isReferenceTo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "handleElementRename";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "bindToElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

