/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.propertyInspector.properties;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.uiDesigner.StringDescriptorManager;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.lw.ColorDescriptor;
import com.intellij.uiDesigner.lw.FontDescriptor;
import com.intellij.uiDesigner.lw.StringDescriptor;
import com.intellij.uiDesigner.propertyInspector.Property;
import com.intellij.uiDesigner.propertyInspector.PropertyEditor;
import com.intellij.uiDesigner.propertyInspector.PropertyRenderer;
import com.intellij.uiDesigner.propertyInspector.editors.BorderTypeEditor;
import com.intellij.uiDesigner.propertyInspector.editors.ColorEditor;
import com.intellij.uiDesigner.propertyInspector.editors.FontEditor;
import com.intellij.uiDesigner.propertyInspector.editors.IntEnumEditor;
import com.intellij.uiDesigner.propertyInspector.editors.string.StringEditor;
import com.intellij.uiDesigner.propertyInspector.properties.AbstractInsetsProperty;
import com.intellij.uiDesigner.propertyInspector.renderers.ColorRenderer;
import com.intellij.uiDesigner.propertyInspector.renderers.FontRenderer;
import com.intellij.uiDesigner.propertyInspector.renderers.IntEnumRenderer;
import com.intellij.uiDesigner.propertyInspector.renderers.LabelPropertyRenderer;
import com.intellij.uiDesigner.propertyInspector.renderers.StringRenderer;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadContainer;
import com.intellij.uiDesigner.shared.BorderType;
import java.awt.Insets;
import java.util.function.Supplier;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class BorderProperty
extends Property<RadContainer, BorderType> {
    @NonNls
    public static final String NAME = "border";
    private final Project myProject;
    private final Property[] myChildren;
    private final NotNullLazyValue<PropertyRenderer<BorderType>> myRenderer = NotNullLazyValue.lazy((Supplier)new Supplier<PropertyRenderer<BorderType>>(){

        @Override
        public PropertyRenderer<BorderType> get() {
            return new LabelPropertyRenderer<BorderType>(){

                @Override
                protected void customize(@NotNull BorderType value) {
                    if (value == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    @NlsSafe String name = value.getName();
                    this.setText(name);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/uiDesigner/propertyInspector/properties/BorderProperty$1$1", "customize"));
                }
            };
        }
    });
    private static final IntEnumEditor.Pair[] ourJustificationPairs = new IntEnumEditor.Pair[]{new IntEnumEditor.Pair(0, UIDesignerBundle.message("property.default", new Object[0])), new IntEnumEditor.Pair(1, UIDesignerBundle.message("property.left", new Object[0])), new IntEnumEditor.Pair(2, UIDesignerBundle.message("property.center", new Object[0])), new IntEnumEditor.Pair(3, UIDesignerBundle.message("property.right", new Object[0])), new IntEnumEditor.Pair(4, UIDesignerBundle.message("property.leading", new Object[0])), new IntEnumEditor.Pair(5, UIDesignerBundle.message("property.trailing", new Object[0]))};
    private static final IntEnumEditor.Pair[] ourPositionPairs = new IntEnumEditor.Pair[]{new IntEnumEditor.Pair(0, UIDesignerBundle.message("property.default", new Object[0])), new IntEnumEditor.Pair(1, UIDesignerBundle.message("property.above.top", new Object[0])), new IntEnumEditor.Pair(2, UIDesignerBundle.message("property.top", new Object[0])), new IntEnumEditor.Pair(3, UIDesignerBundle.message("property.below.top", new Object[0])), new IntEnumEditor.Pair(4, UIDesignerBundle.message("property.above.bottom", new Object[0])), new IntEnumEditor.Pair(5, UIDesignerBundle.message("property.bottom", new Object[0])), new IntEnumEditor.Pair(6, UIDesignerBundle.message("property.below.bottom", new Object[0]))};

    public BorderProperty(Project project) {
        super(null, NAME);
        this.myProject = project;
        this.myChildren = new Property[]{new MyTypeProperty(), new MyTitleProperty(), new MyTitleIntEnumProperty(this, "title justification", true), new MyTitleIntEnumProperty(this, "title position", false), new MyTitleFontProperty(this), new MyBorderColorProperty((Property)this, true)};
    }

    @Override
    public BorderType getValue(RadContainer component) {
        return component.getBorderType();
    }

    @Override
    protected void setValueImpl(RadContainer component, BorderType value) throws Exception {
    }

    @Override
    public Property @NotNull [] getChildren(RadComponent component) {
        if (!(component instanceof RadContainer)) {
            if (Property.EMPTY_ARRAY == null) {
                BorderProperty.$$$reportNull$$$0(0);
            }
            return Property.EMPTY_ARRAY;
        }
        BorderType borderType = ((RadContainer)component).getBorderType();
        if (borderType.equals((Object)BorderType.EMPTY)) {
            Property[] propertyArray = new Property[]{new MyTypeProperty(), new MySizeProperty(this), new MyTitleProperty(), new MyTitleIntEnumProperty(this, "title justification", true), new MyTitleIntEnumProperty(this, "title position", false), new MyTitleFontProperty(this), new MyBorderColorProperty((Property)this, true)};
            if (propertyArray == null) {
                BorderProperty.$$$reportNull$$$0(1);
            }
            return propertyArray;
        }
        if (borderType.equals((Object)BorderType.LINE)) {
            Property[] propertyArray = new Property[]{new MyTypeProperty(), new MyBorderColorProperty((Property)this, false), new MyTitleProperty(), new MyTitleIntEnumProperty(this, "title justification", true), new MyTitleIntEnumProperty(this, "title position", false), new MyTitleFontProperty(this), new MyBorderColorProperty((Property)this, true)};
            if (propertyArray == null) {
                BorderProperty.$$$reportNull$$$0(2);
            }
            return propertyArray;
        }
        if (this.myChildren == null) {
            BorderProperty.$$$reportNull$$$0(3);
        }
        return this.myChildren;
    }

    @Override
    @NotNull
    public PropertyRenderer<BorderType> getRenderer() {
        PropertyRenderer propertyRenderer = (PropertyRenderer)this.myRenderer.getValue();
        if (propertyRenderer == null) {
            BorderProperty.$$$reportNull$$$0(4);
        }
        return propertyRenderer;
    }

    @Override
    public PropertyEditor<BorderType> getEditor() {
        return null;
    }

    @Override
    public boolean isModified(RadContainer component) {
        return !component.getBorderType().equals((Object)BorderType.NONE) || component.getBorderTitle() != null;
    }

    @Override
    public void resetValue(RadContainer component) throws Exception {
        component.setBorderType(BorderType.NONE);
        component.setBorderTitle(null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/uiDesigner/propertyInspector/properties/BorderProperty";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRenderer";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class MySizeProperty
    extends AbstractInsetsProperty<RadContainer> {
        MySizeProperty(Property parent) {
            super(parent, "size");
        }

        @Override
        public Insets getValue(RadContainer container) {
            return container.getBorderSize();
        }

        @Override
        protected void setValueImpl(RadContainer container, Insets insets) throws Exception {
            container.setBorderSize(insets);
        }
    }

    private static class MyBorderColorProperty
    extends Property<RadContainer, ColorDescriptor> {
        private ColorRenderer myRenderer;
        private ColorEditor myEditor;
        private final boolean myTitleColor;

        MyBorderColorProperty(Property parent, boolean titleColor) {
            super(parent, titleColor ? "title color" : "color");
            this.myTitleColor = titleColor;
        }

        @Override
        public ColorDescriptor getValue(RadContainer component) {
            return this.myTitleColor ? component.getBorderTitleColor() : component.getBorderColor();
        }

        @Override
        protected void setValueImpl(RadContainer component, ColorDescriptor value) throws Exception {
            if (this.myTitleColor) {
                component.setBorderTitleColor(value);
            } else {
                component.setBorderColor(value);
            }
        }

        @Override
        @NotNull
        public PropertyRenderer<ColorDescriptor> getRenderer() {
            if (this.myRenderer == null) {
                this.myRenderer = new ColorRenderer();
            }
            ColorRenderer colorRenderer = this.myRenderer;
            if (colorRenderer == null) {
                MyBorderColorProperty.$$$reportNull$$$0(0);
            }
            return colorRenderer;
        }

        @Override
        public PropertyEditor<ColorDescriptor> getEditor() {
            if (this.myEditor == null) {
                this.myEditor = new ColorEditor(this.myTitleColor ? UIDesignerBundle.message("border.title.editor.title", new Object[0]) : UIDesignerBundle.message("border.color.editor.title", new Object[0]));
            }
            return this.myEditor;
        }

        @Override
        public boolean isModified(RadContainer component) {
            return this.getValue(component) != null;
        }

        @Override
        public void resetValue(RadContainer component) throws Exception {
            this.setValueImpl(component, null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/propertyInspector/properties/BorderProperty$MyBorderColorProperty", "getRenderer"));
        }
    }

    private static class MyTitleFontProperty
    extends Property<RadContainer, FontDescriptor> {
        private FontRenderer myRenderer;
        private FontEditor myEditor;

        MyTitleFontProperty(Property parent) {
            super(parent, "title font");
        }

        @Override
        public FontDescriptor getValue(RadContainer component) {
            return component.getBorderTitleFont();
        }

        @Override
        protected void setValueImpl(RadContainer component, FontDescriptor value) throws Exception {
            component.setBorderTitleFont(value);
        }

        @Override
        @NotNull
        public PropertyRenderer<FontDescriptor> getRenderer() {
            if (this.myRenderer == null) {
                this.myRenderer = new FontRenderer();
            }
            FontRenderer fontRenderer = this.myRenderer;
            if (fontRenderer == null) {
                MyTitleFontProperty.$$$reportNull$$$0(0);
            }
            return fontRenderer;
        }

        @Override
        public PropertyEditor<FontDescriptor> getEditor() {
            if (this.myEditor == null) {
                this.myEditor = new FontEditor(UIDesignerBundle.message("border.title.editor.title", new Object[0]));
            }
            return this.myEditor;
        }

        @Override
        public boolean isModified(RadContainer component) {
            return component.getBorderTitleFont() != null;
        }

        @Override
        public void resetValue(RadContainer component) throws Exception {
            component.setBorderTitleFont(null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/propertyInspector/properties/BorderProperty$MyTitleFontProperty", "getRenderer"));
        }
    }

    private static class MyTitleIntEnumProperty
    extends Property<RadContainer, Integer> {
        private IntEnumRenderer myRenderer;
        private IntEnumEditor myEditor;
        private final boolean myJustification;

        MyTitleIntEnumProperty(Property parent, @NonNls String name, boolean isJustification) {
            super(parent, name);
            this.myJustification = isJustification;
        }

        @Override
        public Integer getValue(RadContainer component) {
            return this.myJustification ? component.getBorderTitleJustification() : component.getBorderTitlePosition();
        }

        @Override
        protected void setValueImpl(RadContainer component, Integer value) throws Exception {
            if (this.myJustification) {
                component.setBorderTitleJustification(value);
            } else {
                component.setBorderTitlePosition(value);
            }
        }

        @Override
        @NotNull
        public PropertyRenderer<Integer> getRenderer() {
            if (this.myRenderer == null) {
                this.myRenderer = new IntEnumRenderer(this.myJustification ? ourJustificationPairs : ourPositionPairs);
            }
            IntEnumRenderer intEnumRenderer = this.myRenderer;
            if (intEnumRenderer == null) {
                MyTitleIntEnumProperty.$$$reportNull$$$0(0);
            }
            return intEnumRenderer;
        }

        @Override
        public PropertyEditor<Integer> getEditor() {
            if (this.myEditor == null) {
                this.myEditor = new IntEnumEditor(this.myJustification ? ourJustificationPairs : ourPositionPairs);
            }
            return this.myEditor;
        }

        @Override
        public boolean isModified(RadContainer component) {
            return this.getValue(component) != 0;
        }

        @Override
        public void resetValue(RadContainer component) throws Exception {
            this.setValue(component, 0);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/propertyInspector/properties/BorderProperty$MyTitleIntEnumProperty", "getRenderer"));
        }
    }

    private final class MyTitleProperty
    extends Property<RadContainer, StringDescriptor> {
        private StringRenderer myRenderer;
        private StringEditor myEditor;

        MyTitleProperty() {
            super(BorderProperty.this, "title");
        }

        @Override
        public StringDescriptor getValue(RadContainer component) {
            StringDescriptor descriptor = component.getBorderTitle();
            String resolvedValue = StringDescriptorManager.getInstance(component.getModule()).resolve(component, descriptor);
            if (descriptor != null) {
                descriptor.setResolvedValue(resolvedValue);
            }
            return descriptor;
        }

        @Override
        protected void setValueImpl(RadContainer component, StringDescriptor value) throws Exception {
            StringDescriptor title = value;
            if (title != null && StringDescriptorManager.getInstance(component.getModule()).resolve(component, title).length() == 0) {
                title = null;
            }
            component.setBorderTitle(title);
        }

        @Override
        @NotNull
        public PropertyRenderer<StringDescriptor> getRenderer() {
            if (this.myRenderer == null) {
                this.myRenderer = new StringRenderer();
            }
            StringRenderer stringRenderer = this.myRenderer;
            if (stringRenderer == null) {
                MyTitleProperty.$$$reportNull$$$0(0);
            }
            return stringRenderer;
        }

        @Override
        public PropertyEditor<StringDescriptor> getEditor() {
            if (this.myEditor == null) {
                this.myEditor = new StringEditor(BorderProperty.this.myProject);
            }
            return this.myEditor;
        }

        @Override
        public boolean isModified(RadContainer component) {
            return this.getValue(component) != null;
        }

        @Override
        public void resetValue(RadContainer component) throws Exception {
            component.setBorderTitle(null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/propertyInspector/properties/BorderProperty$MyTitleProperty", "getRenderer"));
        }
    }

    private final class MyTypeProperty
    extends Property<RadContainer, BorderType> {
        BorderTypeEditor myEditor;

        MyTypeProperty() {
            super(BorderProperty.this, "type");
        }

        @Override
        public BorderType getValue(RadContainer component) {
            return component.getBorderType();
        }

        @Override
        protected void setValueImpl(RadContainer component, BorderType value) throws Exception {
            component.setBorderType(value);
        }

        @Override
        @NotNull
        public PropertyRenderer<BorderType> getRenderer() {
            PropertyRenderer propertyRenderer = (PropertyRenderer)BorderProperty.this.myRenderer.getValue();
            if (propertyRenderer == null) {
                MyTypeProperty.$$$reportNull$$$0(0);
            }
            return propertyRenderer;
        }

        @Override
        public PropertyEditor<BorderType> getEditor() {
            if (this.myEditor == null) {
                this.myEditor = new BorderTypeEditor();
            }
            return this.myEditor;
        }

        @Override
        public boolean isModified(RadContainer component) {
            return !this.getValue(component).equals((Object)BorderType.NONE);
        }

        @Override
        public void resetValue(RadContainer component) throws Exception {
            this.setValueImpl(component, BorderType.NONE);
        }

        @Override
        public boolean needRefreshPropertyList() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/propertyInspector/properties/BorderProperty$MyTypeProperty", "getRenderer"));
        }
    }
}

