/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.ivy.osgi.repo;

import java.net.URI;
import java.text.ParseException;
import java.util.Iterator;
import org.gradle.internal.impldep.org.apache.ivy.osgi.core.BundleInfo;
import org.gradle.internal.impldep.org.apache.ivy.osgi.core.ExecutionEnvironmentProfileProvider;
import org.gradle.internal.impldep.org.apache.ivy.osgi.core.ManifestParser;
import org.gradle.internal.impldep.org.apache.ivy.osgi.repo.ManifestAndLocation;
import org.gradle.internal.impldep.org.apache.ivy.osgi.repo.RepoDescriptor;
import org.gradle.internal.impldep.org.apache.ivy.util.Message;

public class BundleRepoDescriptor
extends RepoDescriptor {
    private String name;
    private Long lastModified;

    public BundleRepoDescriptor(URI baseUri, ExecutionEnvironmentProfileProvider profileProvider) {
        super(baseUri, profileProvider);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setLastModified(Long lastModified) {
        this.lastModified = lastModified;
    }

    public Long getLastModified() {
        return this.lastModified;
    }

    public void populate(Iterator it) {
        while (it.hasNext()) {
            ManifestAndLocation manifestAndLocation = (ManifestAndLocation)it.next();
            try {
                BundleInfo bundleInfo = ManifestParser.parseManifest(manifestAndLocation.getManifest());
                bundleInfo.setUri(manifestAndLocation.getUri());
                this.addBundle(bundleInfo);
            }
            catch (ParseException e) {
                Message.error("Rejected " + manifestAndLocation.getUri() + ": " + e.getMessage());
            }
        }
    }
}

