/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.bc;

import java.io.IOException;
import org.gradle.internal.impldep.org.bouncycastle.bcpg.BCPGKey;
import org.gradle.internal.impldep.org.bouncycastle.bcpg.MPInteger;
import org.gradle.internal.impldep.org.bouncycastle.bcpg.PublicKeyPacket;
import org.gradle.internal.impldep.org.bouncycastle.bcpg.RSAPublicBCPGKey;
import org.gradle.internal.impldep.org.bouncycastle.crypto.digests.GeneralDigest;
import org.gradle.internal.impldep.org.bouncycastle.crypto.digests.MD5Digest;
import org.gradle.internal.impldep.org.bouncycastle.crypto.digests.SHA1Digest;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPException;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;

public class BcKeyFingerprintCalculator
implements KeyFingerPrintCalculator {
    public byte[] calculateFingerprint(PublicKeyPacket publicKeyPacket) throws PGPException {
        GeneralDigest generalDigest;
        Object object;
        BCPGKey bCPGKey = publicKeyPacket.getKey();
        if (publicKeyPacket.getVersion() <= 3) {
            object = (RSAPublicBCPGKey)bCPGKey;
            try {
                generalDigest = new MD5Digest();
                byte[] byArray = new MPInteger(((RSAPublicBCPGKey)object).getModulus()).getEncoded();
                generalDigest.update(byArray, 2, byArray.length - 2);
                byArray = new MPInteger(((RSAPublicBCPGKey)object).getPublicExponent()).getEncoded();
                generalDigest.update(byArray, 2, byArray.length - 2);
            }
            catch (IOException iOException) {
                throw new PGPException("can't encode key components: " + iOException.getMessage(), iOException);
            }
        }
        try {
            object = publicKeyPacket.getEncodedContents();
            generalDigest = new SHA1Digest();
            generalDigest.update((byte)-103);
            generalDigest.update((byte)(((Object)object).length >> 8));
            generalDigest.update((byte)((Object)object).length);
            generalDigest.update((byte[])object, 0, ((Object)object).length);
        }
        catch (IOException iOException) {
            throw new PGPException("can't encode key components: " + iOException.getMessage(), iOException);
        }
        object = new byte[generalDigest.getDigestSize()];
        generalDigest.doFinal((byte[])object, 0);
        return object;
    }
}

