/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.junit.platform.launcher.core;

import java.util.Optional;
import java.util.function.Consumer;
import org.gradle.internal.impldep.org.apiguardian.api.API;
import org.gradle.internal.impldep.org.junit.platform.commons.JUnitException;
import org.gradle.internal.impldep.org.junit.platform.commons.util.UnrecoverableExceptions;
import org.gradle.internal.impldep.org.junit.platform.engine.ConfigurationParameters;
import org.gradle.internal.impldep.org.junit.platform.engine.EngineExecutionListener;
import org.gradle.internal.impldep.org.junit.platform.engine.ExecutionRequest;
import org.gradle.internal.impldep.org.junit.platform.engine.TestDescriptor;
import org.gradle.internal.impldep.org.junit.platform.engine.TestEngine;
import org.gradle.internal.impldep.org.junit.platform.engine.TestExecutionResult;
import org.gradle.internal.impldep.org.junit.platform.launcher.TestExecutionListener;
import org.gradle.internal.impldep.org.junit.platform.launcher.core.EngineDiscoveryErrorDescriptor;
import org.gradle.internal.impldep.org.junit.platform.launcher.core.ExecutionListenerAdapter;
import org.gradle.internal.impldep.org.junit.platform.launcher.core.InternalTestPlan;
import org.gradle.internal.impldep.org.junit.platform.launcher.core.LauncherDiscoveryResult;
import org.gradle.internal.impldep.org.junit.platform.launcher.core.OutcomeDelayingEngineExecutionListener;
import org.gradle.internal.impldep.org.junit.platform.launcher.core.StreamInterceptingTestExecutionListener;
import org.gradle.internal.impldep.org.junit.platform.launcher.core.TestExecutionListenerRegistry;

@API(status=API.Status.INTERNAL, since="1.7", consumers={"testkit"})
public class EngineExecutionOrchestrator {
    private final TestExecutionListenerRegistry listenerRegistry;

    public EngineExecutionOrchestrator() {
        this(new TestExecutionListenerRegistry());
    }

    EngineExecutionOrchestrator(TestExecutionListenerRegistry listenerRegistry) {
        this.listenerRegistry = listenerRegistry;
    }

    void execute(InternalTestPlan internalTestPlan, TestExecutionListener ... listeners) {
        internalTestPlan.markStarted();
        LauncherDiscoveryResult discoveryResult = internalTestPlan.getDiscoveryResult();
        ConfigurationParameters configurationParameters = discoveryResult.getConfigurationParameters();
        TestExecutionListenerRegistry listenerRegistry = this.buildListenerRegistryForExecution(listeners);
        this.withInterceptedStreams(configurationParameters, listenerRegistry, testExecutionListener -> {
            testExecutionListener.testPlanExecutionStarted(internalTestPlan);
            this.execute(discoveryResult, new ExecutionListenerAdapter(internalTestPlan, (TestExecutionListener)testExecutionListener));
            testExecutionListener.testPlanExecutionFinished(internalTestPlan);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void withInterceptedStreams(ConfigurationParameters configurationParameters, TestExecutionListenerRegistry listenerRegistry, Consumer<TestExecutionListener> action) {
        TestExecutionListener testExecutionListener = listenerRegistry.getCompositeTestExecutionListener();
        Optional<StreamInterceptingTestExecutionListener> streamInterceptingTestExecutionListener = StreamInterceptingTestExecutionListener.create(configurationParameters, testExecutionListener::reportingEntryPublished);
        streamInterceptingTestExecutionListener.ifPresent(xva$0 -> listenerRegistry.registerListeners((TestExecutionListener)xva$0));
        try {
            action.accept(testExecutionListener);
        }
        finally {
            streamInterceptingTestExecutionListener.ifPresent(StreamInterceptingTestExecutionListener::unregister);
        }
    }

    public void execute(LauncherDiscoveryResult discoveryResult, EngineExecutionListener listener) {
        for (TestEngine testEngine : discoveryResult.getTestEngines()) {
            TestDescriptor engineDescriptor = discoveryResult.getEngineTestDescriptor(testEngine);
            if (engineDescriptor instanceof EngineDiscoveryErrorDescriptor) {
                listener.executionStarted(engineDescriptor);
                listener.executionFinished(engineDescriptor, TestExecutionResult.failed(((EngineDiscoveryErrorDescriptor)engineDescriptor).getCause()));
                continue;
            }
            this.execute(engineDescriptor, listener, discoveryResult.getConfigurationParameters(), testEngine);
        }
    }

    private TestExecutionListenerRegistry buildListenerRegistryForExecution(TestExecutionListener ... listeners) {
        if (listeners.length == 0) {
            return this.listenerRegistry;
        }
        TestExecutionListenerRegistry registry = new TestExecutionListenerRegistry(this.listenerRegistry);
        registry.registerListeners(listeners);
        return registry;
    }

    private void execute(TestDescriptor engineDescriptor, EngineExecutionListener listener, ConfigurationParameters configurationParameters, TestEngine testEngine) {
        OutcomeDelayingEngineExecutionListener delayingListener = new OutcomeDelayingEngineExecutionListener(listener, engineDescriptor);
        try {
            testEngine.execute(new ExecutionRequest(engineDescriptor, delayingListener, configurationParameters));
            delayingListener.reportEngineOutcome();
        }
        catch (Throwable throwable) {
            UnrecoverableExceptions.rethrowIfUnrecoverable(throwable);
            delayingListener.reportEngineFailure(new JUnitException(String.format("TestEngine with ID '%s' failed to execute tests", testEngine.getId()), throwable));
        }
    }
}

