/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation;

import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.data.instructions.ClassInstructions;
import com.intellij.rt.coverage.instrumentation.InstructionsEnumerator;
import com.intellij.rt.coverage.instrumentation.Instrumenter;
import com.intellij.rt.coverage.instrumentation.LineEnumerator;
import com.intellij.rt.coverage.instrumentation.data.BranchDataContainer;
import com.intellij.rt.coverage.instrumentation.filters.FilterUtils;
import com.intellij.rt.coverage.instrumentation.filters.enumerating.LineEnumeratorFilter;
import com.intellij.rt.coverage.util.LinesUtil;
import org.jetbrains.coverage.org.objectweb.asm.ClassVisitor;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;

public abstract class AbstractTracingInstrumenter
extends Instrumenter {
    protected final BranchDataContainer myBranchData = new BranchDataContainer(this);

    public AbstractTracingInstrumenter(ProjectData projectData, ClassVisitor classVisitor, String className, boolean shouldCalculateSource) {
        super(projectData, classVisitor, className, shouldCalculateSource);
    }

    protected MethodVisitor createMethodLineEnumerator(MethodVisitor mv, String name, String desc, int access, String signature, String[] exceptions) {
        this.myBranchData.resetMethod();
        LineEnumerator enumerator = this.myProjectData.isInstructionsCoverageEnabled() ? new InstructionsEnumerator(this, this.myBranchData, mv, access, name, desc, signature, exceptions) : new LineEnumerator(this, this.myBranchData, mv, access, name, desc, signature, exceptions);
        return this.chainFilters(name, desc, access, signature, exceptions, enumerator);
    }

    public abstract MethodVisitor createTouchCounter(MethodVisitor var1, BranchDataContainer var2, LineEnumerator var3, int var4, String var5, String var6, String var7);

    public void visitEnd() {
        super.visitEnd();
        if (this.myProjectData.isInstructionsCoverageEnabled()) {
            ClassInstructions classInstructions = new ClassInstructions(this.myClassData, this.myBranchData.getInstructions());
            this.myProjectData.getInstructions().put(this.myClassData.getName(), classInstructions);
        }
    }

    private MethodVisitor chainFilters(String name, String desc, int access, String signature, String[] exceptions, LineEnumerator enumerator) {
        MethodVisitor root = enumerator;
        for (LineEnumeratorFilter filter : FilterUtils.createLineEnumeratorFilters()) {
            if (!filter.isApplicable(this, access, name, desc, signature, exceptions)) continue;
            filter.initFilter(root, enumerator);
            root = filter;
        }
        return root;
    }

    protected void initLineData() {
        this.myClassData.setLines(LinesUtil.calcLineArray(this.myMaxLineNumber, this.myLines));
    }
}

