/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation;

import com.intellij.rt.coverage.util.ClassNameUtil;
import org.jetbrains.coverage.org.objectweb.asm.ClassReader;
import org.jetbrains.coverage.org.objectweb.asm.ClassVisitor;
import org.jetbrains.coverage.org.objectweb.asm.Label;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;

public abstract class ExtraFieldInstrumenter
extends ClassVisitor {
    protected static final int ADDED_CODE_STACK_SIZE = 6;
    private static final int INTERFACE_FIELD_ACCESS = 4121;
    private static final int CLASS_FIELD_ACCESS = 4234;
    private final String myFieldName;
    private final String myFieldType;
    protected final String myInternalClassName;
    private final boolean myJava8AndAbove;
    private final boolean myInterface;
    private final boolean myShouldCoverClinit;
    private boolean mySeenClinit = false;

    public ExtraFieldInstrumenter(ClassReader cr, ClassVisitor classVisitor, String className, String fieldName, String fieldType, boolean shouldCoverClinit) {
        super(589824, classVisitor);
        this.myFieldName = fieldName;
        this.myFieldType = fieldType;
        this.myInternalClassName = ClassNameUtil.convertToInternalName(className);
        this.myInterface = (cr.getAccess() & 0x200) != 0;
        this.myJava8AndAbove = (cr.readInt(4) & 0xFFFF) >= 52;
        this.myShouldCoverClinit = shouldCoverClinit;
    }

    public abstract void initField(MethodVisitor var1);

    public MethodVisitor createMethodVisitor(ClassVisitor cv, MethodVisitor mv, MethodVisitor newMv, String name) {
        if (mv == null) {
            return null;
        }
        if ("<clinit>".equals(name)) {
            if (this.myInterface && (this.myJava8AndAbove || this.myShouldCoverClinit)) {
                newMv = new MethodVisitor(589824, newMv){

                    public void visitCode() {
                        ExtraFieldInstrumenter.this.initField(this.mv);
                        ExtraFieldInstrumenter.this.mySeenClinit = true;
                        super.visitCode();
                    }
                };
            }
            if (!this.myShouldCoverClinit) {
                return newMv;
            }
        }
        if (this.myInterface) {
            return newMv;
        }
        return new MethodVisitor(589824, newMv){

            public void visitCode() {
                super.visitFieldInsn(178, ExtraFieldInstrumenter.this.myInternalClassName, ExtraFieldInstrumenter.this.myFieldName, ExtraFieldInstrumenter.this.myFieldType);
                Label alreadyInitialized = new Label();
                super.visitJumpInsn(199, alreadyInitialized);
                ExtraFieldInstrumenter.this.initField(this.mv);
                super.visitLabel(alreadyInitialized);
                super.visitCode();
            }
        };
    }

    protected MethodVisitor createMethodVisitor(MethodVisitor mv, MethodVisitor newMv, String name) {
        return this.createMethodVisitor(this, mv, newMv, name);
    }

    public void generateMembers(ClassVisitor cv) {
        if (this.myInterface) {
            if (!this.myJava8AndAbove && !this.mySeenClinit) {
                return;
            }
            cv.visitField(4121, this.myFieldName, this.myFieldType, null, null);
            if (this.mySeenClinit) {
                return;
            }
            this.generateExplicitClinitForInterfaces(cv);
        } else {
            cv.visitField(4234, this.myFieldName, this.myFieldType, null, null);
        }
    }

    protected void generateMembers() {
        this.generateMembers(this);
    }

    private void generateExplicitClinitForInterfaces(ClassVisitor cv) {
        MethodVisitor mv = cv.visitMethod(4105, "<clinit>", "()V", null, null);
        this.initField(mv);
        mv.visitInsn(177);
        mv.visitMaxs(6, 0);
        mv.visitEnd();
    }

    public String getInternalClassName() {
        return this.myInternalClassName;
    }

    public boolean isInterface() {
        return this.myInterface;
    }
}

