/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.filters.visiting;

import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.instrumentation.Instrumenter;
import com.intellij.rt.coverage.instrumentation.filters.enumerating.KotlinDefaultArgsBranchFilter;
import com.intellij.rt.coverage.instrumentation.filters.visiting.MethodVisitingFilter;
import com.intellij.rt.coverage.util.ClassNameUtil;
import org.jetbrains.coverage.org.objectweb.asm.Label;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;

public class KotlinDefaultArgsLineFilter
extends MethodVisitingFilter {
    private int myFirstLine = -1;
    private int myCurrentLine = -1;
    private int myState = 0;
    private boolean myHasInstructions = false;
    private String myName;
    private String myNameDesc;
    private int myMaxMaskIndex = -1;
    private int myMinMaskIndex = -1;

    public boolean isApplicable(Instrumenter context, int access, String name, String desc, String signature, String[] exceptions) {
        return KotlinDefaultArgsBranchFilter.isApplicable(context, access, name, desc);
    }

    public void initFilter(MethodVisitor methodVisitor, Instrumenter context, String name, String desc) {
        super.initFilter(methodVisitor, context, name, desc);
        this.myNameDesc = KotlinDefaultArgsBranchFilter.getOriginalNameAndDesc(name, desc);
        this.myName = this.myNameDesc.substring(0, this.myNameDesc.indexOf(40));
        int[] range = KotlinDefaultArgsBranchFilter.getMaskIndexRange(name, desc);
        this.myMinMaskIndex = range[0];
        this.myMaxMaskIndex = range[1];
    }

    public void visitLineNumber(int line, Label start) {
        if (this.myFirstLine == -1 && this.myContext.getLineData(line) == null) {
            this.myHasInstructions = false;
            this.myFirstLine = line;
        }
        this.myCurrentLine = line;
        super.visitLineNumber(line, start);
        LineData lineData = this.myContext.getLineData(line);
        if (lineData != null) {
            lineData.setMethodSignature(this.myNameDesc);
        }
    }

    public void visitEnd() {
        if (this.myFirstLine != -1 && !this.myHasInstructions) {
            this.myContext.removeLine(this.myFirstLine);
        }
        super.visitEnd();
    }

    public void visitVarInsn(int opcode, int var) {
        super.visitVarInsn(opcode, var);
        if (this.myCurrentLine != this.myFirstLine) {
            return;
        }
        if (this.myState == 0 && this.myMinMaskIndex <= var && var <= this.myMaxMaskIndex) {
            this.myState = 1;
            return;
        }
        if ((this.myState == 0 || this.myState == 10) && var < this.myMinMaskIndex) {
            this.myState = 10;
            return;
        }
        this.myHasInstructions = true;
    }

    public void visitInsn(int opcode) {
        super.visitInsn(opcode);
        if (this.myCurrentLine != this.myFirstLine) {
            return;
        }
        if (this.myState == 2 && opcode == 126) {
            this.myState = 3;
            return;
        }
        if (this.myState == 1 && (opcode == 4 || opcode == 5 || opcode == 7)) {
            this.myState = 2;
            return;
        }
        if (this.myState == 11 && 172 <= opcode && opcode <= 177) {
            return;
        }
        this.myHasInstructions = true;
    }

    public void visitIntInsn(int opcode, int operand) {
        super.visitIntInsn(opcode, operand);
        if (this.myCurrentLine != this.myFirstLine) {
            return;
        }
        if (this.myState == 1 && (opcode == 16 || opcode == 17)) {
            this.myState = 2;
            return;
        }
        this.myHasInstructions = true;
    }

    public void visitLdcInsn(Object value) {
        super.visitLdcInsn(value);
        if (this.myCurrentLine != this.myFirstLine) {
            return;
        }
        if (this.myState == 1 && value instanceof Integer) {
            this.myState = 2;
            return;
        }
        this.myHasInstructions = true;
    }

    public void visitJumpInsn(int opcode, Label label) {
        super.visitJumpInsn(opcode, label);
        if (this.myCurrentLine != this.myFirstLine) {
            return;
        }
        if (this.myState == 3 && opcode == 153) {
            this.myState = 0;
            return;
        }
        this.myHasInstructions = true;
    }

    public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
        super.visitFieldInsn(opcode, owner, name, descriptor);
        if (this.myCurrentLine != this.myFirstLine) {
            return;
        }
        this.myHasInstructions = true;
    }

    public void visitIincInsn(int var, int increment) {
        super.visitIincInsn(var, increment);
        if (this.myCurrentLine != this.myFirstLine) {
            return;
        }
        this.myHasInstructions = true;
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        super.visitLookupSwitchInsn(dflt, keys, labels);
        if (this.myCurrentLine != this.myFirstLine) {
            return;
        }
        this.myHasInstructions = true;
    }

    public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
        super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
        if (this.myCurrentLine != this.myFirstLine) {
            return;
        }
        if (this.myState == 10 && this.myName.equals(name) && ClassNameUtil.convertToInternalName(this.myContext.getClassName()).equals(owner)) {
            this.myState = 11;
            return;
        }
        this.myHasInstructions = true;
    }

    public void visitMultiANewArrayInsn(String descriptor, int numDimensions) {
        super.visitMultiANewArrayInsn(descriptor, numDimensions);
        if (this.myCurrentLine != this.myFirstLine) {
            return;
        }
        this.myHasInstructions = true;
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        super.visitTableSwitchInsn(min, max, dflt, labels);
        if (this.myCurrentLine != this.myFirstLine) {
            return;
        }
        this.myHasInstructions = true;
    }

    public void visitTypeInsn(int opcode, String type) {
        super.visitTypeInsn(opcode, type);
        if (this.myCurrentLine != this.myFirstLine) {
            return;
        }
        this.myHasInstructions = true;
    }
}

