/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.compilerRunner;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.Stack;
import java.io.IOException;
import java.io.Reader;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageCollectorUtil;
import org.jetbrains.kotlin.cli.common.messages.OutputMessageUtil;
import org.jetbrains.kotlin.compilerRunner.OutputItemsCollector;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/compilerRunner/CompilerOutputParser;", "", "()V", "parseCompilerMessagesFromReader", "", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "reader", "Ljava/io/Reader;", "collector", "Lorg/jetbrains/kotlin/compilerRunner/OutputItemsCollector;", "CompilerOutputSAXHandler", "kotlin-compiler-runner-unshaded"})
public final class CompilerOutputParser {
    @NotNull
    public static final CompilerOutputParser INSTANCE = new CompilerOutputParser();

    private CompilerOutputParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void parseCompilerMessagesFromReader(@NotNull MessageCollector messageCollector, @NotNull Reader reader, @NotNull OutputItemsCollector collector) {
        Intrinsics.checkNotNullParameter((Object)messageCollector, (String)"messageCollector");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)collector, (String)"collector");
        StringBuilder stringBuilder = new StringBuilder();
        Reader wrappingReader2 = new Reader(reader, stringBuilder){
            final /* synthetic */ Reader $reader;
            final /* synthetic */ StringBuilder $stringBuilder;
            {
                this.$reader = $reader;
                this.$stringBuilder = $stringBuilder;
            }

            public int read(@NotNull char[] cbuf, int off, int len) throws IOException {
                Intrinsics.checkNotNullParameter((Object)cbuf, (String)"cbuf");
                int read2 = this.$reader.read(cbuf, off, len);
                this.$stringBuilder.append(cbuf, off, len);
                return read2;
            }

            public void close() throws IOException {
            }
        };
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            SAXParser parser = factory.newSAXParser();
            parser.parse(new InputSource(wrappingReader2), (DefaultHandler)new CompilerOutputSAXHandler(messageCollector, collector));
        }
        catch (Throwable e) {
            try {
                FileUtil.loadTextAndClose((Reader)wrappingReader2);
            }
            catch (IOException ioException) {
                MessageCollectorUtil.reportException(messageCollector, ioException);
            }
            String string2 = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"stringBuilder.toString()");
            String message = string2;
            MessageCollectorUtil.reportException(messageCollector, new IllegalStateException(message, e));
            MessageCollector.DefaultImpls.report$default(messageCollector, CompilerMessageSeverity.ERROR, message, null, 4, null);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                MessageCollectorUtil.reportException(messageCollector, e);
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0019\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000  2\u00020\u0001:\u0001 B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\bH\u0016J\"\u0010\u0017\u001a\u00020\u00122\b\u0010\u0018\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u000eH\u0016J\u0010\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u000eH\u0002J(\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00060\u000bj\u0002`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/compilerRunner/CompilerOutputParser$CompilerOutputSAXHandler;", "Lorg/xml/sax/helpers/DefaultHandler;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "collector", "Lorg/jetbrains/kotlin/compilerRunner/OutputItemsCollector;", "(Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;Lorg/jetbrains/kotlin/compilerRunner/OutputItemsCollector;)V", "column", "", "line", "message", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "path", "", "tags", "Lcom/intellij/util/containers/Stack;", "characters", "", "ch", "", "start", "length", "endElement", "uri", "localName", "qName", "reportToCollector", "text", "startElement", "attributes", "Lorg/xml/sax/Attributes;", "Companion", "kotlin-compiler-runner-unshaded"})
    private static final class CompilerOutputSAXHandler
    extends DefaultHandler {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final MessageCollector messageCollector;
        @NotNull
        private final OutputItemsCollector collector;
        @NotNull
        private final StringBuilder message;
        @NotNull
        private final Stack<String> tags;
        @Nullable
        private String path;
        private int line;
        private int column;
        @NotNull
        private static final Map<String, CompilerMessageSeverity> CATEGORIES;

        public CompilerOutputSAXHandler(@NotNull MessageCollector messageCollector, @NotNull OutputItemsCollector collector) {
            Intrinsics.checkNotNullParameter((Object)messageCollector, (String)"messageCollector");
            Intrinsics.checkNotNullParameter((Object)collector, (String)"collector");
            this.messageCollector = messageCollector;
            this.collector = collector;
            this.message = new StringBuilder();
            this.tags = new Stack();
        }

        @Override
        public void startElement(@NotNull String uri, @NotNull String localName, @NotNull String qName, @NotNull Attributes attributes) throws SAXException {
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            Intrinsics.checkNotNullParameter((Object)localName, (String)"localName");
            Intrinsics.checkNotNullParameter((Object)qName, (String)"qName");
            Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
            this.tags.push((Object)qName);
            this.message.setLength(0);
            this.path = attributes.getValue("path");
            this.line = CompilerOutputSAXHandler.Companion.safeParseInt(attributes.getValue("line"), -1);
            this.column = CompilerOutputSAXHandler.Companion.safeParseInt(attributes.getValue("column"), -1);
        }

        @Override
        public void characters(@Nullable char[] ch, int start, int length) throws SAXException {
            if (this.tags.size() == 1) {
                String message;
                Intrinsics.checkNotNull((Object)ch);
                String $this$trim$iv = message = new String(ch, start, length);
                boolean $i$f$trim = false;
                CharSequence $this$trim$iv$iv = $this$trim$iv;
                boolean $i$f$trim2 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                if (!(((CharSequence)((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()).length() == 0)) {
                    MessageCollector.DefaultImpls.report$default(this.messageCollector, CompilerMessageSeverity.ERROR, "Unhandled compiler output: " + message, null, 4, null);
                }
            } else {
                this.message.append(ch, start, length);
            }
        }

        @Override
        public void endElement(@Nullable String uri, @NotNull String localName, @NotNull String qName) throws SAXException {
            Intrinsics.checkNotNullParameter((Object)localName, (String)"localName");
            Intrinsics.checkNotNullParameter((Object)qName, (String)"qName");
            if (this.tags.size() == 1) {
                return;
            }
            String string2 = qName.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            String qNameLowerCase = string2;
            CompilerMessageSeverity category = CATEGORIES.get(qNameLowerCase);
            if (category == null) {
                MessageCollector.DefaultImpls.report$default(this.messageCollector, CompilerMessageSeverity.ERROR, "Unknown compiler message tag: " + qName, null, 4, null);
                category = CompilerMessageSeverity.INFO;
            }
            String string3 = this.message.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message.toString()");
            String text = string3;
            if (category == CompilerMessageSeverity.OUTPUT) {
                this.reportToCollector(text);
            } else {
                this.messageCollector.report(category, text, CompilerMessageLocation.Companion.create(this.path, this.line, this.column, null));
            }
            this.tags.pop();
        }

        private final void reportToCollector(String text) {
            OutputMessageUtil.Output output = OutputMessageUtil.parseOutputMessage(text);
            if (output != null) {
                this.collector.add(output.sourceFiles, output.outputFile);
            }
        }

        static {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"error", (Object)((Object)CompilerMessageSeverity.ERROR)), TuplesKt.to((Object)"warning", (Object)((Object)CompilerMessageSeverity.WARNING)), TuplesKt.to((Object)"logging", (Object)((Object)CompilerMessageSeverity.LOGGING)), TuplesKt.to((Object)"output", (Object)((Object)CompilerMessageSeverity.OUTPUT)), TuplesKt.to((Object)"exception", (Object)((Object)CompilerMessageSeverity.EXCEPTION)), TuplesKt.to((Object)"info", (Object)((Object)CompilerMessageSeverity.INFO)), TuplesKt.to((Object)"messages", (Object)((Object)CompilerMessageSeverity.INFO))};
            CATEGORIES = MapsKt.mapOf((Pair[])pairArray);
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\bH\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/compilerRunner/CompilerOutputParser$CompilerOutputSAXHandler$Companion;", "", "()V", "CATEGORIES", "", "", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity;", "safeParseInt", "", "value", "defaultValue", "kotlin-compiler-runner-unshaded"})
        public static final class Companion {
            private Companion() {
            }

            private final int safeParseInt(String value2, int defaultValue) {
                if (value2 == null) {
                    return defaultValue;
                }
                try {
                    String $this$trim$iv = value2;
                    boolean $i$f$trim = false;
                    CharSequence $this$trim$iv$iv = $this$trim$iv;
                    boolean $i$f$trim2 = false;
                    int startIndex$iv$iv = 0;
                    int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                    boolean startFound$iv$iv = false;
                    while (startIndex$iv$iv <= endIndex$iv$iv) {
                        boolean match$iv$iv;
                        int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                        char it = $this$trim$iv$iv.charAt(index$iv$iv);
                        boolean bl = false;
                        boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                        if (!startFound$iv$iv) {
                            if (!match$iv$iv) {
                                startFound$iv$iv = true;
                                continue;
                            }
                            ++startIndex$iv$iv;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv;
                    }
                    return Integer.parseInt(((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString());
                }
                catch (NumberFormatException e) {
                    return defaultValue;
                }
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

