/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xsltDebugger.rt.engine;

import java.util.List;
import org.intellij.plugins.xsltDebugger.rt.engine.BreakpointManager;
import org.intellij.plugins.xsltDebugger.rt.engine.OutputEventQueue;
import org.intellij.plugins.xsltDebugger.rt.engine.Value;
import org.intellij.plugins.xsltDebugger.rt.engine.Watchable;

public interface Debugger
extends Watchable {
    public State getState();

    public boolean start();

    public void stop(boolean var1);

    public void step();

    public void stepInto();

    public void resume();

    public void pause();

    public boolean isStopped();

    public StyleFrame getCurrentFrame();

    public SourceFrame getSourceFrame();

    public Value eval(String var1) throws EvaluationException;

    public List<Variable> getGlobalVariables();

    public BreakpointManager getBreakpointManager();

    public OutputEventQueue getEventQueue();

    public boolean waitForDebuggee();

    public State waitForStateChange(State var1);

    public static class EvaluationException
    extends Exception {
        public EvaluationException(String message) {
            super(message);
        }
    }

    public static interface Variable
    extends Locatable {
        public boolean isGlobal();

        public Kind getKind();

        public String getName();

        public Value getValue();

        public static enum Kind {
            VARIABLE,
            PARAMETER,
            EXPRESSION;

        }
    }

    public static interface SourceFrame
    extends Frame<SourceFrame> {
        public String getXPath();
    }

    public static interface StyleFrame
    extends Frame<StyleFrame> {
        public String getInstruction();

        public Value eval(String var1) throws EvaluationException;

        public List<Variable> getVariables();
    }

    public static interface Frame<T extends Frame>
    extends Locatable {
        public T getNext();

        public T getPrevious();
    }

    public static interface Locatable {
        public String getURI();

        public int getLineNumber();
    }

    public static enum State {
        CREATED,
        RUNNING,
        SUSPENDED,
        STOPPED;

    }
}

