/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xsltDebugger.rt.engine;

import java.io.Serializable;
import java.util.List;

public interface OutputEventQueue {
    public static final int START_DOCUMENT = 0;
    public static final int END_DOCUMENT = 99;
    public static final int START_ELEMENT = 1;
    public static final int END_ELEMENT = 2;
    public static final int ATTRIBUTE = 3;
    public static final int CHARACTERS = 4;
    public static final int COMMENT = 5;
    public static final int PI = 6;
    public static final int TRACE_POINT = 20;

    public void setEnabled(boolean var1);

    public List<NodeEvent> getEvents();

    public static final class NodeEvent
    implements Serializable {
        private final int myType;
        public String myValue;
        public QName myQName;
        public String myURI;
        private int myLineNumber;

        public NodeEvent(int type, QName qName, String value) {
            this.myType = type;
            this.myQName = qName;
            this.myValue = value;
        }

        public int getType() {
            return this.myType;
        }

        public QName getQName() {
            return this.myQName;
        }

        public String getValue() {
            return this.myValue;
        }

        public void setLocation(String uri, int lineNumber) {
            this.myURI = uri;
            this.myLineNumber = lineNumber;
        }

        public int getLineNumber() {
            return this.myLineNumber;
        }

        public String getURI() {
            return this.myURI;
        }

        public static final class QName
        implements Serializable {
            public String myPrefix;
            public String myLocalName;
            public String myURI;

            public QName(String prefix, String localName, String URI2) {
                this.myPrefix = prefix;
                this.myLocalName = localName;
                this.myURI = URI2;
            }

            public QName(String qName, String uri) {
                this.myURI = uri;
                String[] parts = qName.split(":");
                if (parts.length == 2) {
                    this.myPrefix = parts[0];
                    this.myLocalName = parts[1];
                } else {
                    this.myPrefix = null;
                    this.myLocalName = parts[0];
                }
            }

            public QName(String name) {
                this.myLocalName = name;
                this.myPrefix = null;
                this.myURI = null;
            }

            public String getQName() {
                return this.myPrefix != null && this.myPrefix.length() > 0 ? this.myPrefix + ":" + this.myLocalName : this.myLocalName;
            }
        }
    }
}

