/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.actions.AbstractBatchSuppressByNoInspectionCommentFix;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocCommentOwner;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationArrayInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeParameter;

public class SuppressForMemberFix
extends AbstractBatchSuppressByNoInspectionCommentFix {
    @PropertyKey(resourceBundle="messages.JavaAnalysisBundle")
    private @PropertyKey(resourceBundle="messages.JavaAnalysisBundle") String myKey = "suppress.inspection.member";
    private final boolean myForClass;

    public SuppressForMemberFix(String toolId, boolean forClass) {
        super(toolId, false);
        this.myForClass = forClass;
    }

    @Nullable
    public GrDocCommentOwner getContainer(PsiElement context) {
        if (context == null || context instanceof PsiFile) {
            return null;
        }
        GrDocCommentOwner container = null;
        GrDocComment docComment = (GrDocComment)PsiTreeUtil.getParentOfType((PsiElement)context, GrDocComment.class);
        if (docComment != null) {
            container = docComment.getOwner();
        }
        if (container == null) {
            container = (GrDocCommentOwner)PsiTreeUtil.getParentOfType((PsiElement)context, GrDocCommentOwner.class);
        }
        while (container instanceof GrAnonymousClassDefinition || container instanceof GrTypeParameter) {
            if ((container = (GrDocCommentOwner)PsiTreeUtil.getParentOfType((PsiElement)container, GrDocCommentOwner.class)) != null) continue;
            return null;
        }
        if (this.myForClass) {
            while (container != null) {
                GrTypeDefinition parentClass = (GrTypeDefinition)PsiTreeUtil.getParentOfType((PsiElement)container, GrTypeDefinition.class);
                if (parentClass == null && container instanceof GrTypeDefinition) {
                    return container;
                }
                container = parentClass;
            }
        }
        return container;
    }

    @NotNull
    public String getText() {
        String string = JavaAnalysisBundle.message((String)this.myKey, (Object[])new Object[0]);
        if (string == null) {
            SuppressForMemberFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiElement context) {
        GrDocCommentOwner container;
        if (project == null) {
            SuppressForMemberFix.$$$reportNull$$$0(1);
        }
        if (context == null) {
            SuppressForMemberFix.$$$reportNull$$$0(2);
        }
        this.myKey = (container = this.getContainer(context)) instanceof PsiClass ? "suppress.inspection.class" : (container instanceof PsiMethod ? "suppress.inspection.method" : "suppress.inspection.field");
        return container != null && context.getManager().isInProject(context);
    }

    protected boolean replaceSuppressionComments(PsiElement container) {
        return false;
    }

    protected void createSuppression(@NotNull Project project, @NotNull PsiElement element, @NotNull PsiElement container) throws IncorrectOperationException {
        GrModifierList modifierList;
        if (project == null) {
            SuppressForMemberFix.$$$reportNull$$$0(3);
        }
        if (element == null) {
            SuppressForMemberFix.$$$reportNull$$$0(4);
        }
        if (container == null) {
            SuppressForMemberFix.$$$reportNull$$$0(5);
        }
        if ((modifierList = (GrModifierList)((PsiModifierListOwner)container).getModifierList()) != null) {
            SuppressForMemberFix.addSuppressAnnotation(project, modifierList, this.myID);
        }
        DaemonCodeAnalyzer.getInstance((Project)project).restart();
    }

    private static void addSuppressAnnotation(Project project, GrModifierList modifierList, String id) throws IncorrectOperationException {
        PsiAnnotation annotation = modifierList.findAnnotation("java.lang.SuppressWarnings");
        GrExpression toAdd = GroovyPsiElementFactory.getInstance(project).createExpressionFromText("'" + id + "'");
        if (annotation != null) {
            PsiAnnotationMemberValue value = annotation.findDeclaredAttributeValue(null);
            if (value instanceof GrAnnotationArrayInitializer) {
                value.add((PsiElement)toAdd);
            } else if (value != null) {
                GrAnnotation anno = GroovyPsiElementFactory.getInstance(project).createAnnotationFromText("@A([])");
                GrAnnotationArrayInitializer list = (GrAnnotationArrayInitializer)anno.findDeclaredAttributeValue(null);
                list.add((PsiElement)value);
                list.add(toAdd);
                annotation.setDeclaredAttributeValue(null, (PsiAnnotationMemberValue)list);
            }
        } else {
            modifierList.addAnnotation("java.lang.SuppressWarnings").setDeclaredAttributeValue(null, (PsiAnnotationMemberValue)toAdd);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/SuppressForMemberFix";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/SuppressForMemberFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createSuppression";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

